/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.api;

import com.ctc.wstx.api.CommonConfig;
import com.ctc.wstx.cfg.OutputConfigFlags;
import com.ctc.wstx.io.BufferRecycler;
import com.ctc.wstx.util.ArgUtil;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import javax.xml.stream.XMLReporter;
import org.codehaus.stax2.io.EscapingWriterFactory;

public final class WriterConfig
extends CommonConfig
implements OutputConfigFlags {
    protected static final String DEFAULT_AUTOMATIC_NS_PREFIX = "wstxns";
    static final int PROP_AUTOMATIC_NS = 1;
    static final int PROP_AUTOMATIC_EMPTY_ELEMS = 2;
    static final int PROP_ENABLE_NS = 3;
    static final int PROP_AUTOMATIC_NS_PREFIX = 4;
    static final int PROP_TEXT_ESCAPER = 5;
    static final int PROP_ATTR_VALUE_ESCAPER = 6;
    static final int PROP_PROBLEM_REPORTER = 7;
    static final int PROP_OUTPUT_CDATA_AS_TEXT = 11;
    static final int PROP_COPY_DEFAULT_ATTRS = 12;
    static final int PROP_ESCAPE_CR = 13;
    static final int PROP_VALIDATE_STRUCTURE = 15;
    static final int PROP_VALIDATE_CONTENT = 16;
    static final int PROP_VALIDATE_ATTR = 17;
    static final int PROP_VALIDATE_NAMES = 18;
    static final int PROP_FIX_CONTENT = 19;
    static final boolean DEFAULT_ENABLE_NS = true;
    static final boolean DEFAULT_AUTOMATIC_EMPTY_ELEMS = true;
    static final boolean DEFAULT_OUTPUT_CDATA_AS_TEXT = false;
    static final boolean DEFAULT_COPY_DEFAULT_ATTRS = false;
    static final boolean DEFAULT_ESCAPE_CR = true;
    static final boolean DEFAULT_VALIDATE_STRUCTURE = true;
    static final boolean DEFAULT_VALIDATE_CONTENT = true;
    static final boolean DEFAULT_VALIDATE_ATTR = false;
    static final boolean DEFAULT_VALIDATE_NAMES = false;
    static final boolean DEFAULT_FIX_CONTENT = true;
    static final int DEFAULT_FLAGS_J2ME = 4901;
    static final int DEFAULT_FLAGS_FULL = 4901;
    static final HashMap sProperties = new HashMap(8);
    final boolean mIsJ2MESubset;
    protected int mConfigFlags;
    Object[] mSpecialProperties = null;
    private static final int SPEC_PROC_COUNT = 4;
    private static final int SP_IX_AUTO_NS_PREFIX = 0;
    private static final int SP_IX_TEXT_ESCAPER_FACTORY = 1;
    private static final int SP_IX_ATTR_VALUE_ESCAPER_FACTORY = 2;
    private static final int SP_IX_PROBLEM_REPORTER = 3;
    static final ThreadLocal mRecyclerRef;
    BufferRecycler mCurrRecycler = null;
    static int Counter;

    private WriterConfig(boolean j2meSubset, int flags, Object[] specProps) {
        this.mIsJ2MESubset = j2meSubset;
        this.mConfigFlags = flags;
        this.mSpecialProperties = specProps;
        SoftReference ref = (SoftReference)mRecyclerRef.get();
        if (ref != null) {
            this.mCurrRecycler = (BufferRecycler)ref.get();
        }
    }

    public static WriterConfig createJ2MEDefaults() {
        return new WriterConfig(true, 4901, null);
    }

    public static WriterConfig createFullDefaults() {
        return new WriterConfig(true, 4901, null);
    }

    public WriterConfig createNonShared() {
        Object[] specProps;
        if (this.mSpecialProperties != null) {
            int len = this.mSpecialProperties.length;
            specProps = new Object[len];
            System.arraycopy(this.mSpecialProperties, 0, specProps, 0, len);
        } else {
            specProps = null;
        }
        return new WriterConfig(this.mIsJ2MESubset, this.mConfigFlags, specProps);
    }

    protected int findPropertyId(String propName) {
        Integer I = (Integer)sProperties.get(propName);
        return I == null ? -1 : I;
    }

    public Object getProperty(int id) {
        switch (id) {
            case 1: {
                return this.automaticNamespacesEnabled() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 3: {
                return this.willSupportNamespaces() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 7: {
                return this.getProblemReporter();
            }
            case 2: {
                return this.automaticEmptyElementsEnabled() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 4: {
                return this.getAutomaticNsPrefix();
            }
            case 5: {
                return this.getTextEscaperFactory();
            }
            case 6: {
                return this.getAttrValueEscaperFactory();
            }
            case 11: {
                return this.willOutputCDataAsText() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 12: {
                return this.willCopyDefaultAttrs() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 13: {
                return this.willEscapeCr() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 15: {
                return this.willValidateStructure() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 16: {
                return this.willValidateContent() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 17: {
                return this.willValidateAttributes() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 18: {
                return this.willValidateNames() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 19: {
                return this.willFixContent() ? Boolean.TRUE : Boolean.FALSE;
            }
        }
        throw new Error("Internal error: no handler for property with internal id " + id + ".");
    }

    public boolean setProperty(String name, int id, Object value) {
        switch (id) {
            case 1: {
                this.enableAutomaticNamespaces(ArgUtil.convertToBoolean(name, value));
                break;
            }
            case 3: {
                this.doSupportNamespaces(ArgUtil.convertToBoolean(name, value));
                break;
            }
            case 7: {
                this.setProblemReporter((XMLReporter)value);
                break;
            }
            case 2: {
                this.enableAutomaticEmptyElements(ArgUtil.convertToBoolean(name, value));
                break;
            }
            case 4: {
                this.setAutomaticNsPrefix(value.toString());
                break;
            }
            case 5: {
                this.setTextEscaperFactory((EscapingWriterFactory)value);
                break;
            }
            case 6: {
                this.setAttrValueEscaperFactory((EscapingWriterFactory)value);
                break;
            }
            case 11: {
                this.doOutputCDataAsText(ArgUtil.convertToBoolean(name, value));
                break;
            }
            case 12: {
                this.doCopyDefaultAttrs(ArgUtil.convertToBoolean(name, value));
                break;
            }
            case 13: {
                this.doEscapeCr(ArgUtil.convertToBoolean(name, value));
                break;
            }
            case 15: {
                this.doValidateStructure(ArgUtil.convertToBoolean(name, value));
                break;
            }
            case 16: {
                this.doValidateContent(ArgUtil.convertToBoolean(name, value));
                break;
            }
            case 17: {
                this.doValidateAttributes(ArgUtil.convertToBoolean(name, value));
                break;
            }
            case 18: {
                this.doValidateNames(ArgUtil.convertToBoolean(name, value));
                break;
            }
            case 19: {
                this.doFixContent(ArgUtil.convertToBoolean(name, value));
                break;
            }
            default: {
                throw new Error("Internal error: no handler for property with internal id " + id + ".");
            }
        }
        return true;
    }

    public int getConfigFlags() {
        return this.mConfigFlags;
    }

    public boolean automaticNamespacesEnabled() {
        return this.hasConfigFlag(2);
    }

    public boolean automaticEmptyElementsEnabled() {
        return this.hasConfigFlag(4);
    }

    public boolean willSupportNamespaces() {
        return this.hasConfigFlag(1);
    }

    public boolean willOutputCDataAsText() {
        return this.hasConfigFlag(8);
    }

    public boolean willCopyDefaultAttrs() {
        return this.hasConfigFlag(16);
    }

    public boolean willEscapeCr() {
        return this.hasConfigFlag(32);
    }

    public boolean willValidateStructure() {
        return this.hasConfigFlag(256);
    }

    public boolean willValidateContent() {
        return this.hasConfigFlag(512);
    }

    public boolean willValidateAttributes() {
        return this.hasConfigFlag(2048);
    }

    public boolean willValidateNames() {
        return this.hasConfigFlag(1024);
    }

    public boolean willFixContent() {
        return this.hasConfigFlag(4096);
    }

    public String getAutomaticNsPrefix() {
        String prefix = (String)this.getSpecialProperty(0);
        if (prefix == null) {
            prefix = DEFAULT_AUTOMATIC_NS_PREFIX;
        }
        return prefix;
    }

    public EscapingWriterFactory getTextEscaperFactory() {
        return (EscapingWriterFactory)this.getSpecialProperty(1);
    }

    public EscapingWriterFactory getAttrValueEscaperFactory() {
        return (EscapingWriterFactory)this.getSpecialProperty(2);
    }

    public XMLReporter getProblemReporter() {
        return (XMLReporter)this.getSpecialProperty(3);
    }

    public void enableAutomaticNamespaces(boolean state) {
        this.setConfigFlag(2, state);
    }

    public void enableAutomaticEmptyElements(boolean state) {
        this.setConfigFlag(4, state);
    }

    public void doSupportNamespaces(boolean state) {
        this.setConfigFlag(1, state);
    }

    public void doOutputCDataAsText(boolean state) {
        this.setConfigFlag(8, state);
    }

    public void doCopyDefaultAttrs(boolean state) {
        this.setConfigFlag(16, state);
    }

    public void doEscapeCr(boolean state) {
        this.setConfigFlag(32, state);
    }

    public void doValidateStructure(boolean state) {
        this.setConfigFlag(256, state);
    }

    public void doValidateContent(boolean state) {
        this.setConfigFlag(512, state);
    }

    public void doValidateAttributes(boolean state) {
        this.setConfigFlag(2048, state);
    }

    public void doValidateNames(boolean state) {
        this.setConfigFlag(1024, state);
    }

    public void doFixContent(boolean state) {
        this.setConfigFlag(4096, state);
    }

    public void setAutomaticNsPrefix(String prefix) {
        this.setSpecialProperty(0, prefix);
    }

    public void setTextEscaperFactory(EscapingWriterFactory f) {
        this.setSpecialProperty(1, f);
    }

    public void setAttrValueEscaperFactory(EscapingWriterFactory f) {
        this.setSpecialProperty(2, f);
    }

    public void setProblemReporter(XMLReporter rep) {
        this.setSpecialProperty(3, rep);
    }

    public void configureForXmlConformance() {
        this.doValidateAttributes(true);
        this.doValidateContent(true);
        this.doValidateStructure(true);
        this.doValidateNames(true);
    }

    public void configureForRobustness() {
        this.doValidateAttributes(true);
        this.doValidateStructure(true);
        this.doValidateNames(true);
        this.doValidateContent(true);
        this.doFixContent(true);
    }

    public void configureForSpeed() {
        this.doValidateAttributes(false);
        this.doValidateContent(false);
        this.doValidateNames(false);
    }

    public char[] allocMediumCBuffer(int minSize) {
        char[] result;
        if (this.mCurrRecycler != null && (result = this.mCurrRecycler.getMediumCBuffer(minSize)) != null) {
            return result;
        }
        return new char[minSize];
    }

    public void freeMediumCBuffer(char[] buffer) {
        if (this.mCurrRecycler == null) {
            this.mCurrRecycler = this.createRecycler();
        }
        this.mCurrRecycler.returnMediumCBuffer(buffer);
    }

    public char[] allocFullCBuffer(int minSize) {
        char[] result;
        if (this.mCurrRecycler != null && (result = this.mCurrRecycler.getFullCBuffer(minSize)) != null) {
            return result;
        }
        return new char[minSize];
    }

    public void freeFullCBuffer(char[] buffer) {
        if (this.mCurrRecycler == null) {
            this.mCurrRecycler = this.createRecycler();
        }
        this.mCurrRecycler.returnFullCBuffer(buffer);
    }

    public byte[] allocFullBBuffer(int minSize) {
        byte[] result;
        if (this.mCurrRecycler != null && (result = this.mCurrRecycler.getFullBBuffer(minSize)) != null) {
            return result;
        }
        return new byte[minSize];
    }

    public void freeFullBBuffer(byte[] buffer) {
        if (this.mCurrRecycler == null) {
            this.mCurrRecycler = this.createRecycler();
        }
        this.mCurrRecycler.returnFullBBuffer(buffer);
    }

    private BufferRecycler createRecycler() {
        BufferRecycler recycler = new BufferRecycler();
        mRecyclerRef.set(new SoftReference<BufferRecycler>(recycler));
        return recycler;
    }

    private void setConfigFlag(int flag, boolean state) {
        this.mConfigFlags = state ? (this.mConfigFlags |= flag) : (this.mConfigFlags &= ~flag);
    }

    private final boolean hasConfigFlag(int flag) {
        return (this.mConfigFlags & flag) == flag;
    }

    private final Object getSpecialProperty(int ix) {
        if (this.mSpecialProperties == null) {
            return null;
        }
        return this.mSpecialProperties[ix];
    }

    private final void setSpecialProperty(int ix, Object value) {
        if (this.mSpecialProperties == null) {
            this.mSpecialProperties = new Object[4];
        }
        this.mSpecialProperties[ix] = value;
    }

    static {
        sProperties.put("javax.xml.stream.isRepairingNamespaces", new Integer(1));
        sProperties.put("javax.xml.stream.isNamespaceAware", new Integer(3));
        sProperties.put("org.codehaus.stax2.automaticEmptyElements", new Integer(2));
        sProperties.put("org.codehaus.stax2.automaticNsPrefix", new Integer(4));
        sProperties.put("org.codehaus.stax2.textEscaper", new Integer(5));
        sProperties.put("org.codehaus.stax2.attrValueEscaper", new Integer(6));
        sProperties.put("javax.xml.stream.reporter", new Integer(7));
        sProperties.put("com.ctc.wstx.outputCDataAsText", new Integer(11));
        sProperties.put("com.ctc.wstx.copyDefaultAttrs", new Integer(12));
        sProperties.put("com.ctc.wstx.outputEscapeCr", new Integer(13));
        sProperties.put("com.ctc.wstx.outputValidateStructure", new Integer(15));
        sProperties.put("com.ctc.wstx.outputValidateContent", new Integer(16));
        sProperties.put("com.ctc.wstx.outputValidateAttr", new Integer(17));
        sProperties.put("com.ctc.wstx.outputValidateNames", new Integer(18));
        sProperties.put("com.ctc.wstx.outputFixContent", new Integer(19));
        mRecyclerRef = new ThreadLocal();
        Counter = 0;
    }
}

