/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.generator;

import java.util.ArrayList;
import java.util.Random;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.option.OptionGroup;

public class LandGenerator {
    private final OptionGroup mapGeneratorOptions;
    private final Random random;
    private boolean[][] map;
    private int width;
    private int height;
    private int landMass;
    private int preferredDistanceToEdge;
    private int numberOfLandTiles;
    private int minimumNumberOfTiles;
    private int genType;

    public LandGenerator(OptionGroup mapGeneratorOptions, Random random) {
        this.mapGeneratorOptions = mapGeneratorOptions;
        this.random = random;
    }

    public static boolean[][] importLandMap(Game game) {
        boolean[][] map = new boolean[game.getMap().getWidth()][game.getMap().getHeight()];
        for (int i = 0; i < map.length; ++i) {
            for (int j = 0; j < map[0].length; ++j) {
                map[i][j] = game.getMap().getTile(i, j).isLand();
            }
        }
        return map;
    }

    public boolean[][] createLandMap() {
        this.width = this.mapGeneratorOptions.getInteger("model.option.mapWidth");
        this.height = this.mapGeneratorOptions.getInteger("model.option.mapHeight");
        this.preferredDistanceToEdge = this.mapGeneratorOptions.getInteger("model.option.preferredDistanceToEdge");
        this.landMass = this.mapGeneratorOptions.getInteger("model.option.landMass");
        this.minimumNumberOfTiles = this.width * this.height * this.landMass / 100;
        this.genType = this.mapGeneratorOptions.getInteger("model.option.landGeneratorType");
        this.map = new boolean[this.width][this.height];
        this.numberOfLandTiles = 0;
        switch (this.genType) {
            case 0: {
                this.createClassicLandMap();
                break;
            }
            case 1: {
                this.addPolarRegions();
                int contsize = this.minimumNumberOfTiles * 75 / 100;
                this.addLandmass(contsize, contsize, this.width / 2, this.random.nextInt(this.height / 2) + this.height / 4);
                while (this.numberOfLandTiles < this.minimumNumberOfTiles) {
                    this.addLandmass(15, 25);
                }
                this.cleanMap();
                break;
            }
            case 2: {
                this.addPolarRegions();
                int archsize = this.minimumNumberOfTiles * 10 / 100;
                for (int i = 0; i < 5; ++i) {
                    this.addLandmass(archsize - 10, archsize);
                }
            }
            case 3: {
                this.addPolarRegions();
                while (this.numberOfLandTiles < this.minimumNumberOfTiles) {
                    int s = this.random.nextInt(50) + 25;
                    this.addLandmass(20, s);
                }
                this.cleanMap();
            }
        }
        return this.map;
    }

    private void createClassicLandMap() {
        while (this.numberOfLandTiles < this.minimumNumberOfTiles) {
            int y;
            int x;
            int failCounter = 0;
            do {
                x = this.random.nextInt(this.width - this.preferredDistanceToEdge * 4) + this.preferredDistanceToEdge * 2;
                y = this.random.nextInt(this.height - this.preferredDistanceToEdge * 4) + this.preferredDistanceToEdge * 2;
                if (++failCounter <= 100) continue;
                failCounter = 0;
                --this.minimumNumberOfTiles;
                break;
            } while (this.map[x][y]);
            this.setLand(x, y);
        }
        this.addPolarRegions();
        this.cleanMap();
    }

    private void addLandmass(int minsize, int maxsize, int x, int y) {
        int size = 0;
        boolean[][] newland = new boolean[this.width][this.height];
        ArrayList<Map.Position> l = new ArrayList<Map.Position>();
        if (x < 0 || y < 0) {
            while (this.map[x = this.random.nextInt(this.width - this.preferredDistanceToEdge * 2) + this.preferredDistanceToEdge][y = this.random.nextInt(this.height - this.preferredDistanceToEdge * 2) + this.preferredDistanceToEdge] || !this.isSingleTile(x, y)) {
            }
        }
        newland[x][y] = true;
        ++size;
        Map.Position p = new Map.Position(x, y);
        for (Map.Direction direction : Map.Direction.longSides) {
            Map.Position n = p.getAdjacent(direction);
            if (!Map.isValid(n, this.width, this.height) || !this.isSingleTile(n.getX(), n.getY()) || n.getX() <= this.preferredDistanceToEdge || n.getX() >= this.width - this.preferredDistanceToEdge) continue;
            l.add(n);
        }
        while (size < maxsize && l.size() > 0) {
            int i = this.random.nextInt(l.size());
            p = (Map.Position)l.remove(i);
            if (newland[p.getX()][p.getY()]) continue;
            newland[p.getX()][p.getY()] = true;
            ++size;
            for (Map.Direction direction : Map.Direction.longSides) {
                Map.Position n = p.getAdjacent(direction);
                if (!Map.isValid(n, this.width, this.height) || !this.isSingleTile(n.getX(), n.getY()) || n.getX() <= this.preferredDistanceToEdge || n.getX() >= this.width - this.preferredDistanceToEdge) continue;
                l.add(n);
            }
        }
        for (x = 0; x < this.width; ++x) {
            for (y = 0; y < this.height; ++y) {
                if (!newland[x][y]) continue;
                this.map[x][y] = true;
                ++this.numberOfLandTiles;
            }
        }
    }

    private void addLandmass(int minsize, int maxsize) {
        this.addLandmass(minsize, maxsize, -1, -1);
    }

    private void addPolarRegions() {
        for (int x = 0; x < this.width; ++x) {
            int limit;
            for (int y = 0; y < 2; ++y) {
                if (this.map[x][y]) continue;
                this.map[x][y] = true;
                ++this.numberOfLandTiles;
            }
            for (int y = limit = this.height - 1 - 2; y < this.height; ++y) {
                if (this.map[x][y]) continue;
                this.map[x][y] = true;
                ++this.numberOfLandTiles;
            }
        }
    }

    private void cleanMap() {
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                if (!this.isSingleTile(x, y)) continue;
                this.map[x][y] = false;
            }
        }
    }

    private boolean isSingleTile(int x, int y) {
        Map.Position p = new Map.Position(x, y);
        for (Map.Direction direction : Map.Direction.values()) {
            Map.Position n = p.getAdjacent(direction);
            if (!Map.isValid(n, this.width, this.height) || !this.map[n.getX()][n.getY()]) continue;
            return false;
        }
        return true;
    }

    private void setLand(int x, int y) {
        if (this.map[x][y]) {
            return;
        }
        this.map[x][y] = true;
        ++this.numberOfLandTiles;
        Map.Position p = new Map.Position(x, y);
        for (Map.Direction direction : Map.Direction.longSides) {
            Map.Position n = p.getAdjacent(direction);
            if (!Map.isValid(n, this.width, this.height)) continue;
            this.growLand(n.getX(), n.getY());
        }
    }

    private void growLand(int i, int j) {
        if (this.map[i][j]) {
            return;
        }
        int r = this.random.nextInt(8) + Math.max(-1, 1 + Math.max(this.preferredDistanceToEdge - Math.min(i, this.width - i), 2 * this.preferredDistanceToEdge - Math.min(j, this.height - j)));
        int sum = 0;
        Map.Position p = new Map.Position(i, j);
        for (Map.Direction direction : Map.Direction.values()) {
            Map.Position n = p.getAdjacent(direction);
            if (!Map.isValid(n, this.width, this.height) || !this.map[n.getX()][n.getY()]) continue;
            ++sum;
        }
        if (sum > r) {
            this.setLand(i, j);
        }
    }
}

