/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai;

import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.Transportable;
import net.sf.freecol.server.ai.Wish;
import org.w3c.dom.Element;

public class WorkerWish
extends Wish {
    private static final Logger logger = Logger.getLogger(WorkerWish.class.getName());
    private UnitType unitType;
    private boolean expertNeeded;

    public WorkerWish(AIMain aiMain, Location destination, int value, UnitType unitType, boolean expertNeeded) {
        super(aiMain, WorkerWish.getXMLElementTagName() + ":" + aiMain.getNextID());
        if (destination == null) {
            throw new NullPointerException("destination == null");
        }
        this.destination = destination;
        this.setValue(value);
        this.unitType = unitType;
        this.expertNeeded = expertNeeded;
    }

    public WorkerWish(AIMain aiMain, Element element) {
        super(aiMain, element.getAttribute("ID"));
        this.readFromXMLElement(element);
    }

    public WorkerWish(AIMain aiMain, String id) {
        super(aiMain, id);
    }

    public WorkerWish(AIMain aiMain, XMLStreamReader in) throws XMLStreamException {
        super(aiMain, in.getAttributeValue(null, "ID"));
        this.readFromXML(in);
    }

    public void update(int value, UnitType unitType, boolean expertNeeded) {
        this.setValue(value);
        this.unitType = unitType;
        this.expertNeeded = expertNeeded;
    }

    public UnitType getUnitType() {
        return this.unitType;
    }

    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        if (this.destination == null) {
            return;
        }
        out.writeStartElement(WorkerWish.getXMLElementTagName());
        out.writeAttribute("ID", this.getId());
        out.writeAttribute("destination", this.destination.getId());
        if (this.transportable != null) {
            out.writeAttribute("transportable", this.transportable.getId());
        }
        out.writeAttribute("value", Integer.toString(this.getValue()));
        out.writeAttribute("unitType", this.unitType.getId());
        out.writeAttribute("expertNeeded", Boolean.toString(this.expertNeeded));
        out.writeEndElement();
    }

    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        this.setId(in.getAttributeValue(null, "ID"));
        this.destination = (Location)((Object)this.getAIMain().getFreeColGameObject(in.getAttributeValue(null, "destination")));
        String transportableStr = in.getAttributeValue(null, "transportable");
        if (transportableStr != null) {
            this.transportable = (Transportable)((Object)this.getAIMain().getAIObject(transportableStr));
            if (this.transportable == null) {
                this.transportable = new AIUnit(this.getAIMain(), transportableStr);
            }
        } else {
            this.transportable = null;
        }
        this.setValue(Integer.parseInt(in.getAttributeValue(null, "value")));
        this.unitType = this.getAIMain().getGame().getSpecification().getUnitType(in.getAttributeValue(null, "unitType"));
        this.expertNeeded = Boolean.valueOf(in.getAttributeValue(null, "expertNeeded"));
        in.nextTag();
    }

    public String toString() {
        return "WorkerWish: " + this.unitType.getNameKey() + " (" + this.getValue() + (this.expertNeeded ? ", expert)" : ")");
    }

    public static String getXMLElementTagName() {
        return "workerWish";
    }
}

