/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.DiplomaticTrade;
import net.sf.freecol.common.model.FoundingFather;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.Market;
import net.sf.freecol.common.model.Monarch;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.common.networking.DiplomacyMessage;
import net.sf.freecol.common.networking.LootCargoMessage;
import net.sf.freecol.common.networking.MessageHandler;
import net.sf.freecol.common.networking.NewLandNameMessage;
import net.sf.freecol.common.networking.NewRegionNameMessage;
import net.sf.freecol.common.networking.StreamedMessageHandler;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIMessage;
import net.sf.freecol.server.ai.AIPlayer;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.EuropeanAIPlayer;
import net.sf.freecol.server.model.ServerGame;
import net.sf.freecol.server.model.ServerPlayer;
import net.sf.freecol.server.networking.DummyConnection;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class AIInGameInputHandler
implements MessageHandler,
StreamedMessageHandler {
    private static final Logger logger = Logger.getLogger(AIInGameInputHandler.class.getName());
    private final ServerPlayer serverPlayer;
    private final FreeColServer freeColServer;
    private final AIMain aiMain;

    public AIInGameInputHandler(FreeColServer freeColServer, ServerPlayer me, AIMain aiMain) {
        this.freeColServer = freeColServer;
        this.serverPlayer = me;
        this.aiMain = aiMain;
        if (freeColServer == null) {
            throw new NullPointerException("freeColServer == null");
        }
        if (me == null) {
            throw new NullPointerException("me == null");
        }
        if (aiMain == null) {
            throw new NullPointerException("aiMain == null");
        }
        if (!me.isAI()) {
            logger.warning("VERY BAD: Applying AIInGameInputHandler to a non-AI player!!!");
        }
    }

    public synchronized Element handle(Connection connection, Element element) {
        Element reply = null;
        try {
            String type;
            if (!(element == null || (type = element.getTagName()).equals("update") || type.equals("remove") || type.equals("startGame") || type.equals("updateGame") || type.equals("addPlayer") || type.equals("animateMove") || type.equals("animateAttack"))) {
                if (type.equals("setCurrentPlayer")) {
                    reply = this.setCurrentPlayer((DummyConnection)connection, element);
                } else if (!(type.equals("newTurn") || type.equals("setDead") || type.equals("gameEnded") || type.equals("disconnect") || type.equals("logout") || type.equals("error") || type.equals("setAI") || type.equals("chat"))) {
                    if (type.equals("chooseFoundingFather")) {
                        reply = this.chooseFoundingFather((DummyConnection)connection, element);
                    } else if (type.equals("reconnect")) {
                        logger.warning("The server requests a reconnect. This means an illegal operation has been performed. Please refer to any previous error message.");
                    } else if (!type.equals("setStance")) {
                        if (type.equals("monarchAction")) {
                            reply = this.monarchAction((DummyConnection)connection, element);
                        } else if (!type.equals("removeGoods")) {
                            if (type.equals("indianDemand")) {
                                reply = this.indianDemand((DummyConnection)connection, element);
                            } else if (type.equals("diplomacy")) {
                                reply = this.diplomaticTrade((DummyConnection)connection, element);
                            } else if (!type.equals("addObject")) {
                                if (type.equals("newLandName")) {
                                    reply = this.newLandName((DummyConnection)connection, element);
                                } else if (type.equals("newRegionName")) {
                                    reply = this.newRegionName((DummyConnection)connection, element);
                                } else if (type.equals("fountainOfYouth")) {
                                    reply = this.fountainOfYouth((DummyConnection)connection, element);
                                } else if (type.equals("lootCargo")) {
                                    reply = this.lootCargo(connection, element);
                                } else if (type.equals("multiple")) {
                                    reply = this.multiple((DummyConnection)connection, element);
                                } else {
                                    logger.warning("Message is of unsupported type \"" + type + "\".");
                                }
                            }
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "AI input handler for " + this.serverPlayer + " caught error handling " + element.getTagName(), e);
        }
        return reply;
    }

    private AIPlayer getAIPlayer() {
        return this.aiMain.getAIPlayer(this.serverPlayer);
    }

    private AIUnit getAIUnit(Unit unit) {
        return this.aiMain.getAIUnit(unit);
    }

    public void handle(Connection connection, XMLStreamReader in, XMLStreamWriter out) {
    }

    public boolean accepts(String tagName) {
        return false;
    }

    private Element setCurrentPlayer(final DummyConnection connection, Element setCurrentPlayerElement) {
        ServerGame game = this.freeColServer.getGame();
        Player currentPlayer = (Player)game.getFreeColGameObject(setCurrentPlayerElement.getAttribute("player"));
        if (this.serverPlayer.getId() == currentPlayer.getId()) {
            logger.finest("Starting new Thread for " + this.serverPlayer.getName());
            Thread t = new Thread("FreeColServer:AIPlayer (" + this.serverPlayer.getName() + ")"){

                public void run() {
                    try {
                        AIInGameInputHandler.this.getAIPlayer().startWorking();
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "AI player failed while working!", e);
                    }
                    AIMessage.askEndTurn(connection);
                }
            };
            t.start();
        }
        return null;
    }

    private Element chooseFoundingFather(DummyConnection connection, Element element) {
        ArrayList<FoundingFather> possibleFoundingFathers = new ArrayList<FoundingFather>();
        for (FoundingFather.FoundingFatherType type : FoundingFather.FoundingFatherType.values()) {
            String id = element.getAttribute(type.toString());
            if (id == null || id == "") continue;
            FoundingFather father = this.aiMain.getGame().getSpecification().getFoundingFather(id);
            if (father == null) {
                logger.warning("Bogus " + type.toString() + " father: " + id);
                continue;
            }
            possibleFoundingFathers.add(father);
        }
        FoundingFather foundingFather = ((EuropeanAIPlayer)this.getAIPlayer()).selectFoundingFather(possibleFoundingFathers);
        if (foundingFather != null) {
            AIMessage.askChooseFoundingFather(connection, foundingFather);
        }
        return null;
    }

    private Element monarchAction(DummyConnection connection, Element element) {
        Monarch.MonarchAction action = Enum.valueOf(Monarch.MonarchAction.class, element.getAttribute("action"));
        boolean accept = false;
        switch (action) {
            case RAISE_TAX_WAR: 
            case RAISE_TAX_ACT: {
                try {
                    int tax = Integer.parseInt(element.getAttribute("amount"));
                    accept = ((EuropeanAIPlayer)this.getAIPlayer()).acceptTax(tax);
                }
                catch (Exception e) {
                    int tax = -1;
                    accept = false;
                }
                element.setAttribute("accepted", String.valueOf(accept));
                logger.finest("AI player monarch action " + (Object)((Object)action) + " = " + accept);
                break;
            }
            case OFFER_MERCENARIES: {
                accept = ((EuropeanAIPlayer)this.getAIPlayer()).acceptMercenaryOffer();
                element.setAttribute("accepted", String.valueOf(accept));
                logger.finest("AI player monarch action " + (Object)((Object)action) + " = " + accept);
                break;
            }
            default: {
                logger.finest("AI player ignoring monarch action " + (Object)((Object)action));
                return null;
            }
        }
        return element;
    }

    private Element indianDemand(DummyConnection connection, Element element) {
        ServerGame game = this.freeColServer.getGame();
        Unit unit = (Unit)game.getFreeColGameObject(element.getAttribute("unit"));
        Colony colony = (Colony)game.getFreeColGameObject(element.getAttribute("colony"));
        int gold = 0;
        Goods goods = null;
        Element goodsElement = DOMMessage.getChildElement(element, Goods.getXMLElementTagName());
        if (goodsElement == null) {
            gold = Integer.parseInt(element.getAttribute("gold"));
        } else {
            goods = new Goods((Game)game, goodsElement);
        }
        boolean accept = ((EuropeanAIPlayer)this.getAIPlayer()).acceptIndianDemand(unit, colony, goods, gold);
        element.setAttribute("accepted", String.valueOf(accept));
        return element;
    }

    private Element diplomaticTrade(DummyConnection connection, Element element) {
        DiplomacyMessage message = new DiplomacyMessage(this.freeColServer.getGame(), element);
        DiplomaticTrade agreement = message.getAgreement();
        boolean accept = this.getAIPlayer().acceptDiplomaticTrade(agreement);
        agreement.setStatus(accept ? DiplomaticTrade.TradeStatus.ACCEPT_TRADE : DiplomaticTrade.TradeStatus.REJECT_TRADE);
        return message.toXMLElement();
    }

    private Element newLandName(DummyConnection connection, Element element) {
        NewLandNameMessage message = new NewLandNameMessage(this.freeColServer.getGame(), element);
        message.setAccept(true);
        return message.toXMLElement();
    }

    private Element newRegionName(DummyConnection connection, Element element) {
        return new NewRegionNameMessage(this.freeColServer.getGame(), element).toXMLElement();
    }

    private Element fountainOfYouth(DummyConnection connection, Element element) {
        int n;
        String migrants = element.getAttribute("migrants");
        try {
            n = Integer.parseInt(migrants);
        }
        catch (NumberFormatException e) {
            n = -1;
        }
        for (int i = 0; i < n; ++i) {
            AIMessage.askEmigrate(connection, 0);
        }
        return null;
    }

    private Element lootCargo(Connection connection, Element element) {
        ServerGame game = this.freeColServer.getGame();
        LootCargoMessage message = new LootCargoMessage(game, element);
        Unit unit = message.getUnit(game);
        List<Goods> goods = message.getGoods();
        final Market market = this.serverPlayer.getMarket();
        Collections.sort(goods, new Comparator<Goods>(){

            @Override
            public int compare(Goods g1, Goods g2) {
                int p1 = market.getPaidForSale(g1.getType()) * g1.getAmount();
                int p2 = market.getPaidForSale(g2.getType()) * g2.getAmount();
                return p2 - p1;
            }
        });
        ArrayList<Goods> loot = new ArrayList<Goods>();
        int space = unit.getSpaceLeft();
        while (!goods.isEmpty() && space > 0) {
            Goods g = goods.remove(0);
            if (g.getSpaceTaken() > space) continue;
            loot.add(g);
            space -= g.getSpaceTaken();
        }
        AIMessage.askLoot(this.getAIUnit(unit), message.getDefenderId(), loot);
        return null;
    }

    public Element multiple(Connection connection, Element element) {
        NodeList nodes = element.getChildNodes();
        Element reply = null;
        for (int i = 0; i < nodes.getLength(); ++i) {
            reply = this.handle(connection, (Element)nodes.item(i));
        }
        return reply;
    }
}

