/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.util;

import java.util.Collection;
import java.util.Random;
import java.util.logging.Logger;
import net.sf.freecol.common.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RandomChoice<T> {
    private final int probability;
    private final T object;

    public RandomChoice(T object, int probability) {
        this.probability = probability;
        this.object = object;
    }

    public int getProbability() {
        return this.probability;
    }

    public T getObject() {
        return this.object;
    }

    public static <T> T getWeightedRandom(Logger logger, String logMe, Random random, Collection<RandomChoice<T>> input) {
        int n;
        if (input == null || input.isEmpty() || (n = RandomChoice.getTotalProbability(input)) <= 0) {
            return null;
        }
        if (input.size() == 1) {
            return input.iterator().next().getObject();
        }
        return RandomChoice.select(input, Utils.randomInt(logger, logMe, random, n));
    }

    public static <T> int getTotalProbability(Collection<RandomChoice<T>> input) {
        int total = 0;
        for (RandomChoice<T> choice : input) {
            total += choice.getProbability();
        }
        return total;
    }

    public static <T> T select(Collection<RandomChoice<T>> input, int probability) {
        if (input.isEmpty()) {
            return null;
        }
        int total = 0;
        for (RandomChoice<T> choice : input) {
            if (probability >= (total += choice.getProbability())) continue;
            return choice.getObject();
        }
        return input.iterator().next().getObject();
    }
}

