/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.option;

import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.option.IntegerOption;

public class PercentageOption
extends IntegerOption {
    private static Logger logger = Logger.getLogger(PercentageOption.class.getName());

    public PercentageOption(XMLStreamReader in) throws XMLStreamException {
        super(in);
        this.setMinimumValue(0);
        this.setMaximumValue(100);
    }

    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        super.toXML(out, PercentageOption.getXMLElementTagName());
    }

    protected void writeAttributes(XMLStreamWriter out) throws XMLStreamException {
        super.writeAttributes(out);
        out.writeAttribute("value", Integer.toString(this.getValue()));
        out.writeAttribute("previewEnabled", Boolean.toString(this.isPreviewEnabled()));
    }

    protected void readAttributes(XMLStreamReader in) throws XMLStreamException {
        super.readAttributes(in);
        String previewEnabled = in.getAttributeValue(null, "previewEnabled");
        if (previewEnabled != null) {
            this.setPreviewEnabled(Boolean.parseBoolean(previewEnabled));
        }
    }

    public static String getXMLElementTagName() {
        return "percentageOption";
    }
}

