/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import net.sf.freecol.FreeCol;
import net.sf.freecol.common.FreeColException;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.common.networking.NetworkReplyObject;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

final class ReceivingThread
extends Thread {
    private static final Logger logger = Logger.getLogger(ReceivingThread.class.getName());
    private static final int MAXIMUM_RETRIES = 5;
    private final FreeColNetworkInputStream in;
    private XMLStreamReader xmlIn = null;
    private boolean shouldRun;
    private int nextNetworkReplyId = 1;
    private final Map<Integer, NetworkReplyObject> threadsWaitingForNetworkReply;
    private final Connection connection;
    private boolean locked = false;

    ReceivingThread(Connection connection, InputStream in, String threadName) {
        super(threadName + "ReceivingThread - " + connection.toString());
        this.connection = connection;
        this.in = new FreeColNetworkInputStream(in);
        this.shouldRun = true;
        this.threadsWaitingForNetworkReply = Collections.synchronizedMap(new HashMap());
    }

    public synchronized int getNextNetworkReplyId() {
        return this.nextNetworkReplyId++;
    }

    public NetworkReplyObject waitForNetworkReply(int networkReplyId) {
        NetworkReplyObject nro = new NetworkReplyObject(networkReplyId, false);
        this.threadsWaitingForNetworkReply.put(networkReplyId, nro);
        return nro;
    }

    public NetworkReplyObject waitForStreamedNetworkReply(int networkReplyId) {
        NetworkReplyObject nro = new NetworkReplyObject(networkReplyId, true);
        this.threadsWaitingForNetworkReply.put(networkReplyId, nro);
        return nro;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        int timesFailed = 0;
        try {
            while (this.shouldRun()) {
                try {
                    this.listen();
                    timesFailed = 0;
                }
                catch (XMLStreamException e) {
                    if (!this.shouldRun || ++timesFailed <= 5) continue;
                    this.disconnect();
                }
                catch (SAXException e) {
                    if (!this.shouldRun || ++timesFailed <= 5) continue;
                    this.disconnect();
                }
                catch (IOException e) {
                    if (!this.shouldRun) continue;
                    this.disconnect();
                }
            }
        }
        finally {
            this.askToStop();
        }
    }

    public void unlock() {
        this.locked = false;
    }

    private static Level getRealLevel(Logger logger) {
        while (logger.getLevel() == null) {
            logger = logger.getParent();
        }
        return logger.getLevel();
    }

    private void listen() throws IOException, SAXException, XMLStreamException {
        boolean disconnectMessage;
        while (this.locked) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {}
        }
        boolean dumpTraffic = FreeCol.isInDebugMode() || ReceivingThread.getRealLevel(logger) == Level.FINEST;
        int LOOK_AHEAD = dumpTraffic ? 500000 : 500;
        BufferedInputStream bis = new BufferedInputStream(this.in, LOOK_AHEAD * 2);
        this.in.enable();
        bis.mark(LOOK_AHEAD);
        if (!this.shouldRun()) {
            return;
        }
        if (dumpTraffic) {
            byte[] buf = new byte[LOOK_AHEAD];
            int r = bis.read(buf, 0, LOOK_AHEAD);
            if (r > 0) {
                System.out.print(new String(buf, 0, r));
                if (buf[LOOK_AHEAD - 1] != 0) {
                    System.out.println("...");
                } else {
                    System.out.println();
                }
                System.out.println();
            }
            bis.reset();
        }
        XMLInputFactory xif = XMLInputFactory.newInstance();
        this.xmlIn = xif.createXMLStreamReader(bis);
        this.xmlIn.nextTag();
        boolean bl = disconnectMessage = this.xmlIn.getLocalName().equals("disconnect");
        if (this.xmlIn.getLocalName().equals("reply")) {
            String networkReplyID = this.xmlIn.getAttributeValue(null, "networkReplyId");
            NetworkReplyObject nro = this.threadsWaitingForNetworkReply.remove(Integer.valueOf(networkReplyID));
            if (nro != null) {
                if (nro.isStreamed()) {
                    this.locked = true;
                    nro.setResponse(this.xmlIn);
                } else {
                    this.xmlIn.close();
                    this.xmlIn = null;
                    bis.reset();
                    DOMMessage msg = new DOMMessage(bis);
                    nro.setResponse(msg);
                }
            } else {
                while (this.xmlIn.hasNext()) {
                    this.xmlIn.next();
                }
                this.xmlIn.close();
                this.xmlIn = null;
                logger.warning("Could not find networkReplyId=" + networkReplyID);
            }
        } else {
            this.xmlIn.close();
            this.xmlIn = null;
            bis.reset();
            this.connection.handleAndSendReply(bis);
        }
        if (disconnectMessage) {
            this.askToStop();
        }
    }

    private synchronized boolean shouldRun() {
        return this.shouldRun;
    }

    synchronized void askToStop() {
        this.shouldRun = false;
        for (NetworkReplyObject o : this.threadsWaitingForNetworkReply.values()) {
            o.interrupt();
        }
    }

    private void disconnect() {
        if (this.connection.getMessageHandler() != null) {
            try {
                Element disconnectElement = DOMMessage.createNewRootElement("disconnect");
                disconnectElement.setAttribute("reason", "reception exception");
                this.connection.getMessageHandler().handle(this.connection, disconnectElement);
            }
            catch (FreeColException e) {
                e.printStackTrace();
            }
        }
    }

    class FreeColNetworkInputStream
    extends InputStream {
        private static final int BUFFER_SIZE = 8192;
        private static final char END_OF_STREAM = '\n';
        private final InputStream in;
        private byte[] buffer = new byte[8192];
        private int bStart = 0;
        private int bEnd = 0;
        private boolean empty = true;
        private boolean wait = false;

        FreeColNetworkInputStream(InputStream in) {
            this.in = in;
        }

        private boolean fill() throws IOException {
            int r;
            if (this.bStart < this.bEnd || this.empty && this.bStart == this.bEnd) {
                if (this.empty) {
                    this.bStart = 0;
                    this.bEnd = 0;
                }
                r = this.in.read(this.buffer, this.bEnd, 8192 - this.bEnd);
            } else {
                if (this.bStart == this.bEnd) {
                    throw new IllegalStateException();
                }
                r = this.in.read(this.buffer, this.bEnd, this.bStart - this.bEnd);
            }
            if (r <= 0) {
                logger.fine("Could not read data from stream.");
                return false;
            }
            this.empty = false;
            this.bEnd += r;
            if (this.bEnd == 8192) {
                this.bEnd = 0;
            }
            return true;
        }

        void enable() {
            this.wait = false;
        }

        public int read() throws IOException {
            if (this.wait) {
                return -1;
            }
            if (this.empty && !this.fill()) {
                this.wait = true;
                return -1;
            }
            if (this.buffer[this.bStart] == 10) {
                ++this.bStart;
                if (this.bStart == 8192) {
                    this.bStart = 0;
                }
                if (this.bStart == this.bEnd) {
                    this.empty = true;
                }
                this.wait = true;
                return -1;
            }
            ++this.bStart;
            if (this.bStart == this.bEnd || this.bEnd == 0 && this.bStart == 8192) {
                this.empty = true;
            }
            if (this.bStart == 8192) {
                this.bStart = 0;
                return this.buffer[8191];
            }
            return this.buffer[this.bStart - 1];
        }

        public int read(byte[] b, int off, int len) throws IOException {
            if (this.wait) {
                return -1;
            }
            if (this.empty && !this.fill()) {
                this.wait = true;
                return -1;
            }
            for (int r = 0; r < len; ++r) {
                if (this.buffer[this.bStart] == 10) {
                    ++this.bStart;
                    if (this.bStart == 8192) {
                        this.bStart = 0;
                    }
                    if (this.bStart == this.bEnd) {
                        this.empty = true;
                    }
                    this.wait = true;
                    return r;
                }
                b[r + off] = this.buffer[this.bStart];
                ++this.bStart;
                if (this.bStart == this.bEnd || this.bEnd == 0 && this.bStart == 8192) {
                    this.empty = true;
                    if (!this.fill()) {
                        this.wait = true;
                        return r + 1;
                    }
                }
                if (this.bStart != 8192) continue;
                this.bStart = 0;
            }
            return len;
        }
    }
}

