/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.DiplomaticTrade;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DiplomacyMessage
extends DOMMessage {
    private Unit unit;
    private Settlement settlement;
    private DiplomaticTrade agreement;

    public DiplomacyMessage(Unit unit, Settlement settlement, DiplomaticTrade agreement) {
        this.unit = unit;
        this.settlement = settlement;
        this.agreement = agreement;
    }

    public DiplomacyMessage(Game game, Element element) {
        Element unitElement;
        String unitId;
        FreeColGameObject fcgo = game.getFreeColGameObject(element.getAttribute("settlement"));
        this.settlement = fcgo instanceof Settlement ? (Settlement)fcgo : null;
        NodeList nodes = element.getChildNodes();
        DiplomaticTrade diplomaticTrade = this.agreement = nodes.getLength() < 1 ? null : new DiplomaticTrade(game, (Element)nodes.item(0));
        this.unit = nodes.getLength() < 2 ? null : ((fcgo = game.getFreeColGameObject(unitId = (unitElement = (Element)nodes.item(1)).getAttribute("ID"))) instanceof Unit ? (Unit)fcgo : new Unit(game, unitElement));
    }

    public Unit getUnit() {
        return this.unit;
    }

    public Settlement getSettlement() {
        return this.settlement;
    }

    public DiplomaticTrade getAgreement() {
        return this.agreement;
    }

    public void setAgreement(DiplomaticTrade agreement) {
        this.agreement = agreement;
    }

    public Element handle(FreeColServer server, Connection connection) {
        ServerPlayer serverPlayer = server.getPlayer(connection);
        Unit unit = this.getUnit();
        if (unit == null) {
            return DOMMessage.clientError("Missing unit in diplomacy.");
        }
        if (unit.getTile() == null) {
            return DOMMessage.clientError("Unit is not on the map: " + unit.getId());
        }
        Player unitPlayer = unit.getOwner();
        Settlement settlement = this.getSettlement();
        if (settlement == null) {
            return DOMMessage.clientError("Missing settlement in diplomacy.");
        }
        if (!(settlement instanceof Colony)) {
            return DOMMessage.clientError("Settlement is not a colony: " + settlement.getId());
        }
        if (!unit.getTile().isAdjacent(settlement.getTile())) {
            return DOMMessage.clientError("Unit " + unit.getId() + " is not adjacent to settlement " + settlement.getId());
        }
        Player settlementPlayer = settlement.getOwner();
        if (this.agreement == null) {
            return DOMMessage.clientError("Null diplomatic agreement.");
        }
        Player senderPlayer = this.agreement.getSender();
        Player recipientPlayer = this.agreement.getRecipient();
        Player refPlayer = serverPlayer.getREFPlayer();
        if (senderPlayer == null) {
            return DOMMessage.clientError("Null sender in agreement.");
        }
        if (recipientPlayer == null) {
            return DOMMessage.clientError("Null recipient in agreement.");
        }
        if (senderPlayer != serverPlayer && recipientPlayer != serverPlayer) {
            return DOMMessage.clientError("Server player not in agreement: " + serverPlayer.getId());
        }
        if (senderPlayer == recipientPlayer) {
            return DOMMessage.clientError("Auto-agreement detected: " + senderPlayer.getId());
        }
        if (senderPlayer == refPlayer || recipientPlayer == refPlayer) {
            return DOMMessage.clientError("The REF does not negotiate: " + refPlayer.getId());
        }
        if (!(unitPlayer == senderPlayer && settlementPlayer == recipientPlayer || unitPlayer == recipientPlayer && settlementPlayer == senderPlayer)) {
            return DOMMessage.clientError("Diplomatic agreement parties: " + senderPlayer.getId() + " + " + recipientPlayer.getId() + " are not the same as unit + settlement owner: " + unitPlayer.getId() + " + " + settlementPlayer.getId());
        }
        return server.getInGameController().diplomaticTrade(serverPlayer, unit, settlement, this.agreement);
    }

    public Element toXMLElement() {
        Element result = DiplomacyMessage.createNewRootElement(DiplomacyMessage.getXMLElementTagName());
        Document doc = result.getOwnerDocument();
        result.setAttribute("settlement", this.settlement.getId());
        result.appendChild(this.agreement.toXMLElement(null, doc));
        result.appendChild(this.unit.toXMLElement(null, doc));
        return result;
    }

    public static String getXMLElementTagName() {
        return "diplomacy";
    }
}

