/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.EquipmentType;
import net.sf.freecol.common.model.FreeColGameObjectType;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Scope;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovement;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TileImprovementType
extends FreeColGameObjectType {
    private boolean natural;
    private int magnitude;
    private int addWorkTurns;
    private TileImprovementType requiredImprovementType;
    private Set<String> allowedWorkers = new HashSet<String>();
    private EquipmentType expendedEquipmentType;
    private int expendedAmount;
    private GoodsType deliverGoodsType;
    private int deliverAmount;
    private Map<TileType, TileType> tileTypeChange = new HashMap<TileType, TileType>();
    private int movementCost;
    private float movementCostFactor;
    private int zIndex;
    private int exposeResourcePercent;
    private List<Scope> scopes = new ArrayList<Scope>();

    public TileImprovementType(String id, Specification specification) {
        super(id, specification);
        this.setModifierIndex(Modifier.IMPROVEMENT_PRODUCTION_INDEX);
    }

    public boolean isNatural() {
        return this.natural;
    }

    public int getMagnitude() {
        return this.magnitude;
    }

    public int getAddWorkTurns() {
        return this.addWorkTurns;
    }

    public int getZIndex() {
        return this.zIndex;
    }

    public void setZIndex(int newZIndex) {
        this.zIndex = newZIndex;
    }

    public TileImprovementType getRequiredImprovementType() {
        return this.requiredImprovementType;
    }

    public EquipmentType getExpendedEquipmentType() {
        return this.expendedEquipmentType;
    }

    public int getExpendedAmount() {
        return this.expendedAmount;
    }

    public GoodsType getDeliverGoodsType() {
        return this.deliverGoodsType;
    }

    public int getDeliverAmount() {
        return this.deliverAmount;
    }

    public List<Scope> getScopes() {
        return this.scopes;
    }

    public String getShortId() {
        int index = this.getId().lastIndexOf(46) + 1;
        return this.getId().substring(index);
    }

    public boolean isWorkerTypeAllowed(UnitType unitType) {
        return this.allowedWorkers.isEmpty() || this.allowedWorkers.contains(unitType.getId());
    }

    public boolean isWorkerAllowed(Unit unit) {
        if (!this.isWorkerTypeAllowed(unit.getType())) {
            return false;
        }
        return unit.getEquipment().getCount(this.expendedEquipmentType) >= this.expendedAmount;
    }

    public boolean isTileTypeAllowed(TileType tileType) {
        for (Scope scope : this.scopes) {
            if (scope.appliesTo(tileType)) continue;
            return false;
        }
        return true;
    }

    public boolean isTileAllowed(Tile tile) {
        if (!this.isTileTypeAllowed(tile.getType())) {
            return false;
        }
        if (this.requiredImprovementType != null && tile.findTileImprovementType(this.requiredImprovementType) == null) {
            return false;
        }
        TileImprovement ti = tile.findTileImprovementType(this);
        return ti == null || !ti.isComplete();
    }

    public int getBonus(GoodsType goodsType) {
        Modifier result = this.getProductionModifier(goodsType);
        if (result == null) {
            return 0;
        }
        return (int)result.getValue();
    }

    public Modifier getProductionModifier(GoodsType goodsType) {
        Set<Modifier> modifierSet = this.getFeatureContainer().getModifierSet(goodsType.getId());
        if (modifierSet == null || modifierSet.isEmpty()) {
            return null;
        }
        if (modifierSet.size() > 1) {
            logger.warning("Only one Modifier for " + goodsType.getId() + " expected!");
        }
        return modifierSet.iterator().next();
    }

    public TileType getChange(TileType tileType) {
        return this.tileTypeChange.get(tileType);
    }

    public boolean changeContainsTarget(TileType tileType) {
        return this.tileTypeChange.containsValue(tileType);
    }

    public int getMovementCost(int moveCost) {
        float cost2;
        int cost = moveCost;
        if (this.movementCostFactor >= 0.0f && (float)(cost = (int)(cost2 = (float)cost * this.movementCostFactor)) < cost2) {
            ++cost;
        }
        if (this.movementCost > 0 && this.movementCost < cost) {
            cost = this.movementCost;
        }
        return cost;
    }

    public int getExposeResourcePercent() {
        return this.exposeResourcePercent;
    }

    @Override
    public void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        super.toXML(out, TileImprovementType.getXMLElementTagName());
    }

    @Override
    protected void writeAttributes(XMLStreamWriter out) throws XMLStreamException {
        super.writeAttributes(out);
        out.writeAttribute("natural", Boolean.toString(this.natural));
        out.writeAttribute("add-work-turns", Integer.toString(this.addWorkTurns));
        out.writeAttribute("movement-cost", Integer.toString(this.movementCost));
        out.writeAttribute("magnitude", Integer.toString(this.magnitude));
        out.writeAttribute("zIndex", Integer.toString(this.zIndex));
        out.writeAttribute("exposeResourcePercent", Integer.toString(this.exposeResourcePercent));
        if (this.requiredImprovementType != null) {
            out.writeAttribute("required-improvement", this.requiredImprovementType.getId());
        }
        if (this.expendedEquipmentType != null) {
            out.writeAttribute("expended-equipment-type", this.expendedEquipmentType.getId());
            out.writeAttribute("expended-amount", Integer.toString(this.expendedAmount));
        }
        if (this.deliverGoodsType != null) {
            out.writeAttribute("deliver-goods-type", this.deliverGoodsType.getId());
            out.writeAttribute("deliver-amount", Integer.toString(this.deliverAmount));
        }
    }

    @Override
    protected void writeChildren(XMLStreamWriter out) throws XMLStreamException {
        super.writeChildren(out);
        if (this.scopes != null) {
            for (Scope scope : this.scopes) {
                scope.toXMLImpl(out);
            }
        }
        if (this.allowedWorkers != null) {
            for (String string : this.allowedWorkers) {
                out.writeStartElement("worker");
                out.writeAttribute("id", string);
                out.writeEndElement();
            }
        }
        if (this.tileTypeChange != null) {
            for (Map.Entry entry : this.tileTypeChange.entrySet()) {
                out.writeStartElement("change");
                out.writeAttribute("from", ((TileType)entry.getKey()).getId());
                out.writeAttribute("to", ((TileType)entry.getValue()).getId());
                out.writeEndElement();
            }
        }
    }

    @Override
    protected void readAttributes(XMLStreamReader in) throws XMLStreamException {
        super.readAttributes(in);
        this.natural = TileImprovementType.getAttribute(in, "natural", false);
        this.addWorkTurns = this.getAttribute(in, "add-work-turns", 0);
        this.movementCost = this.getAttribute(in, "movement-cost", 0);
        this.movementCostFactor = -1.0f;
        this.magnitude = this.getAttribute(in, "magnitude", 1);
        this.requiredImprovementType = this.getSpecification().getType(in, "required-improvement", TileImprovementType.class, null);
        this.zIndex = this.getAttribute(in, "zIndex", 0);
        this.exposeResourcePercent = this.getAttribute(in, "exposeResourcePercent", 0);
        this.expendedEquipmentType = this.getSpecification().getType(in, "expended-equipment-type", EquipmentType.class, null);
        this.expendedAmount = this.getAttribute(in, "expended-amount", 0);
        this.deliverGoodsType = this.getSpecification().getType(in, "deliver-goods-type", GoodsType.class, null);
        this.deliverAmount = this.getAttribute(in, "deliver-amount", 0);
    }

    @Override
    protected void readChild(XMLStreamReader in) throws XMLStreamException {
        String childName = in.getLocalName();
        if ("scope".equals(childName)) {
            this.scopes.add(new Scope(in));
        } else if ("worker".equals(childName)) {
            this.allowedWorkers.add(in.getAttributeValue(null, "id"));
            in.nextTag();
        } else if ("change".equals(childName)) {
            this.tileTypeChange.put(this.getSpecification().getTileType(in.getAttributeValue(null, "from")), this.getSpecification().getTileType(in.getAttributeValue(null, "to")));
            in.nextTag();
        } else {
            super.readChild(in);
        }
    }

    public static String getXMLElementTagName() {
        return "tileimprovement-type";
    }
}

