/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Scope;
import net.sf.freecol.common.model.Settlement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Operand
extends Scope {
    private static final Logger logger = Logger.getLogger(Operand.class.getName());
    private OperandType operandType = OperandType.NONE;
    private ScopeLevel scopeLevel = ScopeLevel.NONE;
    private Integer value = null;

    public Operand() {
    }

    public Operand(int value) {
        this.value = value;
    }

    public Operand(OperandType operandType, ScopeLevel scopeLevel) {
        this.operandType = operandType;
        this.scopeLevel = scopeLevel;
    }

    public final OperandType getOperandType() {
        return this.operandType;
    }

    public final void setOperandType(OperandType newOperandType) {
        this.operandType = newOperandType;
    }

    public final ScopeLevel getScopeLevel() {
        return this.scopeLevel;
    }

    public final void setScopeLevel(ScopeLevel newScopeLevel) {
        this.scopeLevel = newScopeLevel;
    }

    public final Integer getValue() {
        return this.value;
    }

    public final void setValue(Integer newValue) {
        this.value = newValue;
    }

    public Integer getValue(Game game) {
        if (this.value == null) {
            if (this.scopeLevel == ScopeLevel.GAME) {
                return this.calculateGameValue(game);
            }
            return null;
        }
        return this.value;
    }

    private Integer calculateGameValue(Game game) {
        switch (this.operandType) {
            case NONE: {
                if (this.getMethodName() != null) {
                    try {
                        Method method = game.getClass().getMethod(this.getMethodName(), new Class[0]);
                        if (method != null && Integer.class.isAssignableFrom(method.getReturnType())) {
                            return (Integer)method.invoke((Object)game, new Object[0]);
                        }
                    }
                    catch (Exception e) {
                        logger.warning(e.toString());
                    }
                }
                return null;
            }
            case YEAR: {
                return game.getTurn().getYear();
            }
            case OPTION: {
                return game.getSpecification().getInteger(this.getType());
            }
        }
        LinkedList<FreeColObject> list = new LinkedList<FreeColObject>();
        block13: for (Player player : game.getPlayers()) {
            switch (this.operandType) {
                case UNITS: {
                    list.addAll(player.getUnits());
                    break;
                }
                case BUILDINGS: {
                    for (Colony colony : player.getColonies()) {
                        list.addAll(colony.getBuildings());
                    }
                    continue block13;
                }
                case SETTLEMENTS: {
                    list.addAll(player.getSettlements());
                    break;
                }
                case FOUNDING_FATHERS: {
                    list.addAll(player.getFathers());
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        return this.count(list);
    }

    public Integer getValue(Player player) {
        if (this.value == null) {
            if (this.scopeLevel == ScopeLevel.PLAYER) {
                LinkedList<FreeColObject> list = new LinkedList<FreeColObject>();
                switch (this.operandType) {
                    case UNITS: {
                        list.addAll(player.getUnits());
                        break;
                    }
                    case BUILDINGS: {
                        for (Colony colony : player.getColonies()) {
                            list.addAll(colony.getBuildings());
                        }
                        break;
                    }
                    case SETTLEMENTS: {
                        list.addAll(player.getSettlements());
                        break;
                    }
                    case FOUNDING_FATHERS: {
                        list.addAll(player.getFathers());
                        break;
                    }
                    default: {
                        if (this.getMethodName() != null) {
                            try {
                                Method method = player.getClass().getMethod(this.getMethodName(), new Class[0]);
                                if (method != null && (Integer.TYPE.equals(method.getReturnType()) || Integer.class.equals(method.getReturnType()))) {
                                    return (Integer)method.invoke((Object)player, new Object[0]);
                                }
                            }
                            catch (Exception e) {
                                logger.warning(e.toString());
                                return null;
                            }
                        }
                        return null;
                    }
                }
                return this.count(list);
            }
            if (this.scopeLevel == ScopeLevel.GAME) {
                return this.getValue(player.getGame());
            }
            return null;
        }
        return this.value;
    }

    public Integer getValue(Settlement settlement) {
        if (this.value == null) {
            if (this.scopeLevel == ScopeLevel.SETTLEMENT && settlement instanceof Colony) {
                Colony colony = (Colony)settlement;
                LinkedList<FreeColObject> list = new LinkedList<FreeColObject>();
                switch (this.operandType) {
                    case UNITS: {
                        list.addAll(colony.getUnitList());
                        break;
                    }
                    case BUILDINGS: {
                        list.addAll(colony.getBuildings());
                        break;
                    }
                    default: {
                        if (this.getMethodName() != null) {
                            try {
                                Method method = colony.getClass().getMethod(this.getMethodName(), new Class[0]);
                                if (method != null && Integer.class.isAssignableFrom(method.getReturnType())) {
                                    return (Integer)method.invoke((Object)colony, new Object[0]);
                                }
                            }
                            catch (Exception e) {
                                logger.warning(e.toString());
                                return null;
                            }
                        }
                        return null;
                    }
                }
                return this.count(list);
            }
            return null;
        }
        return this.value;
    }

    private int count(List<FreeColObject> objects) {
        int result = 0;
        for (FreeColObject object : objects) {
            if (!this.appliesTo(object)) continue;
            ++result;
        }
        return result;
    }

    @Override
    protected void writeAttributes(XMLStreamWriter out) throws XMLStreamException {
        super.writeAttributes(out);
        out.writeAttribute("operandType", this.operandType.toString());
        out.writeAttribute("scopeLevel", this.scopeLevel.toString());
        if (this.value != null) {
            out.writeAttribute("value", this.value.toString());
        }
    }

    @Override
    protected void readAttributes(XMLStreamReader in) throws XMLStreamException {
        super.readAttributes(in);
        String attribute = in.getAttributeValue(null, "operandType");
        if (attribute != null) {
            this.operandType = Enum.valueOf(OperandType.class, attribute);
        }
        if ((attribute = in.getAttributeValue(null, "scopeLevel")) != null) {
            this.scopeLevel = Enum.valueOf(ScopeLevel.class, attribute);
        }
        if ((attribute = in.getAttributeValue(null, "value")) != null) {
            this.value = new Integer(attribute);
        }
    }

    public String toString() {
        if (this.value == null) {
            return (Object)((Object)this.scopeLevel) + "'s number of " + (Object)((Object)this.operandType) + "s";
        }
        return Integer.toString(this.value);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ScopeLevel {
        SETTLEMENT,
        PLAYER,
        GAME,
        NONE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OperandType {
        UNITS,
        BUILDINGS,
        SETTLEMENTS,
        FOUNDING_FATHERS,
        YEAR,
        OPTION,
        NONE;

    }
}

