/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Locatable;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitLocation;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HighSeas
extends UnitLocation {
    private static final Logger logger = Logger.getLogger(HighSeas.class.getName());
    private List<Location> destinations = new ArrayList<Location>();

    public HighSeas(Game game) {
        super(game);
    }

    public HighSeas(Game game, XMLStreamReader in) throws XMLStreamException {
        super(game, in);
        this.readFromXML(in);
    }

    public HighSeas(Game game, Element e) {
        super(game, e);
        this.readFromXMLElement(e);
    }

    public HighSeas(Game game, String id) {
        super(game, id);
    }

    @Override
    public StringTemplate getLocationName() {
        return StringTemplate.key("model.tile.highSeas.name");
    }

    public final List<Location> getDestinations() {
        return this.destinations;
    }

    public void addDestination(Location destination) {
        if (destination != null) {
            if (!this.destinations.contains(destination)) {
                this.destinations.add(destination);
            } else {
                logger.warning(this.getId() + " already included destination " + destination.getId());
            }
        } else {
            logger.warning("Tried to add null destination to " + this.getId());
        }
    }

    public void removeDestination(Location destination) {
        this.destinations.remove(destination);
    }

    @Override
    public boolean canAdd(Locatable locatable) {
        if (locatable instanceof Unit) {
            Unit unit = (Unit)locatable;
            return unit.isNaval();
        }
        return false;
    }

    @Override
    protected void toXMLImpl(XMLStreamWriter out, Player player, boolean showAll, boolean toSavedGame) throws XMLStreamException {
        out.writeStartElement(HighSeas.getXMLElementTagName());
        this.writeAttributes(out);
        this.writeChildren(out);
        out.writeEndElement();
    }

    @Override
    protected void writeChildren(XMLStreamWriter out, Player player, boolean showAll, boolean toSavedGame) throws XMLStreamException {
        super.writeChildren(out, player, showAll, toSavedGame);
        if (this.getGame() != null && this.getGame().getMap() != null) {
            this.addDestination(this.getGame().getMap());
        }
        for (Location destination : this.destinations) {
            if (destination != null) {
                out.writeStartElement("destination");
                out.writeAttribute("ID", destination.getId());
                out.writeEndElement();
                continue;
            }
            logger.warning("Tried to write out null destination from " + this.getId());
        }
    }

    @Override
    protected void readChildren(XMLStreamReader in) throws XMLStreamException {
        this.destinations.clear();
        while (in.nextTag() != 2) {
            this.readChild(in);
        }
    }

    @Override
    protected void readChild(XMLStreamReader in) throws XMLStreamException {
        if ("destination".equals(in.getLocalName())) {
            this.destinations.add(this.newLocation(in.getAttributeValue(null, "ID")));
            in.nextTag();
        } else {
            super.readChild(in);
        }
    }

    public static String getXMLElementTagName() {
        return "highSeas";
    }
}

