/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Comparator;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.ColopediaPanel;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.common.model.AbstractUnit;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.FreeColGameObjectType;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportPanel
extends FreeColPanel
implements ActionListener {
    protected static final Logger logger = Logger.getLogger(ReportPanel.class.getName());
    protected JPanel reportPanel;
    protected JLabel header;
    protected JScrollPane scrollPane;
    public static final Comparator<Unit> unitTypeComparator = new Comparator<Unit>(){

        @Override
        public int compare(Unit unit1, Unit unit2) {
            int deltaType = unit2.getType().compareTo(unit1.getType());
            if (deltaType == 0) {
                return unit2.getRole().ordinal() - unit1.getRole().ordinal();
            }
            return deltaType;
        }
    };

    public ReportPanel(Canvas parent, String title) {
        super(parent);
        this.setLayout((LayoutManager)new MigLayout("wrap 1", "[fill]", "[]30[fill]30[]"));
        this.header = ReportPanel.getDefaultHeader(title);
        this.add((Component)this.header, "cell 0 0, align center");
        this.reportPanel = new JPanel(){

            public String getUIClassID() {
                return "ReportPanelUI";
            }
        };
        this.reportPanel.setOpaque(true);
        this.reportPanel.setBorder(this.createBorder());
        this.scrollPane = new JScrollPane(this.reportPanel, 20, 30);
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(16);
        this.add((Component)this.scrollPane, "cell 0 1, height 100%, width 100%");
        this.add((Component)this.okButton, "cell 0 2, tag ok");
        this.restoreSavedSize(850, 600);
    }

    protected void setMainComponent(Component main) {
        this.remove(this.scrollPane);
        this.add(main, "cell 0 1, height 100%, width 100%");
    }

    protected Border createBorder() {
        return new EmptyBorder(20, 20, 20, 20);
    }

    public void initialize() {
        this.reportPanel.removeAll();
        this.reportPanel.doLayout();
    }

    public static Comparator<Unit> getUnitTypeComparator() {
        return unitTypeComparator;
    }

    public JLabel createUnitTypeLabel(AbstractUnit unit) {
        return this.createUnitTypeLabel(unit.getUnitType(this.getSpecification()), unit.getRole(), unit.getNumber());
    }

    public JLabel createUnitTypeLabel(UnitType unitType, Unit.Role role, int count) {
        ImageIcon unitIcon = this.getLibrary().getUnitImageIcon(unitType, role, count == 0, 0.66);
        JLabel unitLabel = new JLabel(unitIcon);
        unitLabel.setText(String.valueOf(count));
        if (count == 0) {
            unitLabel.setForeground(Color.GRAY);
        }
        unitLabel.setToolTipText(Messages.message(Messages.getLabel(unitType, role)));
        return unitLabel;
    }

    public String getLocationNameFor(Unit unit) {
        if (unit.getDestination() instanceof Map) {
            return Messages.message("goingToAmerica");
        }
        if (unit.getDestination() instanceof Europe) {
            return Messages.message("goingToEurope");
        }
        return Messages.message(unit.getLocation().getLocationNameFor(unit.getOwner()));
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if ("OK".equals(command)) {
            this.getCanvas().remove(this);
        } else {
            FreeColGameObject object = this.getGame().getFreeColGameObject(command);
            if (object instanceof Colony) {
                this.getCanvas().showColonyPanel((Colony)object);
            } else if (object instanceof Europe) {
                this.getCanvas().showEuropePanel();
            } else if (object instanceof Tile) {
                this.getCanvas().getGUI().setFocus((Tile)object);
            } else if (object == null) {
                try {
                    FreeColGameObjectType type = this.getSpecification().getType(command);
                    this.getCanvas().showPanel(new ColopediaPanel(this.getCanvas(), null, type));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
    }
}

