/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.text.DateFormat;
import java.util.List;
import javax.swing.JLabel;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.ReportPanel;
import net.sf.freecol.common.model.HighScore;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Turn;

public final class ReportHighScoresPanel
extends ReportPanel {
    public ReportHighScoresPanel(Canvas parent, String prefix) {
        super(parent, Messages.message("reportHighScoresAction.name"));
        this.reportPanel.removeAll();
        List<HighScore> highScores = this.getController().getHighScores();
        this.reportPanel.setLayout((LayoutManager)new MigLayout("wrap 3, gapx 30", "[][][align right]", ""));
        if (prefix != null) {
            this.reportPanel.add((Component)new JLabel(Messages.message(prefix)), "span, wrap 10");
        }
        for (HighScore highScore : highScores) {
            JLabel scoreValue = new JLabel(String.valueOf(highScore.getScore()));
            scoreValue.setFont(smallHeaderFont);
            this.reportPanel.add(scoreValue);
            String messageID = null;
            messageID = highScore.getIndependenceTurn() > 0 ? "report.highScores.president" : "report.highScores.governor";
            String country = highScore.getNewLandName();
            JLabel headline = this.localizedLabel(Messages.message(StringTemplate.template(messageID).addName("%name%", highScore.getPlayerName()).addName("%nation%", country)));
            headline.setFont(smallHeaderFont);
            this.reportPanel.add((Component)headline, "span, wrap 10");
            this.reportPanel.add((Component)new JLabel(Messages.message("report.highScores.turn")), "skip");
            int retirementTurn = highScore.getRetirementTurn();
            String retirementTurnStr = retirementTurn <= 0 ? Messages.message("N/A") : Messages.message(Turn.getLabel(retirementTurn));
            this.reportPanel.add(new JLabel(retirementTurnStr));
            this.reportPanel.add((Component)new JLabel(Messages.message("report.highScores.score")), "skip");
            this.reportPanel.add(new JLabel(String.valueOf(highScore.getScore())));
            this.reportPanel.add((Component)new JLabel(Messages.message("report.highScores.difficulty")), "skip");
            this.reportPanel.add(new JLabel(Messages.message(highScore.getDifficulty())));
            this.reportPanel.add((Component)new JLabel(Messages.message("report.highScores.independence")), "skip");
            int independenceTurn = highScore.getIndependenceTurn();
            String independence = independenceTurn <= 0 ? Messages.message("no") : Messages.message(Turn.getLabel(independenceTurn));
            this.reportPanel.add(new JLabel(independence));
            this.reportPanel.add((Component)new JLabel(Messages.message("report.highScores.nation")), "skip");
            if (highScore.getIndependenceTurn() > 0) {
                this.reportPanel.add(new JLabel(highScore.getNationName()));
            } else {
                this.reportPanel.add(new JLabel(Messages.message(highScore.getOldNationNameKey())));
            }
            this.reportPanel.add((Component)new JLabel(Messages.message("report.highScores.nationType")), "skip");
            this.reportPanel.add(new JLabel(Messages.message(highScore.getNationTypeID() + ".name")));
            this.reportPanel.add((Component)new JLabel(Messages.message("report.highScores.units")), "skip");
            this.reportPanel.add(new JLabel(String.valueOf(highScore.getUnits())));
            this.reportPanel.add((Component)new JLabel(Messages.message("report.highScores.colonies")), "skip");
            this.reportPanel.add(new JLabel(String.valueOf(highScore.getColonies())));
            this.reportPanel.add((Component)new JLabel(Messages.message("report.highScores.retired")), "skip");
            DateFormat format = DateFormat.getDateTimeInstance(2, 3);
            this.reportPanel.add((Component)new JLabel(format.format(highScore.getDate())), "wrap 20");
        }
        this.reportPanel.doLayout();
    }

    public void actionPerformed(ActionEvent event) {
        this.getCanvas().remove(this);
    }
}

