/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Logger;
import javax.swing.JLabel;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.FreeColDialog;
import net.sf.freecol.common.model.Monarch;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.StringTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MonarchPanel
extends FreeColDialog<Boolean>
implements ActionListener {
    private static final Logger logger = Logger.getLogger(MonarchPanel.class.getName());

    public MonarchPanel(Canvas parent, Monarch.MonarchAction action) {
        this(parent, action, null);
    }

    public MonarchPanel(Canvas parent, Monarch.MonarchAction action, StringTemplate template) {
        super(parent);
        String messageId = "model.monarch.action." + action.toString();
        String yesId = messageId + ".yes";
        String noId = messageId + ".no";
        if (!Messages.containsKey(messageId)) {
            logger.warning("Unrecognized monarch action: " + (Object)((Object)action));
            return;
        }
        this.setLayout((LayoutManager)new MigLayout("wrap 2"));
        JLabel header = new JLabel(Messages.message("aMessageFromTheCrown"));
        header.setFont(mediumHeaderFont);
        this.add((Component)header, "span, align center, wrap 20");
        Nation nation = this.getMyPlayer().getNation();
        this.add(new JLabel(this.getLibrary().getMonarchImageIcon(nation)));
        this.add(MonarchPanel.getDefaultTextArea(template == null ? Messages.message(messageId) : Messages.message(new StringTemplate(messageId, template))));
        boolean haveOK = false;
        if (Messages.containsKey(yesId)) {
            this.okButton.setText(Messages.message(yesId));
            haveOK = true;
        }
        if (!Messages.containsKey(noId)) {
            noId = "close";
        }
        this.cancelButton.setText(Messages.message(noId));
        if (haveOK) {
            this.add((Component)this.okButton, "newline 20, span, tag ok, split 2");
            this.add((Component)this.cancelButton, "tag cancel");
        } else {
            this.add((Component)this.cancelButton, "newline 20, span, tag cancel");
        }
        this.setSize(this.getPreferredSize());
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if ("OK".equals(command)) {
            this.setResponse(Boolean.TRUE);
        } else if ("CANCEL".equals(command)) {
            this.setResponse(Boolean.FALSE);
        } else {
            logger.warning("Invalid action command: " + command);
        }
    }
}

