/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.option;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.option.OptionUpdater;
import net.sf.freecol.client.gui.plaf.FreeColComboBoxRenderer;
import net.sf.freecol.common.option.StringOption;

public final class StringOptionUI
extends JComboBox
implements OptionUpdater,
PropertyChangeListener {
    private static final Logger logger = Logger.getLogger(StringOptionUI.class.getName());
    private final StringOption option;
    private String originalValue;
    private JLabel label;

    public StringOptionUI(final StringOption option, boolean editable) {
        this.option = option;
        this.originalValue = option.getValue();
        String name = Messages.getName(option);
        String description = Messages.getShortDescription(option);
        String text = description != null ? description : name;
        this.label = new JLabel(name, 2);
        this.label.setToolTipText(text);
        List<String> choices = option.getChoices();
        this.setModel(new DefaultComboBoxModel<String>(choices.toArray(new String[choices.size()])));
        this.setSelectedItem(option.getValue());
        this.setRenderer(new ChoiceRenderer());
        this.setEnabled(editable);
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (option.isPreviewEnabled()) {
                    String value = (String)StringOptionUI.this.getSelectedItem();
                    if (option.getValue().equals(value)) {
                        option.setValue(value);
                    }
                }
            }
        });
        option.addPropertyChangeListener(this);
        this.setOpaque(false);
    }

    public JLabel getLabel() {
        return this.label;
    }

    public void setLabel(JLabel newLabel) {
        this.label = newLabel;
    }

    public void rollback() {
        this.option.setValue(this.originalValue);
    }

    public void unregister() {
        this.option.removePropertyChangeListener(this);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getPropertyName().equals("value")) {
            String value = (String)event.getNewValue();
            if (value == null && this.option.addNone()) {
                this.setSelectedIndex(0);
                this.originalValue = null;
            } else if (!value.equals(this.getSelectedItem())) {
                this.setSelectedItem(value);
                this.originalValue = value;
            }
        }
    }

    public void updateOption() {
        if (this.getSelectedIndex() == 0 && this.option.addNone()) {
            this.option.setValue("none");
        } else {
            this.option.setValue((String)this.getSelectedItem());
        }
    }

    public void reset() {
        if (this.option.getValue() == null && this.option.addNone()) {
            this.setSelectedIndex(0);
        } else {
            this.setSelectedItem(this.option.getValue());
        }
    }

    private class ChoiceRenderer
    extends FreeColComboBoxRenderer {
        private ChoiceRenderer() {
        }

        public void setLabelValues(JLabel label, Object value) {
            String id = (String)value;
            if ("none".equals(id)) {
                label.setText(Messages.message(id));
            } else {
                label.setText(Messages.message((String)value + ".name"));
            }
        }
    }
}

