/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.Ability;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.DiplomaticTrade;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.FoundingFather;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.server.ai.AIColony;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIMessage;
import net.sf.freecol.server.ai.AIObject;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.TileImprovementPlan;
import net.sf.freecol.server.ai.Wish;
import net.sf.freecol.server.model.ServerPlayer;
import net.sf.freecol.server.networking.DummyConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AIPlayer
extends AIObject {
    private static final Logger logger = Logger.getLogger(AIPlayer.class.getName());
    private ServerPlayer player;
    private Connection debuggingConnection;
    private List<AIUnit> aiUnits = new ArrayList<AIUnit>();

    public AIPlayer(AIMain aiMain, String id) {
        super(aiMain, id);
    }

    public Player getPlayer() {
        return this.player;
    }

    protected void setPlayer(ServerPlayer p) {
        this.player = p;
    }

    @Override
    public String getId() {
        return this.player.getId();
    }

    public Connection getConnection() {
        if (this.debuggingConnection != null) {
            return this.debuggingConnection;
        }
        return ((DummyConnection)this.player.getConnection()).getOtherConnection();
    }

    public void setDebuggingConnection(Connection debuggingConnection) {
        this.debuggingConnection = debuggingConnection;
    }

    protected void clearAIUnits() {
        this.aiUnits.clear();
    }

    private void createAIUnits() {
        this.clearAIUnits();
        for (Unit u : this.getPlayer().getUnits()) {
            AIUnit a = this.getAIUnit(u);
            if (a != null) {
                this.aiUnits.add(a);
                continue;
            }
            logger.warning("Could not find the AIUnit for: " + u + " (" + u.getId() + ")");
        }
    }

    protected List<AIUnit> getAIUnits() {
        if (this.aiUnits.size() == 0) {
            this.createAIUnits();
        }
        return new ArrayList<AIUnit>(this.aiUnits);
    }

    protected Iterator<AIUnit> getAIUnitIterator() {
        if (this.aiUnits.size() == 0) {
            this.createAIUnits();
        }
        return this.aiUnits.iterator();
    }

    protected Iterator<AIColony> getAIColonyIterator() {
        ArrayList<AIColony> ac = new ArrayList<AIColony>();
        for (Colony colony : this.getPlayer().getColonies()) {
            AIColony a = this.getAIColony(colony);
            if (a != null) {
                ac.add(a);
                continue;
            }
            logger.warning("Could not find the AIColony for: " + colony);
        }
        return ac.iterator();
    }

    protected AIColony getAIColony(Colony colony) {
        return this.getAIMain().getAIColony(colony);
    }

    protected AIUnit getAIUnit(Unit unit) {
        return this.getAIMain().getAIUnit(unit);
    }

    public AIUnit trainAIUnitInEurope(UnitType unitType) {
        if (unitType == null) {
            throw new IllegalArgumentException("Invalid UnitType.");
        }
        AIUnit aiUnit = null;
        Europe europe = this.player.getEurope();
        int n = europe.getUnitCount();
        if (AIMessage.askTrainUnitInEurope(this.getConnection(), unitType) && europe.getUnitCount() == n + 1) {
            aiUnit = this.getAIUnit(europe.getUnitList().get(n));
        }
        return aiUnit;
    }

    public AIUnit recruitAIUnitInEurope(int index) {
        AIUnit aiUnit = null;
        Europe europe = this.player.getEurope();
        int n = europe.getUnitCount();
        String selectAbility = "model.ability.selectRecruit";
        boolean canSelect = this.player.hasAbility("model.ability.selectRecruit");
        Ability ability = null;
        if (!canSelect) {
            ability = new Ability("model.ability.selectRecruit");
            this.player.getFeatureContainer().addAbility(ability);
        }
        if (AIMessage.askEmigrate(this.getConnection(), index + 1) && europe.getUnitCount() == n + 1) {
            aiUnit = this.getAIUnit(europe.getUnitList().get(n));
        }
        if (ability != null) {
            this.player.getFeatureContainer().removeAbility(ability);
        }
        return aiUnit;
    }

    protected Player.Stance determineStance(Player other) {
        Player player = this.getPlayer();
        Player.Stance newStance = other.getREFPlayer() == player && other.getPlayerType() == Player.PlayerType.REBEL ? Player.Stance.WAR : player.getStance(other).getStanceFromTension(player.getTension(other));
        if (newStance != player.getStance(other)) {
            this.getAIMain().getFreeColServer().getInGameController().changeStance(player, newStance, other, true);
        }
        return player.getStance(other);
    }

    public abstract void startWorking();

    public abstract Iterator<TileImprovementPlan> getTileImprovementPlanIterator();

    public abstract void removeTileImprovementPlan(TileImprovementPlan var1);

    public abstract boolean hasFewColonies();

    public abstract Iterator<Wish> getWishIterator();

    public abstract FoundingFather selectFoundingFather(List<FoundingFather> var1);

    public abstract boolean acceptTax(int var1);

    public abstract boolean acceptIndianDemand(Unit var1, Colony var2, Goods var3, int var4);

    public abstract boolean acceptMercenaryOffer();

    public abstract boolean acceptDiplomaticTrade(DiplomaticTrade var1);

    public abstract void registerSellGoods(Goods var1);

    public abstract int buyProposition(Unit var1, Settlement var2, Goods var3, int var4);

    public abstract int sellProposition(Unit var1, Settlement var2, Goods var3, int var4);

    @Override
    protected abstract void toXMLImpl(XMLStreamWriter var1) throws XMLStreamException;

    @Override
    protected abstract void readFromXMLImpl(XMLStreamReader var1) throws XMLStreamException;

    public static String getXMLElementTagName() {
        return "aiPlayer";
    }
}

