/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai;

import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.freecol.common.model.BuildableType;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.EquipmentType;
import net.sf.freecol.common.model.FoundingFather;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovementType;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.WorkLocation;
import net.sf.freecol.common.networking.AttackMessage;
import net.sf.freecol.common.networking.BuildColonyMessage;
import net.sf.freecol.common.networking.BuyGoodsMessage;
import net.sf.freecol.common.networking.CashInTreasureTrainMessage;
import net.sf.freecol.common.networking.ChangeStateMessage;
import net.sf.freecol.common.networking.ChangeWorkImprovementTypeMessage;
import net.sf.freecol.common.networking.ChangeWorkTypeMessage;
import net.sf.freecol.common.networking.ClaimLandMessage;
import net.sf.freecol.common.networking.ClearSpecialityMessage;
import net.sf.freecol.common.networking.CloseTransactionMessage;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.common.networking.DeliverGiftMessage;
import net.sf.freecol.common.networking.DisembarkMessage;
import net.sf.freecol.common.networking.EmbarkMessage;
import net.sf.freecol.common.networking.EmigrateUnitMessage;
import net.sf.freecol.common.networking.EquipUnitMessage;
import net.sf.freecol.common.networking.GetTransactionMessage;
import net.sf.freecol.common.networking.IndianDemandMessage;
import net.sf.freecol.common.networking.LoadCargoMessage;
import net.sf.freecol.common.networking.LootCargoMessage;
import net.sf.freecol.common.networking.MissionaryMessage;
import net.sf.freecol.common.networking.MoveMessage;
import net.sf.freecol.common.networking.MoveToAmericaMessage;
import net.sf.freecol.common.networking.MoveToEuropeMessage;
import net.sf.freecol.common.networking.PutOutsideColonyMessage;
import net.sf.freecol.common.networking.ScoutIndianSettlementMessage;
import net.sf.freecol.common.networking.SellGoodsMessage;
import net.sf.freecol.common.networking.SetBuildQueueMessage;
import net.sf.freecol.common.networking.TrainUnitInEuropeMessage;
import net.sf.freecol.common.networking.UnloadCargoMessage;
import net.sf.freecol.common.networking.WorkMessage;
import net.sf.freecol.server.ai.AIColony;
import net.sf.freecol.server.ai.AIUnit;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AIMessage {
    private static final Logger logger = Logger.getLogger(AIMessage.class.getName());

    private static boolean sendMessage(Connection connection, Element request) {
        try {
            Element reply = connection.ask(request);
            if (reply == null) {
                return false;
            }
            if ("error".equals(reply.getTagName())) {
                String msgID = reply.getAttribute("messageID");
                String msg = reply.getAttribute("message");
                String logMessage = "AIMessage." + request.getTagName() + " error," + " messageID: " + (msgID == null ? "(null)" : msgID) + " message: " + (msg == null ? "(null)" : msg);
                logger.warning(logMessage);
                return false;
            }
            return true;
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Could not send \"" + request.getTagName() + "\"-message!", e);
            return false;
        }
    }

    private static boolean sendMessage(Connection connection, DOMMessage message) {
        return connection != null && message != null ? AIMessage.sendMessage(connection, message.toXMLElement()) : false;
    }

    public static boolean sendTrivial(Connection connection, String tag, String ... attributes) {
        return AIMessage.sendMessage(connection, AIMessage.makeTrivial(tag, attributes));
    }

    public static Element makeTrivial(String tag, String ... attributes) {
        if ((attributes.length & 1) == 1) {
            throw new IllegalArgumentException("Attributes list must have even length");
        }
        Element element = DOMMessage.createNewRootElement(tag);
        for (int i = 0; i < attributes.length; i += 2) {
            element.setAttribute(attributes[i], attributes[i + 1]);
        }
        return element;
    }

    public static boolean askAttack(AIUnit aiUnit, Map.Direction direction) {
        return AIMessage.sendMessage(aiUnit.getConnection(), new AttackMessage(aiUnit.getUnit(), direction));
    }

    public static boolean askBuildColony(AIUnit aiUnit, String name) {
        return AIMessage.sendMessage(aiUnit.getConnection(), new BuildColonyMessage(name, aiUnit.getUnit()));
    }

    public static boolean askBuyGoods(AIUnit aiUnit, GoodsType type, int amount) {
        return AIMessage.sendMessage(aiUnit.getConnection(), new BuyGoodsMessage(aiUnit.getUnit(), type, amount));
    }

    public static boolean askCashInTreasureTrain(AIUnit aiUnit) {
        return AIMessage.sendMessage(aiUnit.getConnection(), new CashInTreasureTrainMessage(aiUnit.getUnit()));
    }

    public static boolean askChangeState(AIUnit aiUnit, Unit.UnitState state) {
        return AIMessage.sendMessage(aiUnit.getConnection(), new ChangeStateMessage(aiUnit.getUnit(), state));
    }

    public static boolean askChangeWorkType(AIUnit aiUnit, GoodsType type) {
        return AIMessage.sendMessage(aiUnit.getConnection(), new ChangeWorkTypeMessage(aiUnit.getUnit(), type));
    }

    public static boolean askChangeWorkImprovementType(AIUnit aiUnit, TileImprovementType type) {
        return AIMessage.sendMessage(aiUnit.getConnection(), new ChangeWorkImprovementTypeMessage(aiUnit.getUnit(), type));
    }

    public static boolean askChooseFoundingFather(Connection conn, FoundingFather ff) {
        return AIMessage.sendTrivial(conn, "chooseFoundingFather", "foundingFather", ff.getId());
    }

    public static boolean askClaimLand(Connection conn, Tile tile, Colony colony, int price) {
        return AIMessage.sendMessage(conn, new ClaimLandMessage(tile, colony, price));
    }

    public static boolean askClearSpeciality(AIUnit aiUnit) {
        return AIMessage.sendMessage(aiUnit.getConnection(), new ClearSpecialityMessage(aiUnit.getUnit()));
    }

    public static boolean askCloseTransaction(AIUnit aiUnit, Settlement settlement) {
        return AIMessage.sendMessage(aiUnit.getConnection(), new CloseTransactionMessage(aiUnit.getUnit(), settlement));
    }

    public static boolean askDeliverGift(AIUnit aiUnit, Settlement settlement, Goods goods) {
        return AIMessage.sendMessage(aiUnit.getConnection(), new DeliverGiftMessage(aiUnit.getUnit(), settlement, goods));
    }

    public static boolean askDisembark(AIUnit aiUnit) {
        return AIMessage.sendMessage(aiUnit.getConnection(), new DisembarkMessage(aiUnit.getUnit()));
    }

    public static boolean askEmbark(AIUnit aiUnit, Unit unit) {
        return AIMessage.sendMessage(aiUnit.getConnection(), new EmbarkMessage(unit, aiUnit.getUnit(), null));
    }

    public static boolean askEmigrate(Connection connection, int slot) {
        return AIMessage.sendMessage(connection, new EmigrateUnitMessage(slot));
    }

    public static boolean askEndTurn(Connection connection) {
        return AIMessage.sendTrivial(connection, "endTurn", new String[0]);
    }

    public static boolean askEquipUnit(AIUnit aiUnit, EquipmentType type, int amount) {
        return AIMessage.sendMessage(aiUnit.getConnection(), new EquipUnitMessage(aiUnit.getUnit(), type, amount));
    }

    public static boolean askEstablishMission(AIUnit aiUnit, Map.Direction direction, boolean denounce) {
        return AIMessage.sendMessage(aiUnit.getConnection(), new MissionaryMessage(aiUnit.getUnit(), direction, denounce));
    }

    public static boolean askGetTransaction(AIUnit aiUnit, Settlement settlement) {
        return AIMessage.sendMessage(aiUnit.getConnection(), new GetTransactionMessage(aiUnit.getUnit(), settlement));
    }

    public static boolean askIndianDemand(AIUnit aiUnit, Colony colony, Goods goods, int gold) {
        return AIMessage.sendMessage(aiUnit.getConnection(), new IndianDemandMessage(aiUnit.getUnit(), colony, goods, gold));
    }

    public static boolean askLoadCargo(AIUnit aiUnit, Goods goods) {
        return AIMessage.sendMessage(aiUnit.getConnection(), new LoadCargoMessage(goods, aiUnit.getUnit()));
    }

    public static boolean askLoot(AIUnit aiUnit, String defenderId, List<Goods> goods) {
        return AIMessage.sendMessage(aiUnit.getConnection(), new LootCargoMessage(aiUnit.getUnit(), defenderId, goods));
    }

    public static boolean askMove(AIUnit aiUnit, Map.Direction direction) {
        return AIMessage.sendMessage(aiUnit.getConnection(), new MoveMessage(aiUnit.getUnit(), direction));
    }

    public static boolean askMoveToAmerica(AIUnit aiUnit) {
        return AIMessage.sendMessage(aiUnit.getConnection(), new MoveToAmericaMessage(aiUnit.getUnit()));
    }

    public static boolean askMoveToEurope(AIUnit aiUnit) {
        return AIMessage.sendMessage(aiUnit.getConnection(), new MoveToEuropeMessage(aiUnit.getUnit()));
    }

    public static boolean askPutOutsideColony(AIUnit aiUnit) {
        return AIMessage.sendMessage(aiUnit.getConnection(), new PutOutsideColonyMessage(aiUnit.getUnit()));
    }

    public static boolean askScoutIndianSettlement(AIUnit aiUnit, Map.Direction direction) {
        return AIMessage.sendMessage(aiUnit.getConnection(), new ScoutIndianSettlementMessage(aiUnit.getUnit(), direction));
    }

    public static boolean askSellGoods(AIUnit aiUnit, Goods goods) {
        return AIMessage.sendMessage(aiUnit.getConnection(), new SellGoodsMessage(goods, aiUnit.getUnit()));
    }

    public static boolean askSetBuildQueue(AIColony aiColony, List<BuildableType> queue) {
        return AIMessage.sendMessage(aiColony.getConnection(), new SetBuildQueueMessage(aiColony.getColony(), queue));
    }

    public static boolean askTrainUnitInEurope(Connection connection, UnitType type) {
        return AIMessage.sendMessage(connection, new TrainUnitInEuropeMessage(type));
    }

    public static boolean askUnloadCargo(AIUnit aiUnit, Goods goods) {
        return AIMessage.sendMessage(aiUnit.getConnection(), new UnloadCargoMessage(goods));
    }

    public static boolean askWork(AIUnit aiUnit, WorkLocation workLocation) {
        return AIMessage.sendMessage(aiUnit.getConnection(), new WorkMessage(aiUnit.getUnit(), workLocation));
    }
}

