/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.resources;

import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.freecol.common.io.sza.SimpleZippedAnimation;
import net.sf.freecol.common.resources.Resource;

public class SZAResource
extends Resource {
    private static final Logger logger = Logger.getLogger(SZAResource.class.getName());
    private Map<Double, SimpleZippedAnimation> scaledSzAnimations = new HashMap<Double, SimpleZippedAnimation>();
    private SimpleZippedAnimation szAnimation = null;
    private volatile Object loadingLock = new Object();

    SZAResource(URI resourceLocator) {
        super(resourceLocator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preload() {
        Object object = this.loadingLock;
        synchronized (object) {
            if (this.szAnimation == null) {
                try {
                    this.szAnimation = new SimpleZippedAnimation(this.getResourceLocator().toURL());
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "Could not load SimpleZippedAnimation: " + this.getResourceLocator(), e);
                }
            }
        }
    }

    public SimpleZippedAnimation getSimpleZippedAnimation() {
        if (this.szAnimation == null) {
            this.preload();
        }
        return this.szAnimation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleZippedAnimation getSimpleZippedAnimation(double scale) {
        SimpleZippedAnimation sza = this.getSimpleZippedAnimation();
        if (scale == 1.0) {
            return sza;
        }
        SimpleZippedAnimation cachedScaledVersion = this.scaledSzAnimations.get(scale);
        if (cachedScaledVersion != null) {
            return cachedScaledVersion;
        }
        Object object = this.loadingLock;
        synchronized (object) {
            if (this.scaledSzAnimations.get(scale) != null) {
                return this.scaledSzAnimations.get(scale);
            }
            SimpleZippedAnimation scaledVersion = sza.createScaledVersion(scale);
            this.scaledSzAnimations.put(scale, scaledVersion);
            return scaledVersion;
        }
    }
}

