/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.option;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.option.AbstractOption;
import net.sf.freecol.common.option.ListOptionSelector;
import net.sf.freecol.common.option.OptionGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListOption<T>
extends AbstractOption<List<T>> {
    private static Logger logger = Logger.getLogger(ListOption.class.getName());
    public static final String OPTION_VALUE_TAG = "optionValue";
    private ListOptionSelector<T> selector;
    private List<T> value;

    public ListOption(ListOptionSelector<T> selector, XMLStreamReader in) throws XMLStreamException {
        super("NO_ID");
        this.value = new ArrayList<T>();
        this.selector = selector;
        this.readFromXML(in);
    }

    public ListOption(ListOptionSelector<T> selector, String id, T ... defaultValues) {
        this(selector, id, null, defaultValues);
    }

    public ListOption(ListOptionSelector<T> selector, String id, OptionGroup optionGroup, T ... defaultValues) {
        super(id);
        optionGroup.add(this);
        this.setGroup(optionGroup.getId());
        this.value = new ArrayList<T>();
        this.selector = selector;
        for (T s : defaultValues) {
            this.value.add(s);
        }
    }

    public ListOptionSelector<T> getListOptionSelector() {
        return this.selector;
    }

    @Override
    public List<T> getValue() {
        return new ArrayList<T>(this.value);
    }

    @Override
    public void setValue(List<T> value) {
        List<T> oldValue = this.value;
        this.value = value;
        if (value != oldValue && this.isDefined) {
            this.firePropertyChange("value", oldValue, value);
        }
        this.isDefined = true;
    }

    private List<String> getValueIds() {
        ArrayList<String> ids = new ArrayList<String>(this.value.size());
        for (T t : this.value) {
            if (t == null) continue;
            ids.add(this.selector.getId(t));
        }
        return ids;
    }

    private void setValueIds(List<String> ids) {
        ArrayList<T> value = new ArrayList<T>(ids.size());
        for (String id : ids) {
            value.add(this.selector.getObject(id));
        }
        this.setValue((List<T>)value);
    }

    @Override
    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        super.toXML(out, ListOption.getXMLElementTagName());
    }

    @Override
    protected void writeChildren(XMLStreamWriter out) throws XMLStreamException {
        super.writeChildren(out);
        for (String id : this.getValueIds()) {
            out.writeStartElement(OPTION_VALUE_TAG);
            out.writeAttribute("id", id);
            out.writeEndElement();
        }
    }

    @Override
    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        String id = in.getAttributeValue(null, "id");
        if (id == null && this.getId().equals("NO_ID")) {
            throw new XMLStreamException("invalid <" + ListOption.getXMLElementTagName() + "> tag : no id attribute found.");
        }
        this.value.clear();
        while (in.nextTag() != 2) {
            if (in.getLocalName().equals("value")) {
                this.setValueIds(this.readFromListElement("value", in, String.class));
                in.nextTag();
                continue;
            }
            if (!OPTION_VALUE_TAG.equals(in.getLocalName())) continue;
            String valueId = in.getAttributeValue(null, "id");
            this.value.add(this.selector.getObject(valueId));
            in.nextTag();
        }
        this.setValue(this.value);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append(this.getId() + "<");
        for (String s : this.getValueIds()) {
            b.append(" " + s);
        }
        b.append(" >");
        return b.toString();
    }

    public static String getXMLElementTagName() {
        return "listOption";
    }
}

