/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

public class LoadCargoMessage
extends DOMMessage {
    private Goods goods;
    private String carrierId;

    public LoadCargoMessage(Goods goods, Unit carrier) {
        this.goods = goods;
        this.carrierId = carrier.getId();
    }

    public LoadCargoMessage(Game game, Element element) {
        this.carrierId = element.getAttribute("carrier");
        this.goods = new Goods(game, (Element)element.getChildNodes().item(0));
    }

    public Element handle(FreeColServer server, Player player, Connection connection) {
        Unit unit;
        ServerPlayer serverPlayer = server.getPlayer(connection);
        try {
            unit = server.getUnitSafely(this.carrierId, serverPlayer);
        }
        catch (Exception e) {
            return DOMMessage.clientError(e.getMessage());
        }
        return server.getInGameController().loadCargo(serverPlayer, unit, this.goods);
    }

    public Element toXMLElement() {
        Element result = LoadCargoMessage.createNewRootElement(LoadCargoMessage.getXMLElementTagName());
        result.setAttribute("carrier", this.carrierId);
        result.appendChild(this.goods.toXMLElement(null, result.getOwnerDocument()));
        return result;
    }

    public static String getXMLElementTagName() {
        return "loadCargo";
    }
}

