/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.FreeColGameObjectType;
import net.sf.freecol.common.model.NationType;
import net.sf.freecol.common.model.Specification;

public class Nation
extends FreeColGameObjectType {
    public static String UNKNOWN_NATION_ID = "model.nation.unknownEnemy";
    private NationType type;
    private boolean selectable;
    private String anthem;
    private Nation refNation;

    public Nation(String id, Specification specification) {
        super(id, specification);
    }

    public final String getAnthem() {
        return this.anthem;
    }

    public final void setAnthem(String newAnthem) {
        this.anthem = newAnthem;
    }

    public final NationType getType() {
        return this.type;
    }

    public final void setType(NationType newType) {
        this.type = newType;
    }

    public final String getRulerNameKey() {
        return this.getId() + ".ruler";
    }

    public final boolean isSelectable() {
        return this.selectable;
    }

    public final Nation getRefNation() {
        return this.refNation;
    }

    public final void setRefNation(Nation newRefNation) {
        this.refNation = newRefNation;
    }

    public final void setSelectable(boolean newSelectable) {
        this.selectable = newSelectable;
    }

    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        super.toXML(out, Nation.getXMLElementTagName());
    }

    protected void writeAttributes(XMLStreamWriter out) throws XMLStreamException {
        super.writeAttributes(out);
        out.writeAttribute("nation-type", this.type.getId());
        out.writeAttribute("selectable", Boolean.toString(this.selectable));
        if (this.anthem != null) {
            out.writeAttribute("anthem", this.anthem);
        }
        if (this.refNation != null) {
            out.writeAttribute("ref", this.refNation.getId());
        }
    }

    protected void readAttributes(XMLStreamReader in) throws XMLStreamException {
        super.readAttributes(in);
        this.type = this.getSpecification().getNationType(in.getAttributeValue(null, "nation-type"));
        this.selectable = Nation.getAttribute(in, "selectable", false);
        String refId = this.getAttribute(in, "ref", null);
        if (refId != null) {
            this.refNation = this.getSpecification().getNation(refId);
        }
        this.anthem = in.getAttributeValue(null, "anthem");
    }

    public static String getXMLElementTagName() {
        return "nation";
    }
}

