/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.List;
import java.util.Random;
import java.util.Set;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Locatable;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Unit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CombatModel {
    public boolean combatIsMeasurement(FreeColGameObject attacker, FreeColGameObject defender) {
        return attacker instanceof Unit && defender == null;
    }

    public boolean combatIsAttack(FreeColGameObject attacker, FreeColGameObject defender) {
        return attacker instanceof Unit && defender instanceof Unit;
    }

    public boolean combatIsSettlementAttack(FreeColGameObject attacker, FreeColGameObject defender) {
        return attacker instanceof Unit && defender instanceof Settlement;
    }

    public boolean combatIsBombard(FreeColGameObject attacker, FreeColGameObject defender) {
        return attacker instanceof Settlement && defender instanceof Unit && ((Unit)defender).isNaval();
    }

    public boolean combatIsAmphibious(FreeColGameObject attacker, FreeColGameObject defender) {
        return attacker instanceof Unit && ((Unit)attacker).getTile() != null && !((Unit)attacker).getTile().isLand() && defender instanceof Locatable && ((Locatable)((Object)defender)).getTile() != null && ((Locatable)((Object)defender)).getTile().isLand();
    }

    public abstract CombatOdds calculateCombatOdds(FreeColGameObject var1, FreeColGameObject var2);

    public abstract float getOffencePower(FreeColGameObject var1, FreeColGameObject var2);

    public abstract float getDefencePower(FreeColGameObject var1, FreeColGameObject var2);

    public abstract Set<Modifier> getOffensiveModifiers(FreeColGameObject var1, FreeColGameObject var2);

    public abstract Set<Modifier> getDefensiveModifiers(FreeColGameObject var1, FreeColGameObject var2);

    public abstract List<CombatResult> generateAttackResult(Random var1, FreeColGameObject var2, FreeColGameObject var3);

    public class CombatOdds {
        public static final float UNKNOWN_ODDS = -1.0f;
        public float win;

        public CombatOdds(float win) {
            this.win = win;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CombatResult {
        NO_RESULT,
        LOSE,
        WIN,
        AUTOEQUIP_UNIT,
        BURN_MISSIONS,
        CAPTURE_AUTOEQUIP,
        CAPTURE_COLONY,
        CAPTURE_CONVERT,
        CAPTURE_EQUIP,
        CAPTURE_UNIT,
        DAMAGE_COLONY_SHIPS,
        DAMAGE_SHIP_ATTACK,
        DAMAGE_SHIP_BOMBARD,
        DEMOTE_UNIT,
        DESTROY_COLONY,
        DESTROY_SETTLEMENT,
        EVADE_ATTACK,
        EVADE_BOMBARD,
        LOOT_SHIP,
        LOSE_AUTOEQUIP,
        LOSE_EQUIP,
        PILLAGE_COLONY,
        PROMOTE_UNIT,
        SINK_COLONY_SHIPS,
        SINK_SHIP_ATTACK,
        SINK_SHIP_BOMBARD,
        SLAUGHTER_UNIT;

    }
}

