/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.video;

import com.fluendo.player.Cortado;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.MouseListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.border.Border;
import net.sf.freecol.client.gui.panel.FreeColImageBorder;
import net.sf.freecol.client.gui.video.Video;
import net.sf.freecol.client.gui.video.VideoListener;

public class VideoComponent
extends JPanel {
    private final Cortado applet;
    private List<VideoListener> videoListeners = new LinkedList<VideoListener>();

    public VideoComponent(Video video, boolean mute) {
        String url = video.getURL().toExternalForm();
        this.setBorder(this.createBorder());
        Insets insets = this.getInsets();
        this.applet = new Cortado();
        this.applet.setSize(655, 480);
        this.applet.setLocation(insets.left - 1, insets.top - 1);
        this.applet.setParam("url", url);
        this.applet.setParam("local", "false");
        this.applet.setParam("framerate", "60");
        this.applet.setParam("keepaspect", "true");
        this.applet.setParam("video", "true");
        this.applet.setParam("audio", mute ? "false" : "true");
        this.applet.setParam("kateIndex", "0");
        this.applet.setParam("bufferSize", "200");
        this.applet.setParam("showStatus", "hide");
        this.applet.setParam("debug", "0");
        this.applet.init();
        this.setLayout(null);
        this.add((Component)this.applet);
        this.setSize(this.applet.getWidth() + insets.left + insets.right - 2, this.applet.getHeight() + insets.top + insets.bottom - 2);
    }

    public void addVideoListener(VideoListener videoListener) {
        this.videoListeners.add(videoListener);
    }

    public void removeVideoListener(VideoListener videoListener) {
        this.videoListeners.remove(videoListener);
    }

    public void addMouseListener(MouseListener l) {
        super.addMouseListener(l);
        this.applet.addMouseListener(l);
    }

    public void removeMouseListener(MouseListener l) {
        super.removeMouseListener(l);
        this.applet.removeMouseListener(l);
    }

    public void play() {
        this.applet.start();
    }

    public void stop() {
        this.applet.stop();
    }

    private Border createBorder() {
        return FreeColImageBorder.imageBorder;
    }
}

