/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.TransferHandler;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.PanelUI;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.DefaultTransferHandler;
import net.sf.freecol.client.gui.panel.DragListener;
import net.sf.freecol.client.gui.panel.DropListener;
import net.sf.freecol.client.gui.panel.FreeColDialog;
import net.sf.freecol.client.gui.panel.ImageSelection;
import net.sf.freecol.client.gui.plaf.FreeColSelectedPanelUI;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.TradeRoute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TradeRouteInputDialog
extends FreeColDialog<Boolean>
implements ActionListener {
    private static final Logger logger = Logger.getLogger(TradeRouteInputDialog.class.getName());
    public static final DataFlavor STOP_FLAVOR = new DataFlavor(TradeRoute.Stop.class, "Stop");
    private TradeRoute originalRoute;
    private final JButton addStopButton = new JButton(Messages.message("traderouteDialog.addStop"));
    private final JButton removeStopButton = new JButton(Messages.message("traderouteDialog.removeStop"));
    private final CargoHandler cargoHandler = new CargoHandler();
    private final MouseListener dragListener = new DragListener(this);
    private final MouseListener dropListener = new DropListener();
    private final GoodsPanel goodsPanel;
    private final CargoPanel cargoPanel;
    private final JComboBox destinationSelector = new JComboBox();
    private final JTextField tradeRouteName = new JTextField(Messages.message("traderouteDialog.newRoute"));
    private final DefaultListModel listModel = new DefaultListModel();
    private final JList stopList = new JList(this.listModel);
    private final JScrollPane tradeRouteView = new JScrollPane(this.stopList);
    private final JLabel nameLabel = new JLabel(Messages.message("traderouteDialog.nameLabel"));
    private final JLabel destinationLabel = new JLabel(Messages.message("traderouteDialog.destinationLabel"));

    public TradeRouteInputDialog(Canvas parent, TradeRoute newRoute) {
        super(parent);
        this.originalRoute = newRoute;
        this.goodsPanel = new GoodsPanel();
        this.goodsPanel.setTransferHandler(this.cargoHandler);
        this.cargoPanel = new CargoPanel();
        this.cargoPanel.setTransferHandler(this.cargoHandler);
        this.stopList.setCellRenderer(new StopRenderer());
        this.stopList.setFixedCellHeight(48);
        this.stopList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                TradeRouteInputDialog.this.updateButtons();
            }
        });
        this.addStopButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int startIndex = -1;
                int endIndex = -1;
                if (TradeRouteInputDialog.this.destinationSelector.getSelectedIndex() == 0) {
                    startIndex = 1;
                    endIndex = TradeRouteInputDialog.this.destinationSelector.getItemCount() - 1;
                } else {
                    endIndex = startIndex = TradeRouteInputDialog.this.destinationSelector.getSelectedIndex();
                }
                ArrayList<GoodsType> cargo = new ArrayList<GoodsType>();
                for (Component comp : TradeRouteInputDialog.this.cargoPanel.getComponents()) {
                    CargoLabel label = (CargoLabel)comp;
                    cargo.add(label.getType());
                }
                int maxIndex = TradeRouteInputDialog.this.stopList.getMaxSelectionIndex();
                for (int i = startIndex; i <= endIndex; ++i) {
                    TradeRoute tradeRoute = TradeRouteInputDialog.this.originalRoute;
                    tradeRoute.getClass();
                    TradeRoute.Stop stop = new TradeRoute.Stop(tradeRoute, (Location)TradeRouteInputDialog.this.destinationSelector.getItemAt(i));
                    stop.setCargo(cargo);
                    if (maxIndex < 0) {
                        TradeRouteInputDialog.this.listModel.addElement(stop);
                        continue;
                    }
                    TradeRouteInputDialog.this.listModel.add(++maxIndex, stop);
                }
            }
        });
        this.removeStopButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int count = 0;
                for (int index : TradeRouteInputDialog.this.stopList.getSelectedIndices()) {
                    TradeRouteInputDialog.this.listModel.remove(index - count);
                    ++count;
                }
            }
        });
        this.stopList.setDragEnabled(true);
        this.stopList.setTransferHandler(new StopHandler());
        this.stopList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                int[] indices;
                if (!e.getValueIsAdjusting() && (indices = TradeRouteInputDialog.this.stopList.getSelectedIndices()).length > 0) {
                    TradeRouteInputDialog.this.cargoPanel.initialize((TradeRoute.Stop)TradeRouteInputDialog.this.listModel.get(indices[0]));
                }
            }
        });
        this.setLayout((LayoutManager)new MigLayout("wrap 4, fill", "[]20[fill]rel"));
        this.add((Component)TradeRouteInputDialog.getDefaultHeader(Messages.message("traderouteDialog.editRoute")), "span, align center");
        this.add((Component)this.tradeRouteView, "span 1 5, grow");
        this.add(this.nameLabel);
        this.add((Component)this.tradeRouteName, "span");
        this.add(this.destinationLabel);
        this.add((Component)this.destinationSelector, "span");
        this.add((Component)this.addStopButton, "skip 2");
        this.add(this.removeStopButton);
        this.add((Component)this.goodsPanel, "span");
        this.add((Component)this.cargoPanel, "span, height 80:, growy");
        this.add((Component)this.okButton, "newline 20, span, split 2, tag ok");
        this.add((Component)this.cancelButton, "tag cancel");
        TradeRoute tradeRoute = newRoute.clone();
        Player player = this.getMyPlayer();
        this.destinationSelector.addItem(Messages.message(StringTemplate.template("report.allColonies").addName("%number%", "")));
        if (player.getEurope() != null) {
            this.destinationSelector.addItem(player.getEurope());
        }
        for (Colony colony : this.getSortedColonies()) {
            this.destinationSelector.addItem(colony);
        }
        for (TradeRoute.Stop stop : tradeRoute.getStops()) {
            this.listModel.addElement(stop);
        }
        if (this.listModel.getSize() > 0) {
            this.stopList.setSelectedIndex(0);
            TradeRoute.Stop selectedStop = (TradeRoute.Stop)this.listModel.firstElement();
            this.cargoPanel.initialize(selectedStop);
        }
        this.updateButtons();
        this.tradeRouteName.setText(tradeRoute.getName());
        this.restoreSavedSize(this.getPreferredSize());
    }

    public void updateButtons() {
        if (this.stopList.getSelectedIndices().length == 0) {
            this.removeStopButton.setEnabled(false);
        } else {
            this.removeStopButton.setEnabled(true);
        }
    }

    private boolean verifyNewTradeRoute() {
        Player player = this.getCanvas().getFreeColClient().getMyPlayer();
        for (TradeRoute route : player.getTradeRoutes()) {
            if (route.getId().equals(this.originalRoute.getId()) || !route.getName().equals(this.tradeRouteName.getText())) continue;
            this.getCanvas().errorMessage("traderouteDialog.duplicateName");
            return false;
        }
        if (this.listModel.getSize() < 2) {
            this.getCanvas().errorMessage("traderouteDialog.notEnoughStops");
            return false;
        }
        for (int index = 0; index < this.listModel.getSize(); ++index) {
            TradeRoute.Stop stop = (TradeRoute.Stop)this.listModel.get(index);
            if (TradeRoute.isStopValid(player, stop)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if ("OK".equals(command)) {
            if (this.verifyNewTradeRoute()) {
                this.getCanvas().remove(this);
                this.originalRoute.setName(this.tradeRouteName.getText());
                ArrayList<TradeRoute.Stop> stops = new ArrayList<TradeRoute.Stop>();
                for (int index = 0; index < this.listModel.getSize(); ++index) {
                    stops.add((TradeRoute.Stop)this.listModel.get(index));
                }
                this.originalRoute.setStops(stops);
                this.getController().updateTradeRoute(this.originalRoute);
                this.setResponse(Boolean.TRUE);
            }
        } else if ("CANCEL".equals(command)) {
            this.getCanvas().remove(this);
            this.setResponse(Boolean.FALSE);
        } else {
            super.actionPerformed(event);
        }
    }

    private class StopRenderer
    implements ListCellRenderer {
        private final JPanel SELECTED_COMPONENT = new JPanel();
        private final JPanel NORMAL_COMPONENT = new JPanel();

        public StopRenderer() {
            this.NORMAL_COMPONENT.setLayout((LayoutManager)new MigLayout("", "[80, center][]"));
            this.NORMAL_COMPONENT.setOpaque(false);
            this.SELECTED_COMPONENT.setLayout((LayoutManager)new MigLayout("", "[80, center][]"));
            this.SELECTED_COMPONENT.setOpaque(false);
            this.SELECTED_COMPONENT.setUI((PanelUI)FreeColSelectedPanelUI.createUI(this.SELECTED_COMPONENT));
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
            JLabel name;
            JLabel icon;
            JPanel panel = isSelected ? this.SELECTED_COMPONENT : this.NORMAL_COMPONENT;
            panel.removeAll();
            panel.setForeground(list.getForeground());
            panel.setFont(list.getFont());
            TradeRoute.Stop stop = (TradeRoute.Stop)value;
            Location location = stop.getLocation();
            if (location instanceof Europe) {
                Europe europe = (Europe)location;
                Image image = TradeRouteInputDialog.this.getLibrary().getCoatOfArmsImage(europe.getOwner().getNation(), 0.5);
                icon = new JLabel(new ImageIcon(image));
                name = TradeRouteInputDialog.this.localizedLabel(europe.getNameKey());
            } else if (location instanceof Colony) {
                Colony colony = (Colony)location;
                icon = new JLabel(new ImageIcon(TradeRouteInputDialog.this.getLibrary().getSettlementImage(colony, 0.5)));
                name = new JLabel(colony.getName());
            } else {
                throw new IllegalStateException("Bogus location: " + location);
            }
            panel.add((Component)icon, "spany");
            panel.add((Component)name, "span, wrap");
            for (GoodsType cargo : stop.getCargo()) {
                panel.add(new JLabel(new ImageIcon(TradeRouteInputDialog.this.getLibrary().getGoodsImage(cargo, 0.5))));
            }
            return panel;
        }
    }

    public class StopHandler
    extends TransferHandler {
        protected Transferable createTransferable(JComponent c) {
            JList list = (JList)c;
            DefaultListModel model = (DefaultListModel)list.getModel();
            ArrayList<TradeRoute.Stop> stops = new ArrayList<TradeRoute.Stop>();
            for (int index : list.getSelectedIndices()) {
                stops.add((TradeRoute.Stop)model.get(index));
            }
            return new StopTransferable(stops);
        }

        public int getSourceActions(JComponent c) {
            return 2;
        }

        public boolean importData(JComponent target, Transferable data) {
            if (this.canImport(target, data.getTransferDataFlavors())) {
                try {
                    List stops = (List)data.getTransferData(STOP_FLAVOR);
                    if (target instanceof JList) {
                        JList list = (JList)target;
                        DefaultListModel model = (DefaultListModel)list.getModel();
                        int index = list.getMaxSelectionIndex();
                        for (Object o : stops) {
                            TradeRoute tradeRoute = TradeRouteInputDialog.this.originalRoute;
                            tradeRoute.getClass();
                            TradeRoute.Stop stop = new TradeRoute.Stop(tradeRoute, (TradeRoute.Stop)o);
                            if (index < 0) {
                                model.addElement(stop);
                                continue;
                            }
                            model.add(++index, stop);
                        }
                    }
                    return true;
                }
                catch (UnsupportedFlavorException ufe) {
                    logger.warning(ufe.toString());
                }
                catch (IOException ioe) {
                    logger.warning(ioe.toString());
                }
            }
            return false;
        }

        protected void exportDone(JComponent source, Transferable data, int action) {
            try {
                if (source instanceof JList && action == 2) {
                    JList stopList = (JList)source;
                    DefaultListModel listModel = (DefaultListModel)stopList.getModel();
                    for (Object o : (List)data.getTransferData(STOP_FLAVOR)) {
                        listModel.removeElement(o);
                    }
                }
            }
            catch (Exception e) {
                logger.warning(e.toString());
            }
        }

        public boolean canImport(JComponent c, DataFlavor[] flavors) {
            for (int i = 0; i < flavors.length; ++i) {
                if (!flavors[i].equals(STOP_FLAVOR)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class StopTransferable
    implements Transferable {
        private List<TradeRoute.Stop> stops;

        public StopTransferable(List<TradeRoute.Stop> stops) {
            this.stops = stops;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) {
            return this.stops;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{STOP_FLAVOR};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return flavor == STOP_FLAVOR;
        }
    }

    public class CargoHandler
    extends TransferHandler {
        protected Transferable createTransferable(JComponent c) {
            return new ImageSelection((CargoLabel)c);
        }

        public int getSourceActions(JComponent c) {
            return 3;
        }

        public boolean importData(JComponent target, Transferable data) {
            if (this.canImport(target, data.getTransferDataFlavors())) {
                try {
                    CargoLabel label = (CargoLabel)data.getTransferData(DefaultTransferHandler.flavor);
                    if (target instanceof CargoPanel) {
                        int[] indices;
                        CargoLabel newLabel = new CargoLabel(label.getType());
                        TradeRouteInputDialog.this.cargoPanel.add(newLabel);
                        TradeRouteInputDialog.this.cargoPanel.revalidate();
                        for (int index : indices = TradeRouteInputDialog.this.stopList.getSelectedIndices()) {
                            TradeRoute.Stop stop = (TradeRoute.Stop)TradeRouteInputDialog.this.listModel.get(index);
                            stop.addCargo(label.getType());
                            stop.setModified(true);
                        }
                        TradeRouteInputDialog.this.stopList.revalidate();
                        TradeRouteInputDialog.this.stopList.repaint();
                    }
                    return true;
                }
                catch (UnsupportedFlavorException ufe) {
                    logger.warning(ufe.toString());
                }
                catch (IOException ioe) {
                    logger.warning(ioe.toString());
                }
            }
            return false;
        }

        protected void exportDone(JComponent source, Transferable data, int action) {
            try {
                CargoLabel label = (CargoLabel)data.getTransferData(DefaultTransferHandler.flavor);
                if (source.getParent() instanceof CargoPanel) {
                    int[] indices;
                    TradeRouteInputDialog.this.cargoPanel.remove(label);
                    for (int stopIndex : indices = TradeRouteInputDialog.this.stopList.getSelectedIndices()) {
                        TradeRoute.Stop stop = (TradeRoute.Stop)TradeRouteInputDialog.this.listModel.get(stopIndex);
                        ArrayList<GoodsType> cargo = new ArrayList<GoodsType>(stop.getCargo());
                        for (int index = 0; index < cargo.size(); ++index) {
                            if (cargo.get(index) != label.getType()) continue;
                            cargo.remove(index);
                            stop.setModified(true);
                            break;
                        }
                        stop.setCargo(cargo);
                    }
                    TradeRouteInputDialog.this.stopList.revalidate();
                    TradeRouteInputDialog.this.stopList.repaint();
                    TradeRouteInputDialog.this.cargoPanel.revalidate();
                    TradeRouteInputDialog.this.cargoPanel.repaint();
                }
            }
            catch (UnsupportedFlavorException ufe) {
                logger.warning(ufe.toString());
            }
            catch (IOException ioe) {
                logger.warning(ioe.toString());
            }
        }

        public boolean canImport(JComponent c, DataFlavor[] flavors) {
            for (int i = 0; i < flavors.length; ++i) {
                if (!flavors[i].equals(DefaultTransferHandler.flavor)) continue;
                return true;
            }
            return false;
        }
    }

    public class CargoPanel
    extends JPanel {
        public CargoPanel() {
            this.setOpaque(false);
            this.setBorder(BorderFactory.createTitledBorder(Messages.message("cargoOnCarrier")));
            this.addMouseListener(TradeRouteInputDialog.this.dropListener);
        }

        public void initialize(TradeRoute.Stop newStop) {
            this.removeAll();
            if (newStop != null) {
                for (GoodsType goodsType : newStop.getCargo()) {
                    this.add(new CargoLabel(goodsType));
                }
            }
            this.revalidate();
            this.repaint();
        }
    }

    public class GoodsPanel
    extends JPanel {
        public GoodsPanel() {
            super(new GridLayout(0, 4, 3, 3));
            for (GoodsType goodsType : TradeRouteInputDialog.this.getSpecification().getGoodsTypeList()) {
                if (!goodsType.isStorable()) continue;
                CargoLabel label = new CargoLabel(goodsType);
                this.add(label);
            }
            this.setOpaque(false);
            this.setBorder(BorderFactory.createTitledBorder(Messages.message("goods")));
            this.addMouseListener(TradeRouteInputDialog.this.dropListener);
        }
    }

    public class CargoLabel
    extends JLabel {
        private final GoodsType goodsType;

        public CargoLabel(GoodsType type) {
            super(TradeRouteInputDialog.this.getLibrary().getGoodsImageIcon(type));
            this.setTransferHandler(TradeRouteInputDialog.this.cargoHandler);
            this.addMouseListener(TradeRouteInputDialog.this.dragListener);
            this.goodsType = type;
        }

        public GoodsType getType() {
            return this.goodsType;
        }
    }
}

