/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import net.sf.freecol.client.control.PreGameController;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.AdvantageCellEditor;
import net.sf.freecol.client.gui.panel.AdvantageCellRenderer;
import net.sf.freecol.client.gui.panel.ColopediaPanel;
import net.sf.freecol.client.gui.panel.ColorCellRenderer;
import net.sf.freecol.common.model.EuropeanNationType;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.NationOptions;
import net.sf.freecol.common.model.NationType;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.resources.ResourceManager;

public final class PlayersTable
extends JTable {
    private static final Logger logger = Logger.getLogger(PlayersTable.class.getName());
    public static final int NATION_COLUMN = 0;
    public static final int AVAILABILITY_COLUMN = 1;
    public static final int ADVANTAGE_COLUMN = 2;
    public static final int COLOR_COLUMN = 3;
    public static final int PLAYER_COLUMN = 4;
    private static final String[] columnNames = new String[]{Messages.message("nation"), Messages.message("availability"), Messages.message("advantage"), Messages.message("color"), Messages.message("player")};
    private static final NationOptions.NationState[] allStates = new NationOptions.NationState[]{NationOptions.NationState.AVAILABLE, NationOptions.NationState.AI_ONLY, NationOptions.NationState.NOT_AVAILABLE};
    private static final NationOptions.NationState[] aiStates = new NationOptions.NationState[]{NationOptions.NationState.AI_ONLY, NationOptions.NationState.NOT_AVAILABLE};
    private final ImageLibrary library;

    public PlayersTable(final Canvas canvas, NationOptions nationOptions, Player myPlayer) {
        this.library = canvas.getImageLibrary();
        this.setModel(new PlayersTableModel(canvas.getFreeColClient().getPreGameController(), nationOptions, myPlayer));
        this.setRowHeight(47);
        JButton nationButton = new JButton(Messages.message("nation"));
        JLabel availabilityLabel = new JLabel(Messages.message("availability"));
        JButton advantageButton = new JButton(Messages.message("advantage"));
        JLabel colorLabel = new JLabel(Messages.message("color"));
        JLabel playerLabel = new JLabel(Messages.message("player"));
        nationButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                canvas.showPanel(new ColopediaPanel(canvas, ColopediaPanel.PanelType.NATIONS, null));
            }
        });
        advantageButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                canvas.showPanel(new ColopediaPanel(canvas, ColopediaPanel.PanelType.NATION_TYPES, null));
            }
        });
        DefaultTableCellRenderer dtcr = new DefaultTableCellRenderer();
        dtcr.setOpaque(false);
        HeaderRenderer renderer = new HeaderRenderer(nationButton, availabilityLabel, advantageButton, colorLabel, playerLabel);
        JTableHeader header = this.getTableHeader();
        header.addMouseListener(new HeaderListener(header, renderer));
        TableColumn nationColumn = this.getColumnModel().getColumn(0);
        nationColumn.setCellRenderer(new NationCellRenderer());
        nationColumn.setHeaderRenderer(renderer);
        TableColumn availableColumn = this.getColumnModel().getColumn(1);
        availableColumn.setCellRenderer(new AvailableCellRenderer());
        availableColumn.setCellEditor(new AvailableCellEditor());
        TableColumn advantagesColumn = this.getColumnModel().getColumn(2);
        if (nationOptions.getNationalAdvantages() == NationOptions.Advantages.SELECTABLE) {
            advantagesColumn.setCellEditor(new AdvantageCellEditor(canvas.getSpecification().getEuropeanNationTypes()));
        }
        advantagesColumn.setCellRenderer(new AdvantageCellRenderer(nationOptions.getNationalAdvantages()));
        advantagesColumn.setHeaderRenderer(renderer);
        TableColumn colorsColumn = this.getColumnModel().getColumn(3);
        colorsColumn.setCellRenderer(new ColorCellRenderer(true));
        TableColumn playerColumn = this.getColumnModel().getColumn(4);
        playerColumn.setCellEditor(new PlayerCellEditor());
        playerColumn.setCellRenderer(new PlayerCellRenderer());
    }

    public void update() {
        ((PlayersTableModel)this.getModel()).update();
    }

    static /* synthetic */ NationOptions.NationState[] access$100() {
        return allStates;
    }

    static /* synthetic */ NationOptions.NationState[] access$200() {
        return aiStates;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PlayersTableModel
    extends AbstractTableModel {
        private List<Nation> nations = new ArrayList<Nation>();
        private Map<Nation, Player> players = new HashMap<Nation, Player>();
        private Player thisPlayer;
        private final PreGameController preGameController;
        private NationOptions nationOptions;

        public PlayersTableModel(PreGameController pgc, NationOptions nationOptions, Player owningPlayer) {
            for (Nation nation : owningPlayer.getSpecification().getNations()) {
                NationOptions.NationState state = nationOptions.getNations().get(nation);
                if (state == null) continue;
                this.nations.add(nation);
                this.players.put(nation, null);
            }
            this.thisPlayer = owningPlayer;
            this.players.put(this.thisPlayer.getNation(), this.thisPlayer);
            this.preGameController = pgc;
            this.nationOptions = nationOptions;
        }

        public void update() {
            for (Nation nation : this.nations) {
                this.players.put(nation, null);
            }
            for (Player player : this.thisPlayer.getGame().getPlayers()) {
                this.players.put(player.getNation(), player);
            }
            this.fireTableDataChanged();
        }

        @Override
        public Class<?> getColumnClass(int column) {
            switch (column) {
                case 0: {
                    return Nation.class;
                }
                case 1: {
                    return NationOptions.NationState.class;
                }
                case 2: {
                    return NationType.class;
                }
                case 3: {
                    return Color.class;
                }
                case 4: {
                    return Player.class;
                }
            }
            return String.class;
        }

        @Override
        public int getColumnCount() {
            return columnNames.length;
        }

        @Override
        public String getColumnName(int column) {
            return columnNames[column];
        }

        @Override
        public int getRowCount() {
            return this.nations.size();
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (row < this.getRowCount() && column < this.getColumnCount() && row >= 0 && column >= 0) {
                Nation nation = this.nations.get(row);
                switch (column) {
                    case 0: {
                        return nation;
                    }
                    case 1: {
                        return this.nationOptions.getNationState(nation);
                    }
                    case 2: {
                        if (this.players.get(nation) == null) {
                            return nation.getType();
                        }
                        return this.players.get(nation).getNationType();
                    }
                    case 3: {
                        return ResourceManager.getColor(nation.getId() + ".color");
                    }
                    case 4: {
                        return this.players.get(nation);
                    }
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            if (row >= 0 && row < this.nations.size()) {
                Nation nation = this.nations.get(row);
                boolean ownRow = this.thisPlayer == this.players.get(nation) && !this.thisPlayer.isReady();
                switch (column) {
                    case 1: {
                        return !ownRow && this.thisPlayer.isAdmin();
                    }
                    case 2: 
                    case 3: {
                        return nation.getType() instanceof EuropeanNationType && ownRow;
                    }
                    case 4: {
                        return nation.getType() instanceof EuropeanNationType && this.players.get(nation) == null;
                    }
                }
            }
            return false;
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            if (row < this.getRowCount() && column < this.getColumnCount() && row >= 0 && column >= 0) {
                switch (column) {
                    case 2: {
                        this.preGameController.setNationType((NationType)value);
                        break;
                    }
                    case 1: {
                        this.preGameController.setAvailable(this.nations.get(row), (NationOptions.NationState)((Object)value));
                        this.update();
                        break;
                    }
                    case 4: {
                        Nation nation = this.nations.get(row);
                        if (this.nationOptions.getNationState(nation) != NationOptions.NationState.AVAILABLE) break;
                        this.preGameController.setNation(nation);
                        this.preGameController.setNationType(nation.getType());
                        this.update();
                    }
                }
                this.fireTableCellUpdated(row, column);
            }
        }
    }

    public final class PlayerCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private JButton button = new JButton(Messages.message("select"));

        public PlayerCellEditor() {
            this.button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PlayerCellEditor.this.fireEditingStopped();
                }
            });
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            return this.button;
        }

        public Object getCellEditorValue() {
            return true;
        }
    }

    class PlayerCellRenderer
    implements TableCellRenderer {
        JLabel label = new JLabel();
        JButton button = new JButton(Messages.message("select"));

        public PlayerCellRenderer() {
            this.label.setHorizontalAlignment(0);
            this.button.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10), this.button.getBorder()));
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Player player = (Player)value;
            if (player == null) {
                NationOptions.NationState nationState;
                NationType nationType = (NationType)table.getValueAt(row, 2);
                if (nationType instanceof EuropeanNationType && (nationState = (NationOptions.NationState)((Object)table.getValueAt(row, 1))) == NationOptions.NationState.AVAILABLE) {
                    return this.button;
                }
                Nation nation = (Nation)table.getValueAt(row, 0);
                this.label.setText(Messages.message(nation.getRulerNameKey()));
            } else {
                this.label.setText(player.getDisplayName());
            }
            return this.label;
        }
    }

    public final class AvailableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private JComboBox aiStateBox = new JComboBox<NationOptions.NationState>(PlayersTable.access$200());
        private JComboBox allStateBox = new JComboBox<NationOptions.NationState>(PlayersTable.access$100());
        private JComboBox activeBox;
        private ActionListener listener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AvailableCellEditor.this.stopCellEditing();
            }
        };

        public AvailableCellEditor() {
            this.aiStateBox.setRenderer(new NationStateRenderer());
            this.aiStateBox.addActionListener(this.listener);
            this.allStateBox.setRenderer(new NationStateRenderer());
            this.allStateBox.addActionListener(this.listener);
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            NationType nationType = ((Nation)PlayersTable.this.getValueAt(row, 0)).getType();
            this.activeBox = nationType instanceof EuropeanNationType ? this.allStateBox : this.aiStateBox;
            return this.activeBox;
        }

        public Object getCellEditorValue() {
            return this.activeBox.getSelectedItem();
        }
    }

    class NationStateRenderer
    extends JLabel
    implements ListCellRenderer {
        NationStateRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setText(Messages.message("nationState." + ((NationOptions.NationState)((Object)value)).toString()));
            return this;
        }
    }

    class AvailableCellRenderer
    implements TableCellRenderer {
        private JComboBox box = new JComboBox<NationOptions.NationState>(PlayersTable.access$100());

        public AvailableCellRenderer() {
            this.box.setRenderer(new NationStateRenderer());
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.box.setSelectedItem(value);
            return this.box;
        }
    }

    class NationCellRenderer
    extends JLabel
    implements TableCellRenderer {
        NationCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Nation nation = (Nation)value;
            this.setText(Messages.message(nation.getNameKey()));
            this.setIcon(new ImageIcon(PlayersTable.this.library.getCoatOfArmsImage(nation, 0.5)));
            return this;
        }
    }

    private class HeaderListener
    extends MouseAdapter {
        JTableHeader header;
        HeaderRenderer renderer;

        HeaderListener(JTableHeader header, HeaderRenderer renderer) {
            this.header = header;
            this.renderer = renderer;
        }

        public void mousePressed(MouseEvent e) {
            int col = this.header.columnAtPoint(e.getPoint());
            this.renderer.setPressedColumn(col);
            this.header.repaint();
        }

        public void mouseReleased(MouseEvent e) {
            this.renderer.setPressedColumn(-1);
            this.header.repaint();
        }
    }

    private class HeaderRenderer
    implements TableCellRenderer {
        private static final int NO_COLUMN = -1;
        private int pressedColumn = -1;
        private Component[] components;

        public HeaderRenderer(Component ... components) {
            this.components = components;
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (this.components[column] instanceof JButton) {
                boolean isPressed = column == this.pressedColumn;
                ((JButton)this.components[column]).getModel().setPressed(isPressed);
                ((JButton)this.components[column]).getModel().setArmed(isPressed);
            }
            return this.components[column];
        }

        public void setPressedColumn(int column) {
            this.pressedColumn = column;
        }
    }
}

