/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.BevelBorder;
import javax.swing.event.MouseInputListener;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.action.MiniMapZoomInAction;
import net.sf.freecol.client.gui.action.MiniMapZoomOutAction;
import net.sf.freecol.client.gui.panel.UnitButton;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.option.IntegerOption;
import net.sf.freecol.common.resources.ResourceManager;

public final class MiniMap
extends JPanel
implements MouseInputListener {
    private static final Logger logger = Logger.getLogger(MiniMap.class.getName());
    public static final int MAX_TILE_SIZE = 24;
    public static final int MIN_TILE_SIZE = 4;
    public static final int SCALE_STEP = 4;
    private static final int MAP_WIDTH = 220;
    private static final int MAP_HEIGHT = 128;
    private final Rectangle mapWindow;
    private FreeColClient freeColClient;
    private final JButton miniMapZoomOutButton;
    private final JButton miniMapZoomInButton;
    private Color backgroundColor;
    private int tileSize;
    private int firstColumn;
    private int firstRow;
    private int lastColumn;
    private int lastRow;
    private int adjustX = 0;
    private int adjustY = 0;

    public MiniMap(FreeColClient freeColClient) {
        this.freeColClient = freeColClient;
        this.backgroundColor = Color.BLACK;
        this.tileSize = 4 * (freeColClient.getClientOptions().getInteger("model.option.defaultZoomLevel") + 1);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setLayout(null);
        Image skin = ResourceManager.getImage("MiniMap.skin");
        if (skin == null) {
            try {
                BevelBorder border = new BevelBorder(0);
                this.setBorder(border);
            }
            catch (Exception e) {
                // empty catch block
            }
            this.setSize(220, 128);
            this.setOpaque(true);
            this.mapWindow = new Rectangle(220, 128);
        } else {
            this.setBorder(null);
            this.setSize(skin.getWidth(null), skin.getHeight(null));
            this.setOpaque(false);
            this.mapWindow = new Rectangle(38, 75, 220, 128);
        }
        this.miniMapZoomOutButton = new UnitButton(freeColClient.getActionManager(), "miniMapZoomOutAction");
        this.miniMapZoomInButton = new UnitButton(freeColClient.getActionManager(), "miniMapZoomInAction");
        this.miniMapZoomOutButton.setFocusable(false);
        this.miniMapZoomInButton.setFocusable(false);
        int bh = this.mapWindow.y + 128 - Math.max(this.miniMapZoomOutButton.getHeight(), this.miniMapZoomInButton.getHeight());
        int bw = this.mapWindow.x;
        if (this.getBorder() != null) {
            Insets insets = this.getBorder().getBorderInsets(this);
            bh -= insets.bottom;
            bw += insets.left;
        }
        this.miniMapZoomInButton.setLocation(4, 174);
        this.miniMapZoomOutButton.setLocation(264, 174);
        this.add(this.miniMapZoomInButton);
        this.add(this.miniMapZoomOutButton);
    }

    public void zoomIn() {
        this.tileSize = Math.min(this.tileSize + 4, 24);
        this.setZoomOption(this.tileSize);
        ((MiniMapZoomInAction)this.miniMapZoomInButton.getAction()).update();
        this.repaint();
    }

    public void zoomOut() {
        this.tileSize = Math.max(this.tileSize - 4, 4);
        this.setZoomOption(this.tileSize);
        ((MiniMapZoomOutAction)this.miniMapZoomOutButton.getAction()).update();
        this.repaint();
    }

    public void setTileSize(int size) {
        this.tileSize = Math.max(Math.min(size, 24), 4);
        this.setZoomOption(this.tileSize);
        ((MiniMapZoomOutAction)this.miniMapZoomOutButton.getAction()).update();
        this.repaint();
    }

    public boolean canZoomIn() {
        return this.freeColClient.getGame() != null && this.freeColClient.getGame().getMap() != null && this.tileSize < 24;
    }

    public boolean canZoomOut() {
        return this.freeColClient.getGame() != null && this.freeColClient.getGame().getMap() != null && this.tileSize > 4;
    }

    private void setZoomOption(int tileSize) {
        int zoom = tileSize / 4 - 1;
        ((IntegerOption)this.freeColClient.getClientOptions().getOption("model.option.defaultZoomLevel")).setValue(zoom);
    }

    public void paintComponent(Graphics graphics) {
        if (this.freeColClient.getGame() == null || this.freeColClient.getGame().getMap() == null) {
            return;
        }
        Image back = ResourceManager.getImage("MiniMap.back");
        Image skin = ResourceManager.getImage("MiniMap.skin");
        Color newBackground = ResourceManager.getColor("miniMapBackground.color");
        this.setBackgroundColor(newBackground);
        if (skin == null) {
            this.paintMap(graphics, this.getWidth(), this.getHeight());
        } else {
            graphics.drawImage(back, 0, 0, null);
            graphics.translate(this.mapWindow.x, this.mapWindow.y);
            this.paintMap(graphics, 220, 128);
            graphics.translate(-this.mapWindow.x, -this.mapWindow.y);
            graphics.drawImage(skin, 0, 0, null);
        }
    }

    private Color getMinimapColor(TileType type) {
        return ResourceManager.getColor(type.getId() + ".color");
    }

    public void paintMap(Graphics graphics, int width, int height) {
        Graphics2D g = (Graphics2D)graphics;
        AffineTransform originTransform = g.getTransform();
        Map map = this.freeColClient.getGame().getMap();
        ImageLibrary library = this.freeColClient.getImageLibrary();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setColor(ResourceManager.getColor("miniMapBackground.color"));
        g.fillRect(0, 0, width, height);
        if (this.freeColClient.getGUI() == null || this.freeColClient.getGUI().getFocus() == null) {
            return;
        }
        int xSize = width / this.tileSize;
        int ySize = height / this.tileSize * 4;
        this.firstColumn = this.freeColClient.getGUI().getFocus().getX() - xSize / 2;
        this.firstRow = this.freeColClient.getGUI().getFocus().getY() - ySize / 2;
        if (this.firstColumn < 0) {
            this.firstColumn = 0;
        } else if (this.firstColumn + xSize + 1 > map.getWidth()) {
            this.firstColumn = map.getWidth() - xSize - 1;
        }
        if (this.firstRow < 0) {
            this.firstRow = 0;
        } else if (this.firstRow + ySize + 1 > map.getHeight()) {
            this.firstRow = map.getHeight() - ySize - 1;
        }
        if (map.getWidth() <= xSize) {
            this.firstColumn = 0;
            this.adjustX = (xSize - map.getWidth()) * this.tileSize / 2;
            width = map.getWidth() * this.tileSize;
        } else {
            this.adjustX = 0;
        }
        if (map.getHeight() <= ySize) {
            this.firstRow = 0;
            this.adjustY = (ySize - map.getHeight()) * this.tileSize / 8;
            height = map.getHeight() * (this.tileSize / 4);
        } else {
            this.adjustY = 0;
        }
        this.lastRow = Math.min(this.firstRow + ySize, map.getHeight() - 1);
        this.lastColumn = Math.min(this.firstColumn + xSize, map.getWidth() - 1);
        int tileWidth = this.tileSize;
        int tileHeight = this.tileSize / 2;
        int halfWidth = this.tileSize / 2;
        int halfHeight = this.tileSize / 4;
        GeneralPath tilePath = new GeneralPath();
        tilePath.moveTo(halfWidth, 0.0f);
        tilePath.lineTo(tileWidth, halfHeight);
        tilePath.lineTo(halfWidth, tileHeight);
        tilePath.lineTo(0.0f, halfHeight);
        tilePath.closePath();
        GeneralPath settlementPath = new GeneralPath(tilePath);
        settlementPath.transform(AffineTransform.getScaleInstance(0.7, 0.7));
        settlementPath.transform(AffineTransform.getTranslateInstance(0.15 * (double)tileWidth, 0.15 * (double)tileHeight));
        GeneralPath unitPath = new GeneralPath(tilePath);
        unitPath.transform(AffineTransform.getScaleInstance(0.5, 0.5));
        unitPath.transform(AffineTransform.getTranslateInstance(0.25 * (double)tileWidth, 0.25 * (double)tileHeight));
        g.setStroke(new BasicStroke(1.0f));
        AffineTransform baseTransform = g.getTransform();
        AffineTransform rowTransform = null;
        for (int row = this.firstRow; row <= this.lastRow; ++row) {
            rowTransform = g.getTransform();
            if (row % 2 == 1) {
                g.translate(halfWidth, 0);
            }
            for (int column = this.firstColumn; column <= this.lastColumn; ++column) {
                Tile tile = map.getTile(column, row);
                if (tile.isExplored()) {
                    g.setColor(this.getMinimapColor(tile.getType()));
                    g.fill(tilePath);
                    if (tile.getSettlement() == null) {
                        Unit unit = tile.getFirstUnit();
                        if (unit != null) {
                            g.setColor(Color.BLACK);
                            g.draw(unitPath);
                            g.setColor(library.getColor(unit.getOwner()));
                            g.fill(unitPath);
                        }
                    } else {
                        g.setColor(Color.BLACK);
                        g.draw(settlementPath);
                        g.setColor(library.getColor(tile.getSettlement().getOwner()));
                        g.fill(settlementPath);
                    }
                }
                g.translate(tileWidth, 0);
            }
            g.setTransform(rowTransform);
            g.translate(0, halfHeight);
        }
        g.setTransform(baseTransform);
        if (this.getParent() != null) {
            TileType tileType = this.freeColClient.getGame().getSpecification().getTileTypeList().get(0);
            int miniRectX = (this.freeColClient.getGUI().getFocus().getX() - this.firstColumn) * this.tileSize;
            int miniRectY = (this.freeColClient.getGUI().getFocus().getY() - this.firstRow) * this.tileSize / 4;
            int miniRectWidth = (this.getParent().getWidth() / library.getTerrainImageWidth(tileType) + 1) * this.tileSize;
            int miniRectHeight = (this.getParent().getHeight() / library.getTerrainImageHeight(tileType) + 1) * this.tileSize / 2;
            if (miniRectX + miniRectWidth / 2 > width) {
                miniRectX = width - miniRectWidth / 2 - 1;
            } else if (miniRectX - miniRectWidth / 2 < 0) {
                miniRectX = miniRectWidth / 2;
            }
            if (miniRectY + miniRectHeight / 2 > height) {
                miniRectY = height - miniRectHeight / 2 - 1;
            } else if (miniRectY - miniRectHeight / 2 < 0) {
                miniRectY = miniRectHeight / 2;
            }
            g.setColor(ResourceManager.getColor("miniMapBorder.color"));
            int miniRectMaxX = Math.max(miniRectX - miniRectWidth / 2, 0);
            int miniRectMaxY = Math.max(miniRectY - miniRectHeight / 2, 0);
            int miniRectMinWidth = Math.min(miniRectWidth, width - 1);
            int miniRectMinHeight = Math.min(miniRectHeight, height - 1);
            if (miniRectMaxX + miniRectMinWidth > width - 1) {
                miniRectMaxX = width - miniRectMinWidth - 1;
            }
            if (miniRectMaxY + miniRectMinHeight > height - 1) {
                miniRectMaxY = height - miniRectMinHeight - 1;
            }
            g.drawRect(miniRectMaxX, miniRectMaxY, miniRectMinWidth, miniRectMinHeight);
            if (this.adjustX > 0 && this.adjustY > 0) {
                g.setColor(ResourceManager.getColor("miniMapBorder.color"));
                g.drawRect(0, 0, width - 1, height - 1);
            }
        }
        g.setTransform(originTransform);
    }

    private void focus(int x, int y) {
        int tileX = (x - this.adjustX) / this.tileSize + this.firstColumn;
        int tileY = (y - this.adjustY) / this.tileSize * 4 + this.firstRow;
        this.freeColClient.getGUI().setFocus(this.freeColClient.getGame().getMap().getTile(tileX, tileY));
    }

    private void focus(MouseEvent e) {
        if (e.getComponent().isEnabled() && this.mapWindow.contains(e.getPoint())) {
            this.focus(e.getX() - this.mapWindow.x, e.getY() - this.mapWindow.y);
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        this.focus(e);
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
        this.focus(e);
    }

    public void mouseMoved(MouseEvent e) {
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }
}

