/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.action.ActionManager;
import net.sf.freecol.client.gui.action.FreeColAction;
import net.sf.freecol.client.gui.panel.InfoPanel;
import net.sf.freecol.client.gui.panel.MapEditorTransformPanel;
import net.sf.freecol.client.gui.panel.MiniMap;
import net.sf.freecol.client.gui.panel.UnitButton;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovementType;
import net.sf.freecol.common.resources.ResourceManager;

public final class MapControls {
    private final FreeColClient freeColClient;
    private final InfoPanel infoPanel;
    private final MiniMap miniMap;
    private final UnitButton[] unitButton;
    private final JLabel compassRose;
    private static final int CONTROLS_LAYER = JLayeredPane.MODAL_LAYER;

    public MapControls(final FreeColClient freeColClient) {
        this.freeColClient = freeColClient;
        this.infoPanel = new InfoPanel(freeColClient);
        this.miniMap = new MiniMap(freeColClient);
        this.compassRose = new JLabel(ResourceManager.getImageIcon("compass.image"));
        ActionManager am = freeColClient.getActionManager();
        ArrayList<UnitButton> ubList = new ArrayList<UnitButton>();
        ubList.add(new UnitButton(am, "waitAction"));
        ubList.add(new UnitButton(am, "skipUnitAction"));
        ubList.add(new UnitButton(am, "sentryAction"));
        ubList.add(new UnitButton(am, "fortifyAction"));
        for (TileImprovementType type : freeColClient.getGame().getSpecification().getTileImprovementTypeList()) {
            FreeColAction action = am.getFreeColAction(type.getShortId() + "Action");
            if (type.isNatural() || action == null || !action.hasOrderButtons()) continue;
            ubList.add(new UnitButton(am, type.getShortId() + "Action"));
        }
        ubList.add(new UnitButton(am, "buildColonyAction"));
        ubList.add(new UnitButton(am, "disbandUnitAction"));
        this.unitButton = ubList.toArray(new UnitButton[0]);
        this.infoPanel.setFocusable(false);
        this.miniMap.setFocusable(false);
        this.compassRose.setFocusable(false);
        for (int i = 0; i < this.unitButton.length; ++i) {
            this.unitButton[i].setFocusable(false);
        }
        this.compassRose.setSize(this.compassRose.getPreferredSize());
        this.compassRose.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                int x = e.getX() - MapControls.this.compassRose.getWidth() / 2;
                int y = e.getY() - MapControls.this.compassRose.getHeight() / 2;
                double theta = Math.atan2(y, x) + 1.5707963267948966 + 0.39269908169872414;
                if (theta < 0.0) {
                    theta += Math.PI * 2;
                }
                Map.Direction direction = Map.Direction.values()[(int)Math.floor(theta / 0.7853981633974483)];
                freeColClient.getInGameController().moveActiveUnit(direction);
            }
        });
    }

    public void update(MapEditorTransformPanel.MapTransform mapTransform) {
        if (this.infoPanel != null) {
            this.infoPanel.update(mapTransform);
        }
    }

    public void addToComponent(Canvas component) {
        int i;
        if (this.freeColClient.getGame() == null || this.freeColClient.getGame().getMap() == null) {
            return;
        }
        this.infoPanel.setLocation(component.getWidth() - this.infoPanel.getWidth(), component.getHeight() - this.infoPanel.getHeight());
        this.miniMap.setLocation(0, component.getHeight() - this.miniMap.getHeight());
        this.compassRose.setLocation(component.getWidth() - this.compassRose.getWidth() - 20, 20);
        int WIDTH = this.unitButton[0].getWidth();
        int SPACE = 5;
        for (i = 0; i < this.unitButton.length; ++i) {
            int x = this.miniMap.getWidth() + 1 + (this.infoPanel.getX() - this.miniMap.getWidth() - this.unitButton.length * WIDTH - (this.unitButton.length - 1) * 5 - WIDTH) / 2 + i * (WIDTH + 5);
            int y = component.getHeight() - 40;
            this.unitButton[i].setLocation(x, y);
        }
        component.add((Component)this.infoPanel, CONTROLS_LAYER, false);
        component.add((Component)this.miniMap, CONTROLS_LAYER, false);
        if (this.freeColClient.getClientOptions().getBoolean("model.option.displayCompassRose")) {
            component.add((Component)this.compassRose, CONTROLS_LAYER, false);
        }
        if (!this.freeColClient.isMapEditor()) {
            for (i = 0; i < this.unitButton.length; ++i) {
                component.add((Component)this.unitButton[i], CONTROLS_LAYER, false);
                this.unitButton[i].refreshAction();
            }
        }
    }

    public int getInfoPanelWidth() {
        return this.infoPanel.getWidth();
    }

    public int getInfoPanelHeight() {
        return this.infoPanel.getHeight();
    }

    public void removeFromComponent(Canvas canvas) {
        canvas.remove(this.infoPanel, false);
        canvas.remove(this.miniMap, false);
        canvas.remove(this.compassRose, false);
        for (int i = 0; i < this.unitButton.length; ++i) {
            canvas.remove(this.unitButton[i], false);
        }
    }

    public boolean isShowing() {
        return this.infoPanel.getParent() != null;
    }

    public void zoomIn() {
        this.miniMap.zoomIn();
    }

    public void zoomOut() {
        this.miniMap.zoomOut();
    }

    public boolean canZoomIn() {
        return this.miniMap.canZoomIn();
    }

    public boolean canZoomOut() {
        return this.miniMap.canZoomOut();
    }

    public void changeBackgroundColor(Color newColor) {
        this.miniMap.setBackgroundColor(newColor);
    }

    public void update() {
        GUI gui = this.freeColClient.getGUI();
        int viewMode = gui.getViewMode().getView();
        switch (viewMode) {
            case 0: {
                this.infoPanel.update(gui.getActiveUnit());
                break;
            }
            case 1: {
                if (gui.getSelectedTile() == null) break;
                Tile selectedTile = gui.getSelectedTile();
                if (this.infoPanel.getTile() == selectedTile) break;
                this.infoPanel.update(selectedTile);
            }
        }
    }
}

