/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.logging.Logger;
import javax.swing.JMenuBar;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.action.MapControlsAction;
import net.sf.freecol.client.gui.menu.FreeColMenuBar;
import net.sf.freecol.client.gui.panel.OptionsDialog;
import net.sf.freecol.common.model.StringTemplate;

public final class ClientOptionsDialog
extends OptionsDialog {
    private static final Logger logger = Logger.getLogger(ClientOptionsDialog.class.getName());
    public static final String OPTION_GROUP_ID = "clientOptions";

    public ClientOptionsDialog(Canvas parent) {
        super(parent, true);
        this.getButtons().clear();
        this.initialize(this.getClientOptions(), this.getClientOptions().getName(), null);
    }

    public String getDefaultFileName() {
        return "options.xml";
    }

    public String getOptionGroupId() {
        return OPTION_GROUP_ID;
    }

    public void actionPerformed(ActionEvent event) {
        super.actionPerformed(event);
        String command = event.getActionCommand();
        if ("OK".equals(command)) {
            File file = new File(FreeCol.getOptionsDirectory(), this.getDefaultFileName());
            try {
                MapControlsAction mca;
                this.getGroup().save(file);
                this.getFreeColClient().getActionManager().update();
                JMenuBar menuBar = this.getFreeColClient().getFrame().getJMenuBar();
                if (menuBar != null) {
                    ((FreeColMenuBar)menuBar).reset();
                }
                if ((mca = (MapControlsAction)this.getFreeColClient().getActionManager().getFreeColAction("mapControlsAction")).getMapControls() != null) {
                    mca.getMapControls().update();
                }
            }
            catch (FileNotFoundException e) {
                logger.warning(e.toString());
                StringTemplate t = StringTemplate.template("failedToSave").addName("%name%", file.getPath());
                this.getCanvas().showInformationMessage(t);
            }
        }
    }
}

