/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.option;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.option.OptionUpdater;
import net.sf.freecol.common.option.SelectOption;

public final class SelectOptionUI
extends JComboBox
implements OptionUpdater,
PropertyChangeListener {
    private static final Logger logger = Logger.getLogger(SelectOptionUI.class.getName());
    private final SelectOption option;
    private int originalValue;
    private JLabel label;

    public SelectOptionUI(final SelectOption option, boolean editable) {
        this.option = option;
        this.originalValue = option.getValue();
        String name = Messages.getName(option);
        String description = Messages.getShortDescription(option);
        String text = description != null ? description : name;
        this.label = new JLabel(name, 2);
        this.label.setToolTipText(text);
        String[] strings = option.getItemValues().values().toArray(new String[0]);
        if (option.localizeLabels()) {
            for (int index = 0; index < strings.length; ++index) {
                strings[index] = Messages.message(strings[index]);
            }
        }
        this.setModel(new DefaultComboBoxModel<String>(strings));
        if (option.getValue() < strings.length) {
            this.setSelectedIndex(option.getValue());
        } else {
            logger.warning("SelectOption " + option.getId() + " has invalid value.");
        }
        this.setEnabled(editable);
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (option.isPreviewEnabled()) {
                    int value = SelectOptionUI.this.getSelectedIndex();
                    if (option.getValue() != value) {
                        option.setValue(value);
                    }
                }
            }
        });
        option.addPropertyChangeListener(this);
        this.setOpaque(false);
    }

    public JLabel getLabel() {
        return this.label;
    }

    public void setLabel(JLabel newLabel) {
        this.label = newLabel;
    }

    public void rollback() {
        this.option.setValue(this.originalValue);
    }

    public void unregister() {
        this.option.removePropertyChangeListener(this);
    }

    public void propertyChange(PropertyChangeEvent event) {
        int value;
        if (event.getPropertyName().equals("value") && (value = ((Integer)event.getNewValue()).intValue()) != this.getSelectedIndex()) {
            this.setSelectedIndex(value);
            this.originalValue = value;
        }
    }

    public void updateOption() {
        this.option.setValue(this.getSelectedIndex());
    }

    public void reset() {
        this.setSelectedIndex(this.option.getValue());
    }
}

