/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Timer;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.control.InGameController;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;

public final class CanvasMouseListener
implements ActionListener,
MouseListener {
    private static final Logger logger = Logger.getLogger(CanvasMouseListener.class.getName());
    private final Canvas canvas;
    private final GUI gui;
    private final int doubleClickDelay = 200;
    private Timer doubleClickTimer = new Timer(200, this);
    private int centerX;
    private int centerY;

    public CanvasMouseListener(Canvas canvas, GUI g) {
        this.canvas = canvas;
        this.gui = g;
    }

    public void mouseClicked(MouseEvent e) {
        try {
            if (e.getClickCount() > 1) {
                Tile tile = this.gui.convertToMapTile(e.getX(), e.getY());
                if (FreeCol.isInDebugMode()) {
                    if (tile.getSettlement() != null) {
                        this.canvas.debugForeignColony(tile.getSettlement());
                    }
                } else {
                    this.canvas.showColonyPanel(tile);
                }
            } else {
                this.canvas.requestFocus();
            }
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "Error in mouseClicked!", ex);
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        if (!e.getComponent().isEnabled()) {
            return;
        }
        try {
            if (e.getButton() == 3 || e.isPopupTrigger()) {
                if (this.gui.isGotoStarted()) {
                    this.gui.stopGoto();
                }
                this.canvas.showTilePopup(this.gui.convertToMapTile(e.getX(), e.getY()), e.getX(), e.getY());
            } else if (e.getButton() == 2) {
                Unit unit;
                Tile tile = this.gui.convertToMapTile(e.getX(), e.getY());
                if (tile != null && (unit = this.gui.getActiveUnit()) != null && unit.getTile() != tile) {
                    PathNode dragPath = unit.findPath(tile);
                    this.gui.startGoto();
                    this.gui.setGotoPath(dragPath);
                }
            } else if (e.getButton() == 1) {
                if (this.gui.isGotoStarted()) {
                    PathNode path = this.gui.getGotoPath();
                    if (path != null) {
                        this.gui.stopGoto();
                        Unit unit = this.gui.getActiveUnit();
                        this.canvas.getFreeColClient().getInGameController().setDestination(unit, path.getLastNode().getTile());
                        if (this.canvas.getFreeColClient().getGame().getCurrentPlayer() == this.canvas.getFreeColClient().getMyPlayer()) {
                            this.canvas.getFreeColClient().getInGameController().moveToDestination(unit);
                        }
                    }
                } else if (this.doubleClickTimer.isRunning()) {
                    this.doubleClickTimer.stop();
                } else {
                    this.centerX = e.getX();
                    this.centerY = e.getY();
                    this.doubleClickTimer.start();
                }
                this.canvas.requestFocus();
            }
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "Error in mousePressed!", ex);
        }
    }

    public void mouseReleased(MouseEvent e) {
        try {
            if (this.gui.getGotoPath() != null) {
                PathNode temp = this.gui.getGotoPath();
                this.gui.stopGoto();
                Unit unit = this.gui.getActiveUnit();
                InGameController ctlr = this.canvas.getFreeColClient().getInGameController();
                ctlr.setDestination(unit, temp.getLastNode().getTile());
                if (this.canvas.getFreeColClient().getGame().getCurrentPlayer() == this.canvas.getFreeColClient().getMyPlayer()) {
                    boolean canStayActive;
                    ctlr.moveToDestination(unit);
                    boolean bl = canStayActive = unit.getState() == Unit.UnitState.ACTIVE && unit.getDestination() == null && unit.getMovesLeft() > 0;
                    if (canStayActive) {
                        return;
                    }
                    ctlr.nextActiveUnit();
                }
            } else if (this.gui.isGotoStarted()) {
                this.gui.stopGoto();
            }
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "Error in mouseReleased!", ex);
        }
    }

    public void actionPerformed(ActionEvent timerEvent) {
        this.doubleClickTimer.stop();
        this.gui.setSelectedTile(this.gui.convertToMapTile(this.centerX, this.centerY), true);
    }
}

