/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.control;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.LoadingSavegameDialog;
import net.sf.freecol.client.networking.Client;
import net.sf.freecol.common.FreeColException;
import net.sf.freecol.common.ServerInfo;
import net.sf.freecol.common.io.FreeColSavegameFile;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.NationOptions;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.common.networking.NoRouteToServerException;
import net.sf.freecol.common.option.OptionGroup;
import net.sf.freecol.common.resources.ResourceManager;
import net.sf.freecol.common.util.XMLStream;
import net.sf.freecol.server.FreeColServer;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConnectController {
    private static final Logger logger = Logger.getLogger(ConnectController.class.getName());
    private final FreeColClient freeColClient;

    public ConnectController(FreeColClient freeColClient) {
        this.freeColClient = freeColClient;
    }

    public void startMultiplayerGame(Specification specification, boolean publicServer, String username, int port, NationOptions.Advantages advantages, OptionGroup level) {
        this.freeColClient.setMapEditor(false);
        if (this.freeColClient.isLoggedIn()) {
            this.logout(true);
        }
        if (this.freeColClient.getFreeColServer() != null && this.freeColClient.getFreeColServer().getServer().getPort() == port) {
            if (this.freeColClient.getCanvas().showConfirmDialog("stopServer.text", "stopServer.yes", "stopServer.no")) {
                this.freeColClient.getFreeColServer().getController().shutdown();
            } else {
                return;
            }
        }
        try {
            FreeColServer freeColServer = new FreeColServer(specification, publicServer, false, port, null, advantages);
            this.freeColClient.setFreeColServer(freeColServer);
        }
        catch (NoRouteToServerException e) {
            this.freeColClient.getCanvas().errorMessage("server.noRouteToServer");
            return;
        }
        catch (IOException e) {
            this.freeColClient.getCanvas().errorMessage("server.couldNotStart");
            return;
        }
        this.joinMultiplayerGame(username, "localhost", port);
    }

    public void startSingleplayerGame(Specification specification, String username, NationOptions.Advantages advantages) {
        this.freeColClient.setMapEditor(false);
        if (this.freeColClient.isLoggedIn()) {
            this.logout(true);
        }
        int port = FreeCol.getDefaultPort();
        if (this.freeColClient.getFreeColServer() != null && this.freeColClient.getFreeColServer().getServer().getPort() == port) {
            if (this.freeColClient.getCanvas().showConfirmDialog("stopServer.text", "stopServer.yes", "stopServer.no")) {
                this.freeColClient.getFreeColServer().getController().shutdown();
            } else {
                return;
            }
        }
        try {
            FreeColServer freeColServer = new FreeColServer(specification, false, true, port, null, advantages);
            if (this.freeColClient.getClientOptions().getBoolean("model.option.autosaveDelete")) {
                FreeColServer.removeAutosaves(Messages.message("clientOptions.savegames.autosave.fileprefix"));
            }
            this.freeColClient.setFreeColServer(freeColServer);
        }
        catch (NoRouteToServerException e) {
            logger.warning("Illegal state: An exception occured that can only appear in public multiplayer games.");
            return;
        }
        catch (IOException e) {
            this.freeColClient.getCanvas().errorMessage("server.couldNotStart");
            return;
        }
        this.freeColClient.setSingleplayer(true);
        if (this.login(username, "127.0.0.1", port)) {
            this.freeColClient.getPreGameController().setReady(true);
            this.freeColClient.getCanvas().showStartGamePanel(this.freeColClient.getGame(), this.freeColClient.getMyPlayer(), true);
        }
    }

    public void joinMultiplayerGame(String username, String host, int port) {
        List<String> vacantPlayers;
        Canvas canvas = this.freeColClient.getCanvas();
        this.freeColClient.setMapEditor(false);
        if (this.freeColClient.isLoggedIn()) {
            this.logout(true);
        }
        if ((vacantPlayers = this.getVacantPlayers(host, port)) != null) {
            String choice = canvas.showSimpleChoiceDialog(null, "connectController.choicePlayer", "cancel", vacantPlayers);
            if (choice != null) {
                username = choice;
            } else {
                return;
            }
        }
        this.freeColClient.setSingleplayer(false);
        if (this.login(username, host, port) && !this.freeColClient.isInGame()) {
            canvas.showStartGamePanel(this.freeColClient.getGame(), this.freeColClient.getMyPlayer(), false);
        }
    }

    public boolean login(String username, String host, int port) {
        block15: {
            Client client = this.freeColClient.getClient();
            Canvas canvas = this.freeColClient.getCanvas();
            this.freeColClient.setMapEditor(false);
            if (client != null) {
                client.disconnect();
            }
            try {
                client = new Client(host, port, this.freeColClient.getPreGameInputHandler());
            }
            catch (ConnectException e) {
                canvas.errorMessage("server.couldNotConnect");
                return false;
            }
            catch (IOException e) {
                canvas.errorMessage("server.couldNotConnect");
                return false;
            }
            this.freeColClient.setClient(client);
            Connection c = client.getConnection();
            XMLStreamReader in = null;
            try {
                XMLStreamWriter out = c.ask();
                out.writeStartElement("login");
                out.writeAttribute("username", username);
                out.writeAttribute("freeColVersion", FreeCol.getVersion());
                out.writeEndElement();
                in = c.getReply();
                if (in.getLocalName().equals("loginConfirmed")) {
                    String startGameStr = in.getAttributeValue(null, "startGame");
                    boolean startGame = startGameStr != null && Boolean.valueOf(startGameStr) != false;
                    boolean singleplayer = Boolean.valueOf(in.getAttributeValue(null, "singleplayer"));
                    boolean isCurrentPlayer = Boolean.valueOf(in.getAttributeValue(null, "isCurrentPlayer"));
                    String activeUnitId = in.getAttributeValue(null, "activeUnit");
                    in.nextTag();
                    Game game = new Game(in, username);
                    Player thisPlayer = game.getPlayerByName(username);
                    this.freeColClient.setGame(game);
                    this.freeColClient.setMyPlayer(thisPlayer);
                    this.freeColClient.getActionManager().addSpecificationActions(game.getSpecification());
                    c.endTransmission(in);
                    if (startGame) {
                        Tile entryTile = thisPlayer.getEntryLocation().getTile();
                        this.freeColClient.setSingleplayer(singleplayer);
                        this.freeColClient.getPreGameController().startGame();
                        if (isCurrentPlayer) {
                            this.freeColClient.getInGameController().setCurrentPlayer(thisPlayer);
                            if (activeUnitId != null) {
                                this.freeColClient.setActiveUnit(activeUnitId);
                            } else {
                                this.freeColClient.getGUI().setSelectedTile(entryTile, false);
                            }
                        } else {
                            this.freeColClient.getGUI().setSelectedTile(entryTile, false);
                        }
                        this.freeColClient.getGUI().setSelectedTile(thisPlayer.getEntryLocation().getTile(), false);
                    }
                    break block15;
                }
                if (in.getLocalName().equals("error")) {
                    canvas.errorMessage(in.getAttributeValue(null, "messageID"), in.getAttributeValue(null, "message"));
                    c.endTransmission(in);
                    return false;
                }
                logger.warning("Unkown message received: " + in.getLocalName());
                c.endTransmission(in);
                return false;
            }
            catch (Exception e) {
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                logger.warning(sw.toString());
                canvas.errorMessage(null, "Could not send XML to the server.");
                try {
                    c.endTransmission(in);
                }
                catch (IOException ie) {
                    logger.warning("Exception while trying to end transmission: " + ie.toString());
                }
            }
        }
        this.freeColClient.setLoggedIn(true);
        return true;
    }

    public void reconnect() {
        String username = this.freeColClient.getMyPlayer().getName();
        String host = this.freeColClient.getClient().getHost();
        int port = this.freeColClient.getClient().getPort();
        this.freeColClient.getCanvas().removeInGameComponents();
        this.logout(true);
        this.login(username, host, port);
        this.freeColClient.getInGameController().nextModelMessage();
    }

    public void loadGame() {
        File file = this.freeColClient.getCanvas().showLoadDialog(FreeCol.getSaveDirectory());
        if (file != null) {
            this.loadGame(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void loadGame(File file) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class ErrorJob
        implements Runnable {
            private final String message;
            final /* synthetic */ Canvas val$canvas;

            ErrorJob(String message) {
                this.val$canvas = canvas;
                this.message = message;
            }

            @Override
            public void run() {
                this.val$canvas.closeMenus();
                this.val$canvas.errorMessage(this.message);
            }
        }
        int port;
        String name;
        boolean singleplayer;
        final Canvas canvas = this.freeColClient.getCanvas();
        final File theFile = file;
        this.freeColClient.setMapEditor(false);
        XMLStream xs = null;
        try {
            FreeColSavegameFile fis = new FreeColSavegameFile(theFile);
            xs = new XMLStream(fis.getSavegameInputStream());
            XMLStreamReader in = xs.getXMLStreamReader();
            in.nextTag();
            boolean defaultSingleplayer = Boolean.valueOf(in.getAttributeValue(null, "singleplayer"));
            String publicServerStr = in.getAttributeValue(null, "publicServer");
            boolean defaultPublicServer = publicServerStr != null ? Boolean.valueOf(publicServerStr) : false;
            xs.close();
            try {
                this.freeColClient.getClientOptions().updateOptions(fis.getInputStream("client-options.xml"));
            }
            catch (FileNotFoundException e) {
                // empty catch block
            }
            int sgo = this.freeColClient.getClientOptions().getInteger("model.option.showSavegameSettings");
            if (sgo == 2 || !defaultSingleplayer && sgo == 1) {
                if (!canvas.showLoadingSavegameDialog(defaultPublicServer, defaultSingleplayer)) return;
                LoadingSavegameDialog lsd = canvas.getLoadingSavegameDialog();
                singleplayer = lsd.isSingleplayer();
                name = lsd.getName();
                port = lsd.getPort();
            } else {
                singleplayer = defaultSingleplayer;
                name = null;
                port = FreeCol.getDefaultPort();
            }
        }
        catch (FileNotFoundException e) {
            SwingUtilities.invokeLater(new ErrorJob("fileNotFound"));
            return;
        }
        catch (IOException e) {
            SwingUtilities.invokeLater(new ErrorJob("server.couldNotStart"));
            return;
        }
        catch (NullPointerException e) {
            SwingUtilities.invokeLater(new ErrorJob("couldNotLoadGame"));
            return;
        }
        catch (XMLStreamException e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            logger.warning(sw.toString());
            SwingUtilities.invokeLater(new ErrorJob("server.couldNotStart"));
            return;
        }
        finally {
            if (xs != null) {
                xs.close();
            }
        }
        if (this.freeColClient.getFreeColServer() != null && this.freeColClient.getFreeColServer().getServer().getPort() == port) {
            if (!this.freeColClient.getCanvas().showConfirmDialog("stopServer.text", "stopServer.yes", "stopServer.no")) return;
            this.freeColClient.getFreeColServer().getController().shutdown();
        }
        canvas.showStatusPanel(Messages.message("status.loadingGame"));
        Runnable loadGameJob = new Runnable(){

            public void run() {
                FreeColServer freeColServer = null;
                try {
                    final FreeColSavegameFile savegame = new FreeColSavegameFile(theFile);
                    freeColServer = new FreeColServer(savegame, port, name);
                    ConnectController.this.freeColClient.setFreeColServer(freeColServer);
                    final String username = freeColServer.getOwner();
                    ConnectController.this.freeColClient.setSingleplayer(singleplayer);
                    ConnectController.this.freeColClient.getInGameController().setGameConnected();
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            ResourceManager.setScenarioMapping(savegame.getResourceMapping());
                            ConnectController.this.login(username, "127.0.0.1", FreeCol.getDefaultPort());
                            canvas.closeStatusPanel();
                        }
                    });
                }
                catch (NoRouteToServerException e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            ConnectController.this.freeColClient.getCanvas().closeMainPanel();
                            ConnectController.this.freeColClient.getCanvas().showMainPanel();
                        }
                    });
                    SwingUtilities.invokeLater(new ErrorJob("server.noRouteToServer"));
                }
                catch (FileNotFoundException e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            ConnectController.this.freeColClient.getCanvas().closeMainPanel();
                            ConnectController.this.freeColClient.getCanvas().showMainPanel();
                        }
                    });
                    SwingUtilities.invokeLater(new ErrorJob("fileNotFound"));
                }
                catch (IOException e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            ConnectController.this.freeColClient.getCanvas().closeMainPanel();
                            ConnectController.this.freeColClient.getCanvas().showMainPanel();
                        }
                    });
                    SwingUtilities.invokeLater(new ErrorJob("server.couldNotStart"));
                }
                catch (FreeColException e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            ConnectController.this.freeColClient.getCanvas().closeMainPanel();
                            ConnectController.this.freeColClient.getCanvas().showMainPanel();
                        }
                    });
                    SwingUtilities.invokeLater(new ErrorJob(e.getMessage()));
                }
            }
        };
        this.freeColClient.worker.schedule(loadGameJob);
    }

    public void logout(boolean notifyServer) {
        if (notifyServer) {
            Element logoutMessage = DOMMessage.createNewRootElement("logout");
            logoutMessage.setAttribute("reason", "User has quit the client.");
            this.freeColClient.getClient().sendAndWait(logoutMessage);
        }
        try {
            this.freeColClient.getClient().getConnection().close();
        }
        catch (IOException e) {
            logger.warning("Could not close connection!");
        }
        ResourceManager.setScenarioMapping(null);
        ResourceManager.setCampaignMapping(null);
        if (!this.freeColClient.isHeadless()) {
            this.freeColClient.setInGame(false);
        }
        this.freeColClient.setGame(null);
        this.freeColClient.setMyPlayer(null);
        this.freeColClient.setClient(null);
        this.freeColClient.setLoggedIn(false);
    }

    public void quitGame(boolean bStopServer, boolean notifyServer) {
        FreeColServer server = this.freeColClient.getFreeColServer();
        if (bStopServer && server != null) {
            server.getController().shutdown();
            this.freeColClient.setFreeColServer(null);
            ResourceManager.setScenarioMapping(null);
            ResourceManager.setCampaignMapping(null);
            this.freeColClient.setInGame(false);
            this.freeColClient.setGame(null);
            this.freeColClient.setMyPlayer(null);
            this.freeColClient.setIsRetired(false);
            this.freeColClient.setClient(null);
            this.freeColClient.setLoggedIn(false);
        } else if (this.freeColClient.isLoggedIn()) {
            this.logout(notifyServer);
        }
    }

    public void quitGame(boolean bStopServer) {
        this.quitGame(bStopServer, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getVacantPlayers(String host, int port) {
        Connection mc;
        try {
            mc = new Connection(host, port, null, "FreeColClient:");
        }
        catch (IOException e) {
            logger.warning("Could not connect to server.");
            return null;
        }
        ArrayList<String> items = new ArrayList<String>();
        Element element = DOMMessage.createNewRootElement("getVacantPlayers");
        try {
            Element reply = mc.ask(element);
            if (reply == null) {
                logger.warning("The server did not return a list.");
                List<String> list = null;
                return list;
            }
            if (!reply.getTagName().equals("vacantPlayers")) {
                logger.warning("The reply has an unknown type: " + reply.getTagName());
                List<String> list = null;
                return list;
            }
            NodeList nl = reply.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                items.add(((Element)nl.item(i)).getAttribute("username"));
            }
        }
        catch (IOException e) {
            logger.warning("Could not send message to server.");
        }
        finally {
            try {
                mc.close();
            }
            catch (IOException e) {
                logger.warning("Could not close connection.");
            }
        }
        return items;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<ServerInfo> getServerList() {
        Connection mc;
        Canvas canvas = this.freeColClient.getCanvas();
        try {
            mc = new Connection("meta.freecol.org", 3540, null, "FreeColClient:");
        }
        catch (IOException e) {
            logger.warning("Could not connect to meta-server.");
            canvas.errorMessage("metaServer.couldNotConnect");
            return null;
        }
        try {
            Element gslElement = DOMMessage.createNewRootElement("getServerList");
            Element reply = mc.ask(gslElement);
            if (reply == null) {
                logger.warning("The meta-server did not return a list.");
                canvas.errorMessage("metaServer.communicationError");
                ArrayList<ServerInfo> arrayList = null;
                return arrayList;
            }
            ArrayList<ServerInfo> items = new ArrayList<ServerInfo>();
            NodeList nl = reply.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                items.add(new ServerInfo((Element)nl.item(i)));
            }
            ArrayList<ServerInfo> arrayList = items;
            return arrayList;
        }
        catch (IOException e) {
            logger.warning("Network error while communicating with the meta-server.");
            canvas.errorMessage("metaServer.communicationError");
            ArrayList<ServerInfo> arrayList = null;
            return arrayList;
        }
        finally {
            try {
                mc.close();
            }
            catch (IOException e) {
                logger.warning("Could not close connection to meta-server.");
                return null;
            }
        }
    }
}

