/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.model;

import java.util.Random;
import java.util.logging.Logger;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.BuildingType;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.ModelMessage;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.server.control.ChangeSet;
import net.sf.freecol.server.model.ServerModelObject;
import net.sf.freecol.server.model.ServerPlayer;
import net.sf.freecol.server.model.ServerUnit;

public class ServerBuilding
extends Building
implements ServerModelObject {
    private static final Logger logger = Logger.getLogger(ServerBuilding.class.getName());

    public ServerBuilding(Game game, String id) {
        super(game, id);
    }

    public ServerBuilding(Game game, Colony colony, BuildingType type) {
        super(game);
        this.colony = colony;
        this.buildingType = type;
    }

    public void csNewTurn(Random random, ChangeSet cs) {
        logger.finest("ServerBuilding.csNewTurn, for " + this.toString());
        BuildingType type = this.getType();
        ServerPlayer owner = (ServerPlayer)this.getColony().getOwner();
        if (type.hasAbility("model.ability.teach")) {
            this.teach(cs, owner);
        }
        if (type.hasAbility("model.ability.repairUnits")) {
            this.repairUnits(cs);
        }
    }

    private void teach(ChangeSet cs, ServerPlayer owner) {
        for (Unit teacher : this.getUnitList()) {
            boolean teacherDirty = false;
            boolean studentDirty = false;
            Unit student = teacher.getStudent();
            if (student != null && student.getTeacher() != teacher) {
                logger.warning("Bogus teacher/student assignment.");
                teacher.setStudent(null);
                student = null;
                teacherDirty = true;
            }
            if (student == null && this.csAssignStudent(teacher, cs)) {
                teacherDirty = true;
                studentDirty = true;
                student = teacher.getStudent();
            }
            if (student != null) {
                int training = teacher.getTurnsOfTraining() + 1;
                if (training < teacher.getNeededTurnsOfTraining()) {
                    teacher.setTurnsOfTraining(training);
                    if (!teacherDirty) {
                        cs.addPartial(ChangeSet.See.only(owner), teacher, "turnsOfTraining");
                    }
                } else {
                    StringTemplate oldName = student.getLabel();
                    UnitType teach = teacher.getType().getSkillTaught();
                    UnitType skill = Unit.getUnitTypeTeaching(teach, student.getType());
                    if (skill == null) {
                        logger.warning("Student " + student.getId() + " can not learn from " + teacher.getId());
                    } else {
                        student.setType(skill);
                        StringTemplate newName = student.getLabel();
                        cs.addMessage(ChangeSet.See.only(owner), new ModelMessage(ModelMessage.MessageType.UNIT_IMPROVED, "model.unit.unitEducated", this.colony, this).addStringTemplate("%oldName%", oldName).addStringTemplate("%unit%", newName).addName("%colony%", this.colony.getName()));
                    }
                    student.setTurnsOfTraining(0);
                    student.setMovesLeft(0);
                    cs.add(ChangeSet.See.only(owner), student);
                    studentDirty = false;
                    teacher.setTurnsOfTraining(0);
                    if (student.canBeStudent(teacher)) {
                        cs.addPartial(ChangeSet.See.only(owner), teacher, "turnsOfTraining");
                    } else {
                        student.setTeacher(null);
                        teacher.setStudent(null);
                        teacherDirty = true;
                        if (this.csAssignStudent(teacher, cs)) {
                            student = teacher.getStudent();
                            studentDirty = true;
                        }
                    }
                }
            }
            if (teacherDirty) {
                cs.add(ChangeSet.See.only(owner), teacher);
            }
            if (!studentDirty) continue;
            cs.add(ChangeSet.See.only(owner), student);
        }
    }

    private boolean csAssignStudent(Unit teacher, ChangeSet cs) {
        Colony colony = this.getColony();
        Unit student = colony.findStudent(teacher);
        if (student == null) {
            cs.addMessage(ChangeSet.See.only((ServerPlayer)colony.getOwner()), new ModelMessage(ModelMessage.MessageType.WARNING, "model.building.noStudent", colony, teacher).addStringTemplate("%teacher%", teacher.getLabel()).addName("%colony%", colony.getName()));
            return false;
        }
        teacher.setStudent(student);
        teacher.setWorkType(null);
        student.setTeacher(teacher);
        return true;
    }

    private void repairUnits(ChangeSet cs) {
        for (Unit unit : this.getTile().getUnitList()) {
            if (!unit.isUnderRepair() || !this.getType().hasAbility("model.ability.repairUnits", unit.getType())) continue;
            ((ServerUnit)unit).csRepairUnit(cs);
        }
    }

    public String getServerXMLElementTagName() {
        return "serverBuilding";
    }
}

