/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.control;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Logger;
import net.sf.freecol.common.FreeColException;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.NationOptions;
import net.sf.freecol.common.model.NationType;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.common.networking.NoRouteToServerException;
import net.sf.freecol.common.option.OptionGroup;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.control.InputHandler;
import net.sf.freecol.server.control.PreGameController;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

public final class PreGameInputHandler
extends InputHandler {
    private static Logger logger = Logger.getLogger(PreGameInputHandler.class.getName());
    private boolean launching = false;

    public PreGameInputHandler(FreeColServer freeColServer) {
        super(freeColServer);
        this.register("updateGameOptions", new InputHandler.NetworkRequestHandler(){

            public Element handle(Connection connection, Element element) {
                return PreGameInputHandler.this.updateGameOptions(connection, element);
            }
        });
        this.register("updateMapGeneratorOptions", new InputHandler.NetworkRequestHandler(){

            public Element handle(Connection connection, Element element) {
                return PreGameInputHandler.this.updateMapGeneratorOptions(connection, element);
            }
        });
        this.register("ready", new InputHandler.NetworkRequestHandler(){

            public Element handle(Connection connection, Element element) {
                return PreGameInputHandler.this.ready(connection, element);
            }
        });
        this.register("setNation", new InputHandler.NetworkRequestHandler(){

            public Element handle(Connection connection, Element element) {
                return PreGameInputHandler.this.nation(connection, element);
            }
        });
        this.register("setNationType", new InputHandler.NetworkRequestHandler(){

            public Element handle(Connection connection, Element element) {
                return PreGameInputHandler.this.nationType(connection, element);
            }
        });
        this.register("setAvailable", new InputHandler.NetworkRequestHandler(){

            public Element handle(Connection connection, Element element) {
                return PreGameInputHandler.this.available(connection, element);
            }
        });
        this.register("requestLaunch", new InputHandler.NetworkRequestHandler(){

            public Element handle(Connection connection, Element element) {
                Element reply = PreGameInputHandler.this.requestLaunch(connection, element);
                if (reply != null) {
                    PreGameInputHandler.this.launching = false;
                }
                return reply;
            }
        });
    }

    private Element updateGameOptions(Connection connection, Element element) {
        ServerPlayer player = this.getFreeColServer().getPlayer(connection);
        if (!player.isAdmin()) {
            throw new IllegalStateException();
        }
        OptionGroup gameOptions = this.getFreeColServer().getGame().getSpecification().getOptionGroup("gameOptions");
        gameOptions.readFromXMLElement((Element)element.getChildNodes().item(0));
        Element updateGameOptionsElement = Message.createNewRootElement("updateGameOptions");
        updateGameOptionsElement.appendChild(gameOptions.toXMLElement(updateGameOptionsElement.getOwnerDocument()));
        this.getFreeColServer().getServer().sendToAll(updateGameOptionsElement, connection);
        return null;
    }

    private Element updateMapGeneratorOptions(Connection connection, Element element) {
        ServerPlayer player = this.getFreeColServer().getPlayer(connection);
        if (!player.isAdmin()) {
            throw new IllegalStateException();
        }
        this.getFreeColServer().getMapGenerator().getMapGeneratorOptions().readFromXMLElement((Element)element.getChildNodes().item(0));
        Element umge = Message.createNewRootElement("updateMapGeneratorOptions");
        umge.appendChild(this.getFreeColServer().getMapGenerator().getMapGeneratorOptions().toXMLElement(umge.getOwnerDocument()));
        this.getFreeColServer().getServer().sendToAll(umge, connection);
        return null;
    }

    private Element ready(Connection connection, Element element) {
        ServerPlayer player = this.getFreeColServer().getPlayer(connection);
        if (player != null) {
            boolean ready = new Boolean(element.getAttribute("value"));
            player.setReady(ready);
            Element playerReady = Message.createNewRootElement("playerReady");
            playerReady.setAttribute("player", player.getId());
            playerReady.setAttribute("value", Boolean.toString(ready));
            this.getFreeColServer().getServer().sendToAll(playerReady, player.getConnection());
        } else {
            logger.warning("Ready from unknown connection.");
        }
        return null;
    }

    private Element nation(Connection connection, Element element) {
        ServerPlayer player = this.getFreeColServer().getPlayer(connection);
        if (player != null) {
            Nation nation = this.getGame().getSpecification().getNation(element.getAttribute("value"));
            if (this.getFreeColServer().getGame().getNationOptions().getNations().get(nation) == NationOptions.NationState.AVAILABLE) {
                player.setNation(nation);
                Element updateNation = Message.createNewRootElement("updateNation");
                updateNation.setAttribute("player", player.getId());
                updateNation.setAttribute("value", nation.getId());
                this.getFreeColServer().getServer().sendToAll(updateNation, player.getConnection());
            } else {
                logger.warning("Selected non-selectable nation.");
            }
        } else {
            logger.warning("Nation from unknown connection.");
        }
        return null;
    }

    private Element nationType(Connection connection, Element element) {
        ServerPlayer player = this.getFreeColServer().getPlayer(connection);
        if (player != null) {
            NationType nationType = this.getGame().getSpecification().getNationType(element.getAttribute("value"));
            NationType fixedNationType = this.getGame().getSpecification().getNation(player.getNationID()).getType();
            NationOptions.Advantages advantages = this.getFreeColServer().getGame().getNationOptions().getNationalAdvantages();
            if (advantages == NationOptions.Advantages.SELECTABLE || advantages == NationOptions.Advantages.FIXED && nationType.equals(fixedNationType)) {
                player.setNationType(nationType);
                Element updateNationType = Message.createNewRootElement("updateNationType");
                updateNationType.setAttribute("player", player.getId());
                updateNationType.setAttribute("value", nationType.getId());
                this.getFreeColServer().getServer().sendToAll(updateNationType, player.getConnection());
            } else {
                logger.warning("NationType is not selectable");
            }
        } else {
            logger.warning("NationType from unknown connection.");
        }
        return null;
    }

    private Element available(Connection connection, Element element) {
        ServerPlayer player = this.getFreeColServer().getPlayer(connection);
        if (player != null) {
            Nation nation = this.getGame().getSpecification().getNation(element.getAttribute("nation"));
            NationOptions.NationState state = Enum.valueOf(NationOptions.NationState.class, element.getAttribute("state"));
            this.getFreeColServer().getGame().getNationOptions().setNationState(nation, state);
            this.getFreeColServer().getServer().sendToAll(element, player.getConnection());
        } else {
            logger.warning("Available from unknown connection.");
        }
        return null;
    }

    private Element requestLaunch(Connection connection, Element element) {
        FreeColServer freeColServer = this.getFreeColServer();
        ServerPlayer launchingPlayer = freeColServer.getPlayer(connection);
        if (!launchingPlayer.isAdmin()) {
            Element reply = Message.createNewRootElement("error");
            reply.setAttribute("message", "Sorry, only the server admin can launch the game.");
            reply.setAttribute("messageID", "server.onlyAdminCanLaunch");
            return reply;
        }
        if (this.launching) {
            return null;
        }
        this.launching = true;
        Iterator<Player> playerIterator = freeColServer.getGame().getPlayerIterator();
        LinkedList<Nation> nations = new LinkedList<Nation>();
        while (playerIterator.hasNext()) {
            ServerPlayer player = (ServerPlayer)playerIterator.next();
            Nation nation = this.getGame().getSpecification().getNation(player.getNationID());
            for (int i = 0; i < nations.size(); ++i) {
                if (nations.get(i) != nation) continue;
                Element reply = Message.createNewRootElement("error");
                reply.setAttribute("message", "All players need to pick a unique nation before the game can start.");
                reply.setAttribute("messageID", "server.invalidPlayerNations");
                return reply;
            }
            nations.add(nation);
        }
        if (!freeColServer.getGame().isAllPlayersReadyToLaunch()) {
            Element reply = Message.createNewRootElement("error");
            reply.setAttribute("message", "Not all players are ready to begin the game!");
            reply.setAttribute("messageID", "server.notAllReady");
            return reply;
        }
        try {
            ((PreGameController)freeColServer.getController()).startGame();
        }
        catch (FreeColException e) {
            Element reply = Message.createNewRootElement("error");
            reply.setAttribute("message", "An error occurred while starting the game!");
            reply.setAttribute("messageID", "server.errorStartingGame");
            return reply;
        }
        return null;
    }

    protected Element logout(Connection connection, Element logoutElement) {
        ServerPlayer player = this.getFreeColServer().getPlayer(connection);
        logger.info("Logout by: " + connection + (player != null ? " (" + player.getName() + ") " : ""));
        Element logoutMessage = Message.createNewRootElement("logout");
        logoutMessage.setAttribute("reason", "User has logged out.");
        logoutMessage.setAttribute("player", player.getId());
        player.setConnected(false);
        this.getFreeColServer().getGame().removePlayer(player);
        this.getFreeColServer().getServer().sendToAll(logoutMessage, connection);
        try {
            this.getFreeColServer().updateMetaServer();
        }
        catch (NoRouteToServerException e) {
            // empty catch block
        }
        return null;
    }
}

