/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai.mission;

import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.mission.Mission;
import org.w3c.dom.Element;

public class IdleAtColonyMission
extends Mission {
    private static final Logger logger = Logger.getLogger(IdleAtColonyMission.class.getName());

    public IdleAtColonyMission(AIMain aiMain, AIUnit aiUnit) {
        super(aiMain, aiUnit);
    }

    public IdleAtColonyMission(AIMain aiMain, Element element) {
        super(aiMain);
        this.readFromXMLElement(element);
    }

    public IdleAtColonyMission(AIMain aiMain, XMLStreamReader in) throws XMLStreamException {
        super(aiMain);
        this.readFromXML(in);
    }

    public void doMission(Connection connection) {
        Tile thisTile = this.getUnit().getTile();
        Unit unit = this.getUnit();
        if (thisTile != null) {
            if (thisTile.getSettlement() != null) {
                logger.info("Unit " + unit.getId() + " idle at settlement: " + thisTile.getSettlement().getId());
                return;
            }
            PathNode pathToTarget = this.findNearestColony(unit);
            if (pathToTarget != null) {
                Map.Direction r = this.moveTowards(pathToTarget);
                if (r == null || !this.moveButDontAttack(r)) {
                    return;
                }
            } else {
                this.moveRandomly(connection);
            }
        }
    }

    public boolean isValid() {
        return super.isValid();
    }

    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        out.writeStartElement(IdleAtColonyMission.getXMLElementTagName());
        out.writeAttribute("unit", this.getUnit().getId());
        out.writeEndElement();
    }

    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        this.setAIUnit((AIUnit)this.getAIMain().getAIObject(in.getAttributeValue(null, "unit")));
        in.nextTag();
    }

    public static String getXMLElementTagName() {
        return "idleAtColonyMission";
    }
}

