/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai;

import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovementType;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.ValuedAIObject;
import net.sf.freecol.server.ai.mission.PioneeringMission;
import org.w3c.dom.Element;

public class TileImprovementPlan
extends ValuedAIObject {
    private static final Logger logger = Logger.getLogger(TileImprovementPlan.class.getName());
    private TileImprovementType type;
    private AIUnit pioneer = null;
    private Tile target;

    public TileImprovementPlan(AIMain aiMain, Tile target, TileImprovementType type, int value) {
        super(aiMain, TileImprovementPlan.getXMLElementTagName() + ":" + aiMain.getNextID());
        this.target = target;
        this.type = type;
        this.setValue(value);
    }

    public TileImprovementPlan(AIMain aiMain, Element element) {
        super(aiMain, element.getAttribute("ID"));
        this.readFromXMLElement(element);
    }

    public TileImprovementPlan(AIMain aiMain, XMLStreamReader in) throws XMLStreamException {
        super(aiMain, in.getAttributeValue(null, "ID"));
        this.readFromXML(in);
    }

    public TileImprovementPlan(AIMain aiMain, String id) throws XMLStreamException {
        super(aiMain, id);
    }

    public void dispose() {
        if (this.pioneer != null && this.pioneer.getMission() != null) {
            ((PioneeringMission)this.pioneer.getMission()).setTileImprovementPlan(null);
        }
        super.dispose();
    }

    public AIUnit getPioneer() {
        return this.pioneer;
    }

    public void setPioneer(AIUnit pioneer) {
        this.pioneer = pioneer;
    }

    public TileImprovementType getType() {
        return this.type;
    }

    public void setType(TileImprovementType type) {
        this.type = type;
    }

    public Tile getTarget() {
        return this.target;
    }

    public String toString() {
        return this.type.getNameKey() + " on " + this.target + " (" + this.getValue() + ")";
    }

    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        out.writeStartElement(TileImprovementPlan.getXMLElementTagName());
        out.writeAttribute("ID", this.getId());
        out.writeAttribute("type", this.type.getId());
        out.writeAttribute("value", Integer.toString(this.getValue()));
        if (this.pioneer != null) {
            out.writeAttribute("pioneer", this.pioneer.getId());
        }
        out.writeAttribute("target", this.target.getId());
        out.writeEndElement();
    }

    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        this.setId(in.getAttributeValue(null, "ID"));
        this.type = this.getAIMain().getGame().getSpecification().getTileImprovementType(in.getAttributeValue(null, "type"));
        this.setValue(Integer.parseInt(in.getAttributeValue(null, "value")));
        String pioneerStr = in.getAttributeValue(null, "pioneer");
        if (pioneerStr != null) {
            this.pioneer = (AIUnit)this.getAIMain().getAIObject(pioneerStr);
            if (this.pioneer == null) {
                this.pioneer = new AIUnit(this.getAIMain(), pioneerStr);
            }
        } else {
            this.pioneer = null;
        }
        this.target = (Tile)this.getAIMain().getFreeColGameObject(in.getAttributeValue(null, "target"));
        in.nextTag();
    }

    public static String getXMLElementTagName() {
        return "tileimprovementplan";
    }
}

