/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Logger;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Tension;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.NewAIPlayer;
import net.sf.freecol.server.ai.mission.IndianBringGiftMission;
import net.sf.freecol.server.ai.mission.IndianDemandMission;
import net.sf.freecol.server.ai.mission.UnitSeekAndDestroyMission;
import net.sf.freecol.server.ai.mission.UnitWanderHostileMission;

public class IndianAIPlayer
extends NewAIPlayer {
    private static final Logger logger = Logger.getLogger(IndianAIPlayer.class.getName());
    private static final int MAX_DISTANCE_TO_BRING_GIFT = 5;
    private static final int MAX_NUMBER_OF_GIFTS_BEING_DELIVERED = 1;
    private static final int MAX_DISTANCE_TO_MAKE_DEMANDS = 5;
    private static final int MAX_NUMBER_OF_DEMANDS = 1;

    public void startWorking() {
        logger.fine("Entering AI code for: " + this.getPlayer() + ", year " + this.getGame().getTurn());
        this.sessionRegister.clear();
        this.clearAIUnits();
        this.determineStances();
        this.abortInvalidAndOneTimeMissions();
        this.secureSettlements();
        this.giveNormalMissions();
        this.bringGifts();
        this.demandTribute();
        this.doMissions();
        this.abortInvalidMissions();
        this.giveNormalMissions();
        this.doMissions();
        this.abortInvalidMissions();
        this.clearAIUnits();
    }

    private void giveNormalMissions() {
        logger.finest("Entering method giveNormalMissions");
        Iterator<AIUnit> aiUnitsIterator = this.getAIUnitIterator();
        while (aiUnitsIterator.hasNext()) {
            AIUnit aiUnit = aiUnitsIterator.next();
            if (aiUnit.hasMission()) continue;
            Unit unit = aiUnit.getUnit();
            if (unit.isUninitialized()) {
                logger.warning("Trying to assign a mission to an uninitialized object: " + unit.getId());
                continue;
            }
            if (aiUnit.hasMission()) continue;
            aiUnit.setMission(new UnitWanderHostileMission(this.getAIMain(), aiUnit));
        }
    }

    private void secureSettlements() {
        logger.finest("Entering method secureSettlements");
        for (IndianSettlement is : this.getPlayer().getIndianSettlements()) {
            this.secureIndianSettlement(is);
        }
    }

    public void secureIndianSettlement(IndianSettlement is) {
        if (is.getOwner().isAtWar() && is.getUnitCount() > 2) {
            int defenders = is.getTile().getUnitCount();
            int threat = 0;
            int worstThreat = 0;
            FreeColGameObject bestTarget = null;
            for (Tile t : is.getTile().getSurroundingTiles(2)) {
                if (!t.isLand() || t.getFirstUnit() == null) continue;
                Player enemy = t.getFirstUnit().getOwner();
                if (enemy == this.getPlayer()) {
                    ++defenders;
                    continue;
                }
                int value = this.getPlayer().getTension(enemy).getValue();
                if (value >= 300) {
                    threat += 2;
                    if (t.getUnitCount() * 2 <= worstThreat) continue;
                    bestTarget = t.getSettlement() != null ? t.getSettlement() : t.getFirstUnit();
                    worstThreat = t.getUnitCount() * 2;
                    continue;
                }
                if (value < 100) continue;
                ++threat;
                if (t.getUnitCount() <= worstThreat) continue;
                bestTarget = t.getSettlement() != null ? t.getSettlement() : t.getFirstUnit();
                worstThreat = t.getUnitCount();
            }
            if (threat > defenders) {
                Unit newDefender = is.getFirstUnit();
                newDefender.setState(Unit.UnitState.ACTIVE);
                newDefender.setLocation(is.getTile());
                AIUnit newDefenderAI = this.getAIUnit(newDefender);
                if (bestTarget != null) {
                    newDefenderAI.setMission(new UnitSeekAndDestroyMission(this.getAIMain(), newDefenderAI, (Location)((Object)bestTarget)));
                } else {
                    newDefenderAI.setMission(new UnitWanderHostileMission(this.getAIMain(), newDefenderAI));
                }
            }
        }
    }

    private void bringGifts() {
        logger.finest("Entering method bringGifts");
        if (!this.getPlayer().isIndian()) {
            return;
        }
        for (IndianSettlement indianSettlement : this.getPlayer().getIndianSettlements()) {
            PathNode pn;
            if (this.getAIRandom().nextInt(10) != 1) continue;
            int alreadyAssignedUnits = 0;
            Iterator<Unit> ownedUnits = indianSettlement.getOwnedUnitsIterator();
            while (ownedUnits.hasNext()) {
                if (!(this.getAIUnit(ownedUnits.next()).getMission() instanceof IndianBringGiftMission)) continue;
                ++alreadyAssignedUnits;
            }
            if (alreadyAssignedUnits > 1) continue;
            ArrayList<Colony> nearbyColonies = new ArrayList<Colony>();
            for (Tile t : indianSettlement.getTile().getSurroundingTiles(5)) {
                if (t.getColony() == null || !IndianBringGiftMission.isValidMission(this.getPlayer(), t.getColony().getOwner())) continue;
                nearbyColonies.add(t.getColony());
            }
            if (nearbyColonies.size() <= 0) continue;
            Colony target = (Colony)nearbyColonies.get(this.getAIRandom().nextInt(nearbyColonies.size()));
            Iterator<Unit> it2 = indianSettlement.getOwnedUnitsIterator();
            AIUnit chosenOne = null;
            while (it2.hasNext()) {
                chosenOne = this.getAIUnit(it2.next());
                if (!(chosenOne.getUnit().getLocation() instanceof Tile)) {
                    chosenOne = null;
                    continue;
                }
                if (chosenOne.getMission() != null && !(chosenOne.getMission() instanceof UnitWanderHostileMission)) continue;
            }
            if (chosenOne == null || (pn = chosenOne.getUnit().findPath(indianSettlement.getTile(), target.getTile())) == null || pn.getTotalTurns() > 5) continue;
            chosenOne.setMission(new IndianBringGiftMission(this.getAIMain(), chosenOne, target));
        }
    }

    private void demandTribute() {
        logger.finest("Entering method demandTribute");
        if (!this.getPlayer().isIndian()) {
            return;
        }
        for (IndianSettlement indianSettlement : this.getPlayer().getIndianSettlements()) {
            PathNode pn;
            if (this.getAIRandom().nextInt(10) != 1) continue;
            int alreadyAssignedUnits = 0;
            Iterator<Unit> ownedUnits = indianSettlement.getOwnedUnitsIterator();
            while (ownedUnits.hasNext()) {
                if (!(this.getAIUnit(ownedUnits.next()).getMission() instanceof IndianDemandMission)) continue;
                ++alreadyAssignedUnits;
            }
            if (alreadyAssignedUnits > 1) continue;
            ArrayList<Colony> nearbyColonies = new ArrayList<Colony>();
            for (Tile t : indianSettlement.getTile().getSurroundingTiles(5)) {
                if (t.getColony() == null) continue;
                nearbyColonies.add(t.getColony());
            }
            if (nearbyColonies.size() <= 0) continue;
            int targetTension = Integer.MIN_VALUE;
            Settlement target = null;
            for (int i = 0; i < nearbyColonies.size(); ++i) {
                Colony t = (Colony)nearbyColonies.get(i);
                Player to = t.getOwner();
                if (!this.getPlayer().hasContacted(to) || !indianSettlement.hasContactedSettlement(to)) continue;
                int tension = 1 + this.getPlayer().getTension(to).getValue() + indianSettlement.getAlarm(to).getValue();
                tension = this.getAIRandom().nextInt(tension);
                if (tension <= targetTension) continue;
                targetTension = tension;
                target = t;
            }
            Iterator<Unit> it2 = indianSettlement.getOwnedUnitsIterator();
            AIUnit chosenOne = null;
            while (it2.hasNext()) {
                chosenOne = this.getAIUnit(it2.next());
                if (!(chosenOne.getUnit().getLocation() instanceof Tile)) {
                    chosenOne = null;
                    continue;
                }
                if (chosenOne.getMission() != null && !(chosenOne.getMission() instanceof UnitWanderHostileMission)) continue;
            }
            if (chosenOne == null || target == null || (pn = chosenOne.getUnit().findPath(indianSettlement.getTile(), target.getTile())) == null || pn.getTotalTurns() > 5) continue;
            Player tp = target.getOwner();
            int tension = 1 + this.getPlayer().getTension(tp).getValue() + indianSettlement.getAlarm(tp).getValue();
            if (this.getAIRandom().nextInt(tension) <= Tension.Level.HAPPY.getLimit()) continue;
            chosenOne.setMission(new IndianDemandMission(this.getAIMain(), chosenOne, (Colony)target));
        }
    }

    public int sellProposition(Unit unit, Settlement settlement, Goods goods, int gold) {
        int price;
        logger.finest("Entering method sellProposition");
        String goldKey = "tradeGold#" + goods.getType().getId() + "#" + goods.getAmount() + "#" + unit.getId();
        String hagglingKey = "tradeHaggling#" + unit.getId();
        if (this.sessionRegister.containsKey(goldKey)) {
            price = (Integer)this.sessionRegister.get(goldKey);
            if (price <= 0) {
                return price;
            }
        } else {
            price = ((IndianSettlement)settlement).getPriceToBuy(goods) - this.getPlayer().getTension(unit.getOwner()).getValue();
            if (price <= 0) {
                return 0;
            }
            this.sessionRegister.put(goldKey, new Integer(price));
        }
        if (gold < 0 || price == gold) {
            return price;
        }
        if (gold > price * 11 / 10) {
            logger.warning("Cheating attempt: haggling with a request too high");
            this.sessionRegister.put(goldKey, new Integer(-1));
            return -1;
        }
        int haggling = 1;
        if (this.sessionRegister.containsKey(hagglingKey)) {
            haggling = (Integer)this.sessionRegister.get(hagglingKey);
        }
        if (this.getAIRandom().nextInt(3 + haggling) <= 3) {
            this.sessionRegister.put(goldKey, new Integer(gold));
            this.sessionRegister.put(hagglingKey, new Integer(haggling + 1));
            return gold;
        }
        this.sessionRegister.put(goldKey, new Integer(-1));
        return -1;
    }
}

