/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.option;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.option.IntegerOption;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectOption
extends IntegerOption {
    private static Logger logger = Logger.getLogger(SelectOption.class.getName());
    protected boolean localizedLabels = false;
    private Map<Integer, String> itemValues = new LinkedHashMap<Integer, String>();

    public SelectOption(XMLStreamReader in) throws XMLStreamException {
        super("NO_ID");
        this.readFromXML(in);
    }

    public Map<Integer, String> getItemValues() {
        return this.itemValues;
    }

    public boolean localizeLabels() {
        return this.localizedLabels;
    }

    @Override
    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        this.toXMLImpl(out, SelectOption.getXMLElementTagName());
    }

    protected void toXMLImpl(XMLStreamWriter out, String tag) throws XMLStreamException {
        out.writeStartElement(tag);
        out.writeAttribute("id", this.getId());
        out.writeAttribute("value", this.getStringValue());
        out.writeAttribute("localizedLabels", Boolean.toString(this.localizedLabels));
        for (Map.Entry<Integer, String> entry : this.itemValues.entrySet()) {
            out.writeStartElement(this.getXMLItemElementTagName());
            out.writeAttribute("value", Integer.toString(entry.getKey()));
            out.writeAttribute("label", entry.getValue());
            out.writeEndElement();
        }
        out.writeEndElement();
    }

    @Override
    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        String id = in.getAttributeValue(null, "id");
        String defaultValue = in.getAttributeValue(null, "defaultValue");
        this.localizedLabels = SelectOption.getAttribute(in, "localizedLabels", true);
        String value = in.getAttributeValue(null, "value");
        if (id == null && this.getId().equals("NO_ID")) {
            throw new XMLStreamException("invalid <" + SelectOption.getXMLElementTagName() + "> tag : no id attribute found.");
        }
        if (defaultValue == null && value == null) {
            throw new XMLStreamException("invalid <" + SelectOption.getXMLElementTagName() + "> tag : no value nor default value found.");
        }
        if (this.getId() == "NO_ID") {
            this.setId(id);
        }
        if (value != null) {
            this.setValue(Integer.parseInt(value));
        } else {
            this.setValue(Integer.parseInt(defaultValue));
        }
        while (in.nextTag() != 2) {
            if (in.getLocalName().equals(this.getXMLItemElementTagName())) {
                String label = in.getAttributeValue(null, "label");
                String itemValue = in.getAttributeValue(null, "value");
                this.itemValues.put(Integer.parseInt(itemValue), label);
                in.nextTag();
                continue;
            }
            throw new XMLStreamException("Unknown child \"" + in.getLocalName() + "\" in a \"" + SelectOption.getXMLElementTagName() + "\". ");
        }
    }

    public static String getXMLElementTagName() {
        return "selectOption";
    }

    public String getXMLItemElementTagName() {
        return "selectValue";
    }
}

