/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.option;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.common.option.AbstractOption;
import net.sf.freecol.common.option.AudioMixerOption;
import net.sf.freecol.common.option.BooleanOption;
import net.sf.freecol.common.option.FileOption;
import net.sf.freecol.common.option.IntegerOption;
import net.sf.freecol.common.option.LanguageOption;
import net.sf.freecol.common.option.Option;
import net.sf.freecol.common.option.PercentageOption;
import net.sf.freecol.common.option.RangeOption;
import net.sf.freecol.common.option.SelectOption;
import net.sf.freecol.common.option.StringOption;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptionGroup
extends AbstractOption<OptionGroup> {
    private static Logger logger = Logger.getLogger(OptionGroup.class.getName());
    private List<Option> options = new ArrayList<Option>();
    private Map<String, Option> optionMap = new HashMap<String, Option>();

    public OptionGroup(String id) {
        super(id);
    }

    public OptionGroup(XMLStreamReader in) throws XMLStreamException {
        this("NO_ID");
        this.readFromXML(in);
    }

    public void add(Option option) {
        String id = option.getId();
        if (this.optionMap.containsKey(id)) {
            for (int index = 0; index < this.options.size(); ++index) {
                if (!id.equals(this.options.get(index).getId())) continue;
                this.options.remove(index);
                this.options.add(index, option);
                break;
            }
        } else {
            this.options.add(option);
        }
        this.optionMap.put(id, option);
        if (option instanceof OptionGroup) {
            this.addOptionGroup((OptionGroup)option);
        }
    }

    private void addOptionGroup(OptionGroup group) {
        for (Option option : group.getOptions()) {
            this.optionMap.put(option.getId(), option);
            if (!(option instanceof OptionGroup)) continue;
            this.addOptionGroup((OptionGroup)option);
        }
    }

    public List<Option> getOptions() {
        return this.options;
    }

    public Option getOption(String id) {
        return this.optionMap.get(id);
    }

    public int getInteger(String id) {
        try {
            return ((IntegerOption)this.getOption(id)).getValue();
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("No integer value associated with the specified option.");
        }
    }

    public void setInteger(String id, int value) {
        try {
            ((IntegerOption)this.getOption(id)).setValue(value);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("No integer value associated with the specified option.");
        }
    }

    public boolean getBoolean(String id) {
        try {
            return ((BooleanOption)this.getOption(id)).getValue();
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("No boolean value associated with the specified option.");
        }
    }

    public void setBoolean(String id, boolean value) {
        try {
            ((BooleanOption)this.getOption(id)).setValue(value);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("No boolean value associated with the specified option.");
        }
    }

    public String getString(String id) {
        try {
            return ((StringOption)this.getOption(id)).getValue();
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("No String value associated with the specified option.");
        }
    }

    public void setString(String id, String value) {
        try {
            ((StringOption)this.getOption(id)).setValue(value);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("No String value associated with the specified option.");
        }
    }

    public void removeAll() {
        this.options.clear();
        this.optionMap.clear();
    }

    public Iterator<Option> iterator() {
        return this.options.iterator();
    }

    @Override
    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        out.writeStartElement(OptionGroup.getXMLElementTagName());
        out.writeAttribute("id", this.getId());
        Iterator<Option> oi = this.options.iterator();
        while (oi.hasNext()) {
            oi.next().toXML(out);
        }
        out.writeEndElement();
    }

    @Override
    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        String id = in.getAttributeValue(null, "id");
        if (id != null) {
            this.setId(id);
        }
        while (in.nextTag() != 2) {
            String optionType = in.getLocalName();
            String optionId = in.getAttributeValue(null, "id");
            AbstractOption option = (AbstractOption)this.getOption(optionId);
            if (option == null) {
                if (OptionGroup.getXMLElementTagName().equals(optionType)) {
                    this.addNewOption(new OptionGroup(in));
                    continue;
                }
                if (IntegerOption.getXMLElementTagName().equals(optionType) || "integer-option".equals(optionType)) {
                    this.addNewOption(new IntegerOption(in));
                    continue;
                }
                if (BooleanOption.getXMLElementTagName().equals(optionType) || "boolean-option".equals(optionType)) {
                    this.addNewOption(new BooleanOption(in));
                    continue;
                }
                if (RangeOption.getXMLElementTagName().equals(optionType) || "range-option".equals(optionType)) {
                    this.addNewOption(new RangeOption(in));
                    continue;
                }
                if (SelectOption.getXMLElementTagName().equals(optionType) || "select-option".equals(optionType)) {
                    this.addNewOption(new SelectOption(in));
                    continue;
                }
                if (LanguageOption.getXMLElementTagName().equals(optionType) || "language-option".equals(optionType)) {
                    this.addNewOption(new LanguageOption(in));
                    continue;
                }
                if (FileOption.getXMLElementTagName().equals(optionType) || "file-option".equals(optionType)) {
                    this.addNewOption(new FileOption(in));
                    continue;
                }
                if (PercentageOption.getXMLElementTagName().equals(optionType)) {
                    this.addNewOption(new PercentageOption(in));
                    continue;
                }
                if (AudioMixerOption.getXMLElementTagName().equals(optionType)) {
                    this.addNewOption(new AudioMixerOption(in));
                    continue;
                }
                if (StringOption.getXMLElementTagName().equals(optionType)) {
                    this.addNewOption(new StringOption(in));
                    continue;
                }
                logger.finest("Parsing of " + optionType + " is not implemented yet");
                in.nextTag();
                continue;
            }
            option.readFromXML(in);
        }
    }

    private void addNewOption(AbstractOption option) {
        this.add(option);
        option.setGroup(this.getId());
    }

    public static String getXMLElementTagName() {
        return "optionGroup";
    }

    public String getName() {
        return Messages.message(this.getId() + ".name");
    }

    public String getShortDescription() {
        return Messages.message(this.getId() + ".shortDescription");
    }

    @Override
    public OptionGroup getValue() {
        return this;
    }

    @Override
    public void setValue(OptionGroup value) {
        for (Option other : value.getOptions()) {
            if (!(other instanceof AbstractOption)) continue;
            AbstractOption mine = (AbstractOption)this.getOption(other.getId());
            mine.setValue(((AbstractOption)other).getValue());
        }
    }
}

