/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.option;

import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.option.AbstractOption;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegerOption
extends AbstractOption<Integer> {
    private static Logger logger = Logger.getLogger(IntegerOption.class.getName());
    private int value;
    private int minimumValue = Integer.MIN_VALUE;
    private int maximumValue = Integer.MAX_VALUE;

    public IntegerOption(String id) {
        super(id);
    }

    public IntegerOption(XMLStreamReader in) throws XMLStreamException {
        super("NO_ID");
        this.readFromXML(in);
    }

    public int getMinimumValue() {
        return this.minimumValue;
    }

    public void setMinimumValue(int minimumValue) {
        this.minimumValue = minimumValue;
    }

    public int getMaximumValue() {
        return this.maximumValue;
    }

    public void setMaximumValue(int maximumValue) {
        this.maximumValue = maximumValue;
    }

    @Override
    public Integer getValue() {
        return this.value;
    }

    @Override
    public void setValue(Integer value) {
        int oldValue = this.value;
        this.value = value;
        if (value != oldValue && this.isDefined) {
            this.firePropertyChange("value", (Object)oldValue, value);
        }
        this.isDefined = true;
    }

    protected String getStringValue() {
        return Integer.toString(this.value);
    }

    @Override
    protected void setValue(String value) {
        this.setValue(Integer.parseInt(value));
    }

    @Override
    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        out.writeStartElement(IntegerOption.getXMLElementTagName());
        out.writeAttribute("id", this.getId());
        out.writeAttribute("value", Integer.toString(this.value));
        out.writeEndElement();
    }

    @Override
    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        String id = in.getAttributeValue(null, "id");
        String defaultValue = in.getAttributeValue(null, "defaultValue");
        String value = in.getAttributeValue(null, "value");
        if (id == null && this.getId().equals("NO_ID")) {
            throw new XMLStreamException("invalid <" + IntegerOption.getXMLElementTagName() + "> tag : no id attribute found.");
        }
        if (defaultValue == null && value == null) {
            throw new XMLStreamException("invalid <" + IntegerOption.getXMLElementTagName() + "> tag : no value nor default value found.");
        }
        if (this.getId() == "NO_ID") {
            this.setId(id);
        }
        if (value != null) {
            this.setValue(Integer.parseInt(value));
        } else {
            this.setValue(Integer.parseInt(defaultValue));
        }
        this.minimumValue = this.getAttribute(in, "minimumValue", Integer.MIN_VALUE);
        this.maximumValue = this.getAttribute(in, "maximumValue", Integer.MAX_VALUE);
        in.nextTag();
    }

    public static String getXMLElementTagName() {
        return "integerOption";
    }
}

