/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

public class SetDestinationMessage
extends Message {
    String unitId;
    String destinationId;

    public SetDestinationMessage(Unit unit, Location destination) {
        this.unitId = unit.getId();
        this.destinationId = destination == null ? null : destination.getId();
    }

    public SetDestinationMessage(Game game, Element element) {
        this.unitId = element.getAttribute("unit");
        this.destinationId = element.getAttribute("destination");
    }

    public Element handle(FreeColServer server, Connection connection) {
        Location destination;
        Unit unit;
        ServerPlayer serverPlayer = server.getPlayer(connection);
        Game game = serverPlayer.getGame();
        try {
            unit = server.getUnitSafely(this.unitId, serverPlayer);
        }
        catch (Exception e) {
            return Message.clientError(e.getMessage());
        }
        if (this.destinationId == null || this.destinationId.length() == 0) {
            destination = null;
        } else {
            if (!(game.getFreeColGameObject(this.destinationId) instanceof Location)) {
                return Message.clientError("Not a location ID: " + this.destinationId);
            }
            destination = (Location)((Object)game.getFreeColGameObject(this.destinationId));
        }
        return server.getInGameController().setDestination(serverPlayer, unit, destination);
    }

    public Element toXMLElement() {
        Element result = SetDestinationMessage.createNewRootElement(SetDestinationMessage.getXMLElementTagName());
        result.setAttribute("unit", this.unitId);
        if (this.destinationId != null) {
            result.setAttribute("destination", this.destinationId);
        }
        return result;
    }

    public static String getXMLElementTagName() {
        return "setDestination";
    }
}

