/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

public class JoinColonyMessage
extends Message {
    String colonyId;
    String builderId;

    public JoinColonyMessage(Colony colony, Unit builder) {
        this.colonyId = colony.getId();
        this.builderId = builder.getId();
    }

    public JoinColonyMessage(Game game, Element element) {
        this.colonyId = element.getAttribute("colony");
        this.builderId = element.getAttribute("unit");
    }

    public Element handle(FreeColServer server, Player player, Connection connection) {
        Colony colony;
        Unit unit;
        ServerPlayer serverPlayer = server.getPlayer(connection);
        try {
            unit = server.getUnitSafely(this.builderId, serverPlayer);
            colony = (Colony)unit.getGame().getFreeColGameObject(this.colonyId);
        }
        catch (Exception e) {
            return Message.clientError(e.getMessage());
        }
        if (colony == null || unit.getOwner() != colony.getOwner()) {
            return Message.createError("server.buildColony.badUnit", "Unit " + this.builderId + " can not join colony " + colony.getName());
        }
        return server.getInGameController().joinColony(serverPlayer, unit, colony);
    }

    public Element toXMLElement() {
        Element result = JoinColonyMessage.createNewRootElement(JoinColonyMessage.getXMLElementTagName());
        result.setAttribute("colony", this.colonyId);
        result.setAttribute("unit", this.builderId);
        return result;
    }

    public static String getXMLElementTagName() {
        return "joinColony";
    }
}

