/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerGame;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

public class ClaimLandMessage
extends Message {
    private String tileId;
    private String settlementId;
    private String priceString;

    public ClaimLandMessage(Tile tile, Settlement settlement, int price) {
        this.tileId = tile.getId();
        this.settlementId = settlement == null ? null : settlement.getId();
        this.priceString = Integer.toString(price);
    }

    public ClaimLandMessage(Game game, Element element) {
        this.tileId = element.getAttribute("tile");
        this.settlementId = element.hasAttribute("settlement") ? element.getAttribute("settlement") : null;
        this.priceString = element.getAttribute("price");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Element handle(FreeColServer server, Player player, Connection connection) {
        int price;
        Settlement settlement;
        ServerPlayer serverPlayer = server.getPlayer(connection);
        ServerGame game = server.getGame();
        if (!(game.getFreeColGameObjectSafely(this.tileId) instanceof Tile)) {
            return Message.clientError("Invalid tileId");
        }
        Tile tile = (Tile)game.getFreeColGameObjectSafely(this.tileId);
        if (this.settlementId == null) {
            settlement = null;
        } else {
            if (!(game.getFreeColGameObjectSafely(this.settlementId) instanceof Settlement)) return Message.clientError("Invalid settlementId");
            settlement = (Settlement)game.getFreeColGameObjectSafely(this.settlementId);
        }
        try {
            price = Integer.parseInt(this.priceString);
        }
        catch (NumberFormatException e) {
            return Message.clientError("Bad price: " + this.priceString);
        }
        int value = player.getLandPrice(tile);
        Player owner = tile.getOwner();
        Settlement ownerSettlement = tile.getOwningSettlement();
        if (owner == null) {
            price = 0;
            return server.getInGameController().claimLand(serverPlayer, tile, settlement, price);
        } else if (owner == player) {
            if (settlement != null && ownerSettlement != null && ownerSettlement instanceof Colony && ((Colony)ownerSettlement).isTileInUse(tile)) {
                return Message.createError("tileTakenSelf", null);
            }
            price = 0;
            return server.getInGameController().claimLand(serverPlayer, tile, settlement, price);
        } else if (owner.isEuropean()) {
            if (tile.getOwningSettlement() != null && tile.getOwningSettlement() != settlement) return Message.createError("tileTakenEuro", null);
            price = 0;
            return server.getInGameController().claimLand(serverPlayer, tile, settlement, price);
        } else {
            if (price < 0 || price >= value) return server.getInGameController().claimLand(serverPlayer, tile, settlement, price);
            return Message.createError("tileTakenInd", null);
        }
    }

    public Element toXMLElement() {
        Element result = ClaimLandMessage.createNewRootElement(ClaimLandMessage.getXMLElementTagName());
        result.setAttribute("tile", this.tileId);
        if (this.settlementId != null) {
            result.setAttribute("settlement", this.settlementId);
        }
        result.setAttribute("price", this.priceString);
        return result;
    }

    public static String getXMLElementTagName() {
        return "claimLand";
    }
}

