/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

public class BuyGoodsMessage
extends Message {
    private String carrierId;
    private String goodsTypeId;
    private String amountString;

    public BuyGoodsMessage(Unit carrier, GoodsType type, int amount) {
        this.carrierId = carrier.getId();
        this.goodsTypeId = type.getId();
        this.amountString = Integer.toString(amount);
    }

    public BuyGoodsMessage(Game game, Element element) {
        this.carrierId = element.getAttribute("carrier");
        this.goodsTypeId = element.getAttribute("type");
        this.amountString = element.getAttribute("amount");
    }

    public Element handle(FreeColServer server, Player player, Connection connection) {
        int amount;
        Unit carrier;
        ServerPlayer serverPlayer = server.getPlayer(connection);
        try {
            carrier = server.getUnitSafely(this.carrierId, serverPlayer);
        }
        catch (Exception e) {
            return Message.clientError(e.getMessage());
        }
        if (!carrier.canCarryGoods()) {
            return Message.clientError("Not a carrier: " + this.carrierId);
        }
        if (!carrier.isInEurope()) {
            return Message.clientError("Not in Europe: " + this.carrierId);
        }
        GoodsType type = server.getSpecification().getGoodsType(this.goodsTypeId);
        if (type == null) {
            return Message.clientError("Not a goods type: " + this.goodsTypeId);
        }
        if (!player.canTrade(type)) {
            return Message.clientError("Goods are boycotted: " + this.goodsTypeId);
        }
        try {
            amount = Integer.parseInt(this.amountString);
        }
        catch (NumberFormatException e) {
            return Message.clientError("Bad amount: " + this.amountString);
        }
        if (amount <= 0) {
            return Message.clientError("Amount must be positive: " + this.amountString);
        }
        return server.getInGameController().buyGoods(serverPlayer, carrier, type, amount);
    }

    public Element toXMLElement() {
        Element result = BuyGoodsMessage.createNewRootElement(BuyGoodsMessage.getXMLElementTagName());
        result.setAttribute("carrier", this.carrierId);
        result.setAttribute("type", this.goodsTypeId);
        result.setAttribute("amount", this.amountString);
        return result;
    }

    public static String getXMLElementTagName() {
        return "buyGoods";
    }
}

