/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.TradeRoute;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerGame;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

public class AssignTradeRouteMessage
extends Message {
    private String unitId;
    private String tradeRouteId;

    public AssignTradeRouteMessage(Unit unit, TradeRoute tradeRoute) {
        this.unitId = unit.getId();
        this.tradeRouteId = tradeRoute == null ? null : tradeRoute.getId();
    }

    public AssignTradeRouteMessage(Game game, Element element) {
        this.unitId = element.getAttribute("unit");
        this.tradeRouteId = element.hasAttribute("tradeRoute") ? element.getAttribute("tradeRoute") : null;
    }

    public Element handle(FreeColServer server, Connection connection) {
        TradeRoute tradeRoute;
        Unit unit;
        ServerPlayer serverPlayer = server.getPlayer(connection);
        ServerGame game = server.getGame();
        try {
            unit = server.getUnitSafely(this.unitId, serverPlayer);
        }
        catch (Exception e) {
            return Message.clientError(e.getMessage());
        }
        if (unit.getTile() == null) {
            return Message.clientError("Unit is not on the map: " + this.unitId);
        }
        if (this.tradeRouteId == null) {
            tradeRoute = null;
        } else if (game.getFreeColGameObjectSafely(this.tradeRouteId) instanceof TradeRoute) {
            tradeRoute = (TradeRoute)game.getFreeColGameObjectSafely(this.tradeRouteId);
        } else {
            return Message.clientError("Not a trade route: " + this.tradeRouteId);
        }
        return server.getInGameController().assignTradeRoute(serverPlayer, unit, tradeRoute);
    }

    public Element toXMLElement() {
        Element result = AssignTradeRouteMessage.createNewRootElement(AssignTradeRouteMessage.getXMLElementTagName());
        result.setAttribute("unit", this.unitId);
        if (this.tradeRouteId != null) {
            result.setAttribute("tradeRoute", this.tradeRouteId);
        }
        return result;
    }

    public static String getXMLElementTagName() {
        return "assignTradeRoute";
    }
}

