/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Scope;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.UnitType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnitTypeChange
extends FreeColObject {
    private UnitType newUnitType;
    public static final Map<ChangeType, String> tags = new EnumMap<ChangeType, String>(ChangeType.class);
    protected int turnsToLearn = 0;
    protected Map<ChangeType, Integer> changeTypes = new EnumMap<ChangeType, Integer>(ChangeType.class);
    private List<Scope> scopes = new ArrayList<Scope>();

    public UnitTypeChange() {
    }

    public UnitTypeChange(XMLStreamReader in, Specification specification) throws XMLStreamException {
        this.setId(in.getAttributeValue(null, "id"));
        this.readAttributes(in, specification);
        this.readChildren(in, specification);
    }

    public final int getProbability(ChangeType type) {
        Integer result = this.changeTypes.get((Object)type);
        return result == null ? 0 : result;
    }

    public List<Scope> getScopes() {
        return this.scopes;
    }

    public Map<ChangeType, Integer> getChangeTypes() {
        return this.changeTypes;
    }

    public boolean asResultOf(ChangeType type) {
        return this.changeTypes.containsKey((Object)type) && this.changeTypes.get((Object)type) > 0;
    }

    public boolean appliesTo(Player player) {
        if (this.scopes.isEmpty()) {
            return true;
        }
        for (Scope scope : this.scopes) {
            if (!scope.appliesTo(player)) continue;
            return true;
        }
        return false;
    }

    public final int getTurnsToLearn() {
        return this.turnsToLearn;
    }

    public final void setTurnsToLearn(int newTurnsToLearn) {
        this.turnsToLearn = newTurnsToLearn;
    }

    public boolean canBeTaught() {
        return this.asResultOf(ChangeType.EDUCATION) && this.turnsToLearn > 0;
    }

    public final UnitType getNewUnitType() {
        return this.newUnitType;
    }

    public final void setNewUnitType(UnitType newNewUnitType) {
        this.newUnitType = newNewUnitType;
    }

    @Override
    protected void readAttributes(XMLStreamReader in, Specification specification) throws XMLStreamException {
        String newTypeId = in.getAttributeValue(null, "unit");
        if (newTypeId == null) {
            this.newUnitType = null;
        } else {
            this.newUnitType = specification.getType(newTypeId, UnitType.class);
            this.turnsToLearn = this.getAttribute(in, "turnsToLearn", Integer.MIN_VALUE);
            if (this.turnsToLearn > 0) {
                this.changeTypes.put(ChangeType.EDUCATION, 100);
            }
            for (ChangeType type : ChangeType.values()) {
                String value = in.getAttributeValue(null, tags.get((Object)type));
                if (value == null) continue;
                if (value.equalsIgnoreCase("false")) {
                    this.changeTypes.put(type, 0);
                    continue;
                }
                if (value.equalsIgnoreCase("true")) {
                    this.changeTypes.put(type, 100);
                    continue;
                }
                this.changeTypes.put(type, Math.max(0, Math.min(100, new Integer(value))));
            }
        }
    }

    @Override
    public void readChildren(XMLStreamReader in, Specification specification) throws XMLStreamException {
        while (in.nextTag() != 2) {
            String nodeName = in.getLocalName();
            if (!"scope".equals(nodeName)) continue;
            this.scopes.add(new Scope(in));
        }
    }

    @Override
    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        out.writeStartElement(UnitTypeChange.getXMLElementTagName());
        if (this.newUnitType != null) {
            out.writeAttribute("unit", this.newUnitType.getId());
        }
        if (this.turnsToLearn != Integer.MIN_VALUE) {
            out.writeAttribute("turnsToLearn", Integer.toString(this.turnsToLearn));
        }
        for (Map.Entry<ChangeType, Integer> entry : this.changeTypes.entrySet()) {
            out.writeAttribute(tags.get((Object)entry.getKey()), entry.getValue().toString());
        }
        out.writeEndElement();
    }

    public static final String getXMLElementTagName() {
        return "upgrade";
    }

    static {
        tags.put(ChangeType.EDUCATION, "learnInSchool");
        tags.put(ChangeType.NATIVES, "learnFromNatives");
        tags.put(ChangeType.EXPERIENCE, "learnFromExperience");
        tags.put(ChangeType.LOST_CITY, "learnInLostCity");
        tags.put(ChangeType.PROMOTION, "promotion");
        tags.put(ChangeType.CLEAR_SKILL, "clearSkill");
        tags.put(ChangeType.DEMOTION, "demotion");
        tags.put(ChangeType.CAPTURE, "capture");
        tags.put(ChangeType.CREATION, "creation");
        tags.put(ChangeType.ENTER_COLONY, "enterColony");
        tags.put(ChangeType.INDEPENDENCE, "independence");
        tags.put(ChangeType.UNDEAD, "undead");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ChangeType {
        EDUCATION,
        NATIVES,
        EXPERIENCE,
        LOST_CITY,
        PROMOTION,
        CREATION,
        ENTER_COLONY,
        INDEPENDENCE,
        CLEAR_SKILL,
        DEMOTION,
        CAPTURE,
        UNDEAD;

    }
}

