/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import net.sf.freecol.common.model.StringTemplate;

public class Turn {
    public static final int STARTING_YEAR = 1492;
    public static final int SEASON_YEAR = 1600;
    private static final int OFFSET = 107;
    private int turn;

    public Turn(int turn) {
        this.turn = turn;
    }

    public Turn next() {
        return new Turn(this.turn + 1);
    }

    public int getNumber() {
        return this.turn;
    }

    public int getAge() {
        if (this.getYear() < 1600) {
            return 1;
        }
        if (this.getYear() < 1700) {
            return 2;
        }
        return 3;
    }

    public boolean equals(Object o) {
        if (o instanceof Turn) {
            return this.turn == ((Turn)o).turn;
        }
        return false;
    }

    public static int getYear(int turn) {
        int c = turn - 107;
        if (c < 0) {
            return 1492 + turn - 1;
        }
        return 1600 + c / 2 - 1;
    }

    public int getYear() {
        return Turn.getYear(this.turn);
    }

    public String toString() {
        return Turn.toString(this.turn);
    }

    public static String toString(int turn) {
        return Turn.getSeason(turn).toString() + " " + Integer.toString(Turn.getYear(turn));
    }

    public static Season getSeason(int turn) {
        int c = turn - 107;
        if (c <= 1) {
            return Season.YEAR;
        }
        if (c % 2 == 0) {
            return Season.SPRING;
        }
        return Season.AUTUMN;
    }

    public Season getSeason() {
        return Turn.getSeason(this.turn);
    }

    public StringTemplate getLabel() {
        return Turn.getLabel(this.turn);
    }

    public static StringTemplate getLabel(int turn) {
        return StringTemplate.template("year." + (Object)((Object)Turn.getSeason(turn))).addAmount("%year%", Turn.getYear(turn));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Season {
        YEAR,
        SPRING,
        AUTUMN;

    }
}

