/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.GoodsType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProductionMap {
    private Map<GoodsType, Object> cache = new HashMap<GoodsType, Object>();

    public AbstractGoods get(GoodsType type) {
        Object value = this.cache.get(type);
        if (value == null) {
            return new AbstractGoods(type, 0);
        }
        if (value instanceof Integer) {
            return new AbstractGoods(type, (Integer)value);
        }
        return ((ProductionTree)value).get(type);
    }

    public void add(AbstractGoods goods) {
        GoodsType goodsType = goods.getType();
        Object value = this.cache.get(goodsType);
        if (value == null) {
            GoodsType rootType = goodsType.getStoredAs();
            if (rootType == goodsType) {
                this.cache.put(goodsType, goods.getAmount());
            } else {
                value = this.cache.get(rootType);
                if (value instanceof ProductionTree) {
                    ((ProductionTree)value).add(goods);
                } else {
                    Integer amount = value == null ? 0 : (Integer)value;
                    value = new ProductionTree(new AbstractGoods(rootType, amount), goods);
                    this.cache.put(rootType, value);
                }
                this.cache.put(goodsType, value);
            }
        } else if (value instanceof Integer) {
            this.cache.put(goodsType, (Integer)value + goods.getAmount());
        } else {
            ((ProductionTree)value).add(goods);
        }
    }

    public void remove(AbstractGoods goods) {
        Object value = this.cache.get(goods.getType());
        if (value instanceof ProductionTree) {
            ((ProductionTree)value).remove(goods);
        } else {
            this.add(new AbstractGoods(goods.getType(), -goods.getAmount()));
        }
    }

    public void add(List<AbstractGoods> goods) {
        for (AbstractGoods g : goods) {
            this.add(g);
        }
    }

    public void remove(List<AbstractGoods> goods) {
        for (AbstractGoods g : goods) {
            this.remove(g);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ProductionTree {
        private AbstractGoods root;
        private List<AbstractGoods> leafs;

        public ProductionTree(AbstractGoods root, AbstractGoods ... leafs) {
            if (leafs.length > 0) {
                this.leafs = new ArrayList<AbstractGoods>();
                int amount = root.getAmount();
                for (AbstractGoods leaf : leafs) {
                    this.leafs.add(new AbstractGoods(leaf));
                    amount += leaf.getAmount();
                }
                this.root = new AbstractGoods(root.getType(), amount);
            } else {
                this.root = new AbstractGoods(root);
            }
        }

        public final AbstractGoods getRoot() {
            return this.root;
        }

        public final void setRoot(AbstractGoods newRoot) {
            this.root = newRoot;
        }

        public final List<AbstractGoods> getLeafs() {
            return this.leafs;
        }

        public final void setLeafs(List<AbstractGoods> newLeafs) {
            this.leafs = newLeafs;
        }

        public void add(AbstractGoods goods) {
            if (goods.getType().getStoredAs() != this.root.getType()) {
                throw new IllegalArgumentException(goods.getType().getId() + " is not stored as " + this.root.getType());
            }
            for (AbstractGoods leaf : this.leafs) {
                if (leaf.getType() != goods.getType()) continue;
                leaf.setAmount(leaf.getAmount() + goods.getAmount());
                this.root.setAmount(this.root.getAmount() + goods.getAmount());
                return;
            }
            this.leafs.add(new AbstractGoods(goods));
            this.root.setAmount(this.root.getAmount() + goods.getAmount());
        }

        public int remove(AbstractGoods goods) {
            int consumed = goods.getAmount();
            if (goods.getType() == this.root.getType()) {
                if (consumed > this.root.getAmount()) {
                    consumed = this.root.getAmount();
                    this.root.setAmount(0);
                } else {
                    this.root.setAmount(this.root.getAmount() - consumed);
                }
                for (AbstractGoods leaf : this.leafs) {
                    leaf.setAmount(Math.min(leaf.getAmount(), this.root.getAmount()));
                }
            } else {
                for (AbstractGoods leaf : this.leafs) {
                    if (leaf.getType() != goods.getType()) continue;
                    if (consumed > leaf.getAmount()) {
                        consumed = leaf.getAmount();
                        leaf.setAmount(0);
                    } else {
                        leaf.setAmount(leaf.getAmount() - consumed);
                    }
                    this.root.setAmount(this.root.getAmount() - consumed);
                    break;
                }
            }
            return consumed;
        }

        public AbstractGoods get(GoodsType type) {
            if (this.root.getType() == type) {
                return this.root;
            }
            for (AbstractGoods leaf : this.leafs) {
                if (leaf.getType() != type) continue;
                return new AbstractGoods(type, leaf.getAmount());
            }
            return null;
        }
    }
}

