/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.LostCityRumour;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Resource;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovement;
import net.sf.freecol.common.model.TileItem;
import net.sf.freecol.common.model.TileItemContainer;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlayerExploredTile
extends FreeColGameObject {
    private static final Logger logger = Logger.getLogger(PlayerExploredTile.class.getName());
    private Player player;
    private Tile tile;
    private Player owner;
    private Settlement owningSettlement;
    private List<TileItem> tileItems;
    private int colonyUnitCount = 0;
    private String colonyStockadeKey = null;
    private UnitType skill = null;
    private GoodsType[] wantedGoods = new GoodsType[]{null, null, null};
    private Unit missionary = null;

    public PlayerExploredTile(Game game, Player player, Tile tile) {
        super(game);
        this.player = player;
        this.tile = tile;
    }

    public PlayerExploredTile(Game game, XMLStreamReader in) throws XMLStreamException {
        super(game, in);
        this.readFromXML(in);
    }

    public void update(boolean full) {
        IndianSettlement is;
        Colony colony;
        this.owner = this.tile.getOwner();
        this.owningSettlement = this.tile.getOwningSettlement();
        this.tileItems = new ArrayList<TileItem>();
        TileItemContainer tic = this.tile.getTileItemContainer();
        if (tic != null) {
            this.tileItems.addAll(tic.getImprovements());
            if (tic.getResource() != null) {
                this.tileItems.add(tic.getResource());
            }
            if (tic.getLostCityRumour() != null) {
                this.tileItems.add(tic.getLostCityRumour());
            }
        }
        if ((colony = this.tile.getColony()) != null) {
            this.colonyUnitCount = colony.getUnitCount();
            this.colonyStockadeKey = colony.getTrueStockadeKey();
            this.missionary = null;
        }
        if ((is = this.tile.getIndianSettlement()) != null) {
            this.colonyUnitCount = 0;
            this.colonyStockadeKey = null;
            this.missionary = is.getMissionary();
            if (full) {
                this.skill = is.getLearnableSkill();
                this.wantedGoods = is.getWantedGoods();
            }
        }
    }

    public Player getOwner() {
        return this.owner;
    }

    public Settlement getOwningSettlement() {
        return this.owningSettlement;
    }

    public List<TileItem> getAllTileItems() {
        return new ArrayList<TileItem>(this.tileItems);
    }

    public int getColonyUnitCount() {
        return this.colonyUnitCount;
    }

    public String getColonyStockadeKey() {
        return this.colonyStockadeKey;
    }

    public Unit getMissionary() {
        return this.missionary;
    }

    public UnitType getSkill() {
        return this.skill;
    }

    public GoodsType[] getWantedGoods() {
        return this.wantedGoods;
    }

    public void setOwner(Player owner) {
        this.owner = owner;
    }

    public void setOwningSettlement(Settlement owningSettlement) {
        this.owningSettlement = owningSettlement;
    }

    public void setColonyUnitCount(int colonyUnitCount) {
        this.colonyUnitCount = colonyUnitCount;
    }

    public void setColonyStockadeKey(String colonyStockadeKey) {
        this.colonyStockadeKey = colonyStockadeKey;
    }

    public void setMissionary(Unit missionary) {
        this.missionary = missionary;
    }

    @Override
    public void toXMLImpl(XMLStreamWriter out, Player player, boolean showAll, boolean toSavedGame) throws XMLStreamException {
        Settlement settlement;
        out.writeStartElement(PlayerExploredTile.getXMLElementTagName());
        out.writeAttribute("ID", this.getId());
        out.writeAttribute("player", player.getId());
        out.writeAttribute("tile", this.tile.getId());
        if (this.tile.getOwner() != this.owner && this.owner != null) {
            out.writeAttribute("owner", this.owner.getId());
        }
        if (this.owningSettlement != null) {
            out.writeAttribute("owningSettlement", this.owningSettlement.getId());
        }
        if ((settlement = this.tile.getSettlement()) instanceof Colony) {
            out.writeAttribute("colonyUnitCount", Integer.toString(this.colonyUnitCount));
            if (this.colonyStockadeKey != null) {
                out.writeAttribute("colonyStockadeKey", this.colonyStockadeKey);
            }
        } else if (settlement instanceof IndianSettlement) {
            this.writeAttribute(out, "learnableSkill", this.skill);
            this.writeAttribute(out, "wantedGoods0", this.wantedGoods[0]);
            this.writeAttribute(out, "wantedGoods1", this.wantedGoods[1]);
            this.writeAttribute(out, "wantedGoods2", this.wantedGoods[2]);
            if (this.missionary != null) {
                out.writeStartElement("missionary");
                this.missionary.toXML(out, player, showAll, toSavedGame);
                out.writeEndElement();
            }
        } else if (settlement != null) {
            throw new IllegalStateException("Bogus settlement");
        }
        for (TileItem ti : this.tileItems) {
            ti.toXML(out, player, showAll, toSavedGame);
        }
        out.writeEndElement();
    }

    @Override
    public void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        Specification spec = this.getSpecification();
        Game game = this.getGame();
        this.setId(in.getAttributeValue(null, "ID"));
        this.player = this.getFreeColGameObject(in, "player", Player.class);
        this.tile = this.getFreeColGameObject(in, "tile", Tile.class);
        this.owner = this.getFreeColGameObject(in, "owner", Player.class, this.tile.getOwner());
        this.owningSettlement = this.getFreeColGameObject(in, "owningSettlement", Settlement.class, null);
        this.colonyUnitCount = this.getAttribute(in, "colonyUnitCount", 0);
        this.colonyStockadeKey = in.getAttributeValue(null, "colonyStockadeKey");
        this.skill = spec.getType(in, "learnableSkill", UnitType.class, null);
        this.wantedGoods[0] = spec.getType(in, "wantedGoods0", GoodsType.class, null);
        this.wantedGoods[1] = spec.getType(in, "wantedGoods1", GoodsType.class, null);
        this.wantedGoods[2] = spec.getType(in, "wantedGoods2", GoodsType.class, null);
        this.missionary = null;
        this.tileItems = new ArrayList<TileItem>();
        while (in.nextTag() != 2) {
            if (in.getLocalName().equals("missionary")) {
                in.nextTag();
                this.missionary = this.updateFreeColGameObject(in, Unit.class);
                in.nextTag();
                continue;
            }
            if (in.getLocalName().equals(Resource.getXMLElementTagName())) {
                Resource resource = (Resource)game.getFreeColGameObject(in.getAttributeValue(null, "ID"));
                if (resource != null) {
                    resource.readFromXML(in);
                } else {
                    resource = new Resource(game, in);
                }
                this.tileItems.add(resource);
                continue;
            }
            if (in.getLocalName().equals(LostCityRumour.getXMLElementTagName())) {
                LostCityRumour lostCityRumour = (LostCityRumour)game.getFreeColGameObject(in.getAttributeValue(null, "ID"));
                if (lostCityRumour != null) {
                    lostCityRumour.readFromXML(in);
                } else {
                    lostCityRumour = new LostCityRumour(game, in);
                }
                this.tileItems.add(lostCityRumour);
                continue;
            }
            if (in.getLocalName().equals(TileImprovement.getXMLElementTagName())) {
                TileImprovement ti = (TileImprovement)game.getFreeColGameObject(in.getAttributeValue(null, "ID"));
                if (ti != null) {
                    ti.readFromXML(in);
                } else {
                    ti = new TileImprovement(game, in);
                }
                this.tileItems.add(ti);
                continue;
            }
            logger.warning("Unknown tag: " + in.getLocalName() + " loading PlayerExploredTile");
            in.nextTag();
        }
    }

    public static String getXMLElementTagName() {
        return "playerExploredTile";
    }
}

