/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.CombatModel;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Unit;
import org.w3c.dom.Element;

public class NationSummary
extends FreeColObject {
    private String numberOfSettlements;
    private String numberOfUnits;
    private String militaryStrength;
    private String navalStrength;
    private String stance;
    private String gold;
    private String soL;
    private String foundingFathers;
    private String tax;

    public NationSummary(Player player, Player requester) {
        this.setId("");
        this.numberOfSettlements = Integer.toString(player.getSettlements().size());
        Player.Stance sta = player.getStance(requester);
        this.stance = (sta == Player.Stance.UNCONTACTED ? Player.Stance.PEACE : sta).toString();
        if (player.isEuropean()) {
            CombatModel cm = player.getGame().getCombatModel();
            int nUnits = 0;
            int sMilitary = 0;
            int sNaval = 0;
            for (Unit unit : player.getUnits()) {
                ++nUnits;
                if (unit.isNaval()) {
                    sNaval = (int)((float)sNaval + cm.getOffencePower(unit, null));
                    continue;
                }
                sMilitary = (int)((float)sMilitary + cm.getOffencePower(unit, null));
            }
            this.numberOfUnits = Integer.toString(nUnits);
            this.militaryStrength = Integer.toString(sMilitary);
            this.navalStrength = Integer.toString(sNaval);
            this.gold = Integer.toString(player.getGold());
            if (player == requester || requester.hasAbility("model.ability.betterForeignAffairsReport")) {
                this.soL = Integer.toString(player.getSoL());
                this.foundingFathers = Integer.toString(player.getFatherCount());
                this.tax = String.valueOf(player.getTax());
            } else {
                this.soL = null;
                this.foundingFathers = null;
                this.tax = null;
            }
        } else {
            this.gold = "-1";
            this.navalStrength = "-1";
            this.militaryStrength = "-1";
            this.numberOfUnits = "-1";
            this.tax = null;
            this.foundingFathers = null;
            this.soL = null;
        }
    }

    public NationSummary(Element element) {
        this.readFromXMLElement(element);
    }

    public String getNumberOfSettlements() {
        return this.numberOfSettlements;
    }

    public String getNumberOfUnits() {
        return this.numberOfUnits;
    }

    public String getMilitaryStrength() {
        return this.militaryStrength;
    }

    public String getNavalStrength() {
        return this.navalStrength;
    }

    public Player.Stance getStance() {
        return Enum.valueOf(Player.Stance.class, this.stance);
    }

    public int getGold() {
        return Integer.parseInt(this.gold);
    }

    public String getFoundingFathers() {
        return this.foundingFathers;
    }

    public String getSoL() {
        return this.soL;
    }

    public String getTax() {
        return this.tax;
    }

    public void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        super.toXML(out, NationSummary.getXMLElementTagName());
    }

    public void writeAttributes(XMLStreamWriter out) throws XMLStreamException {
        super.writeAttributes(out);
        out.writeAttribute("numberOfSettlements", this.numberOfSettlements);
        out.writeAttribute("numberOfUnits", this.numberOfUnits);
        out.writeAttribute("militaryStrength", this.militaryStrength);
        out.writeAttribute("navalStrength", this.navalStrength);
        out.writeAttribute("stance", this.stance);
        out.writeAttribute("gold", this.gold);
        if (this.soL != null) {
            out.writeAttribute("SoL", this.soL);
        }
        if (this.foundingFathers != null) {
            out.writeAttribute("foundingFathers", this.foundingFathers);
        }
        if (this.tax != null) {
            out.writeAttribute("tax", this.tax);
        }
    }

    public void readAttributes(XMLStreamReader in) throws XMLStreamException {
        super.readAttributes(in);
        this.numberOfSettlements = this.getAttribute(in, "numberOfSettlements", "");
        this.numberOfUnits = this.getAttribute(in, "numberOfUnits", "");
        this.militaryStrength = this.getAttribute(in, "militaryStrength", "");
        this.navalStrength = this.getAttribute(in, "navalStrength", "");
        this.stance = this.getAttribute(in, "stance", "");
        this.gold = this.getAttribute(in, "gold", "");
        this.soL = in.getAttributeValue(null, "SoL");
        this.foundingFathers = in.getAttributeValue(null, "foundingFathers");
        this.tax = in.getAttributeValue(null, "tax");
    }

    public static String getXMLElementTagName() {
        return "nationSummary";
    }
}

