/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.FreeColGameObjectType;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Scope;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Turn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Feature
extends FreeColObject {
    private FreeColGameObjectType source;
    private Turn firstTurn;
    private Turn lastTurn;
    private List<Scope> scopes;

    public final boolean hasTimeLimit() {
        return this.firstTurn != null || this.lastTurn != null;
    }

    public final boolean hasScope() {
        return this.scopes != null && !this.scopes.isEmpty();
    }

    public String getNameKey() {
        return this.getId() + ".name";
    }

    public final List<Scope> getScopes() {
        return this.scopes;
    }

    public final void setScopes(List<Scope> newScopes) {
        this.scopes = newScopes;
    }

    public final Turn getFirstTurn() {
        return this.firstTurn;
    }

    public final void setFirstTurn(Turn newFirstTurn) {
        this.firstTurn = newFirstTurn;
    }

    public final Turn getLastTurn() {
        return this.lastTurn;
    }

    public final void setLastTurn(Turn newLastTurn) {
        this.lastTurn = newLastTurn;
    }

    public final FreeColGameObjectType getSource() {
        return this.source;
    }

    public final void setSource(FreeColGameObjectType newSource) {
        this.source = newSource;
    }

    public boolean appliesTo(FreeColGameObjectType objectType) {
        if (!this.hasScope()) {
            return true;
        }
        for (Scope scope : this.scopes) {
            if (!scope.appliesTo(objectType)) continue;
            return true;
        }
        return false;
    }

    public boolean appliesTo(FreeColGameObjectType objectType, Turn turn) {
        if (turn != null && (this.firstTurn != null && turn.getNumber() < this.firstTurn.getNumber() || this.lastTurn != null && turn.getNumber() > this.lastTurn.getNumber())) {
            return false;
        }
        return this.appliesTo(objectType);
    }

    public boolean isOutOfDate(Turn turn) {
        return turn != null && this.lastTurn != null && turn.getNumber() > this.lastTurn.getNumber();
    }

    public int hashCode() {
        int hash = 7;
        hash += 31 * hash + (this.getId() == null ? 0 : this.getId().hashCode());
        hash += 31 * hash + (this.source == null ? 0 : this.source.hashCode());
        hash += 31 * hash + (this.firstTurn == null ? 0 : this.firstTurn.getNumber());
        hash += 31 * hash + (this.lastTurn == null ? 0 : this.lastTurn.getNumber());
        if (this.scopes != null) {
            for (Scope scope : this.scopes) {
                hash += scope.hashCode();
            }
        }
        return hash;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Feature) {
            Feature feature = (Feature)o;
            if (this.getId() == null) {
                if (feature.getId() != null) {
                    return false;
                }
            } else {
                if (feature.getId() == null) {
                    return false;
                }
                if (!this.getId().equals(feature.getId())) {
                    return false;
                }
            }
            if (this.source != feature.source) {
                return false;
            }
            if (this.firstTurn == null) {
                if (feature.firstTurn != null) {
                    return false;
                }
            } else {
                if (feature.firstTurn == null) {
                    return false;
                }
                if (this.firstTurn.getNumber() != feature.firstTurn.getNumber()) {
                    return false;
                }
            }
            if (this.scopes == null) {
                if (feature.scopes != null) {
                    return false;
                }
            } else {
                if (feature.scopes == null) {
                    return false;
                }
                for (Scope scope : this.scopes) {
                    if (feature.scopes.contains(scope)) continue;
                    return false;
                }
                for (Scope scope : feature.scopes) {
                    if (this.scopes.contains(scope)) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    protected void copy(Feature other) {
        this.setId(other.getId());
        this.source = other.source;
        this.firstTurn = other.firstTurn;
        this.lastTurn = other.lastTurn;
        this.setScopes(other.getScopes());
    }

    @Override
    protected void writeAttributes(XMLStreamWriter out) throws XMLStreamException {
        super.writeAttributes(out);
        if (this.getSource() != null) {
            out.writeAttribute("source", this.getSource().getId());
        }
        if (this.getFirstTurn() != null) {
            out.writeAttribute("firstTurn", String.valueOf(this.getFirstTurn().getNumber()));
        }
        if (this.getLastTurn() != null) {
            out.writeAttribute("lastTurn", String.valueOf(this.getLastTurn().getNumber()));
        }
    }

    @Override
    protected void writeChildren(XMLStreamWriter out) throws XMLStreamException {
        if (this.getScopes() != null) {
            for (Scope scope : this.getScopes()) {
                scope.toXMLImpl(out);
            }
        }
    }

    @Override
    protected void readAttributes(XMLStreamReader in, Specification specification) throws XMLStreamException {
        String lastTurn;
        if (in.getAttributeValue(null, "id") == null && "model.colony.colonyGoodsParty".equals(in.getAttributeValue(null, "source"))) {
            this.setId("model.modifier.colonyGoodsParty");
            this.setSource(specification.getType("model.source.colonyGoodsParty"));
        } else {
            super.readAttributes(in, specification);
            String sourceId = in.getAttributeValue(null, "source");
            if (sourceId == null) {
                this.setSource(null);
            } else if (sourceId.equals("model.monarch.colonyGoodsParty")) {
                this.setSource(specification.getType("model.source.colonyGoodsParty"));
            } else if (specification != null) {
                this.setSource(specification.getType(sourceId));
            }
        }
        String firstTurn = in.getAttributeValue(null, "firstTurn");
        if (firstTurn != null) {
            this.setFirstTurn(new Turn(Integer.parseInt(firstTurn)));
        }
        if ((lastTurn = in.getAttributeValue(null, "lastTurn")) != null) {
            this.setLastTurn(new Turn(Integer.parseInt(lastTurn)));
        }
    }

    @Override
    protected void readChildren(XMLStreamReader in, Specification specification) throws XMLStreamException {
        while (in.nextTag() != 2) {
            String childName = in.getLocalName();
            if (Scope.getXMLElementTagName().equals(childName)) {
                Scope scope = new Scope(in);
                if (this.getScopes() == null) {
                    this.setScopes(new ArrayList<Scope>());
                }
                this.getScopes().add(scope);
                continue;
            }
            logger.finest("Parsing of " + childName + " is not implemented yet");
            while (in.nextTag() != 2 || !in.getLocalName().equals(childName)) {
                in.nextTag();
            }
        }
    }
}

